/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.MissingJsonValueException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.sys.BajaRuntimeException;

public interface JsonKeyExtractUtil {
    public static final int SHORTEST_VIABLE_JSON_MESSAGE = 3;
    public static final Pattern WHITESPACE = Pattern.compile("[\t\n\r]");
    public static final Logger log = Log.child("JsonKeyExtract");

    default public Object lookupKey(String message, Logger log, boolean allowEmptyValue, String key) {
        Object[] ret = this.lookupKeys(message, log, allowEmptyValue, key);
        return ret != null ? ret[0] : null;
    }

    default public Object[] lookupKeys(String message, Logger log, boolean allowMissingValue, String ... keys) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("lookupKeys asked to find " + keys.length + " keys");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Object token = new JSONTokener(message).nextValue();
            if (token instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)token;
                for (String k : keys) {
                    Object value = jsonObject.get(k);
                    if (value == null) {
                        if (log.isLoggable(Level.FINE)) {
                            String msg = "Extracted *null* for key: " + k + " from " + this.loggableJson(message);
                            log.fine(msg);
                        }
                        if (!allowMissingValue) {
                            throw new MissingJsonValueException(k);
                        }
                    }
                    result.add(value);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("lookupKeys extracted: " + k + " : " + value);
                }
            } else if (!allowMissingValue) {
                throw new MissingJsonValueException();
            }
        }
        catch (JSONException je) {
            log.log(Level.WARNING, String.format("Failed to extract keys: [%s] from [%s]", String.join((CharSequence)",", keys), this.loggableJson(message)));
            return null;
        }
        Object[] returnObjects = result.toArray();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("lookupKeys found " + returnObjects.length);
        }
        return returnObjects;
    }

    default public Map<String, Object> lookupKeyValues(String message, Logger log, String ... keys) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("lookupKeyValues asked to find " + keys.length + " keys");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object value = new JSONTokener(message).nextValue();
        if (value instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)value;
            for (String key : keys) {
                try {
                    result.put(key, jsonObject.get(key));
                }
                catch (JSONException e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Extracted *null* for key: " + key + " from " + this.loggableJson(message));
                    }
                    result.put(key, null);
                }
            }
        }
        return result;
    }

    default public Map<String, Object> lookupKeyValues(String message) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = new JSONTokener(message).nextValue();
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                result.put(key, jsonObject.get(key));
            }
        }
        return result;
    }

    default public boolean hasKey(String message, Logger log, String key) {
        boolean result;
        Object object = new JSONTokener(message).nextValue();
        boolean bl = result = object instanceof JSONObject && ((JSONObject)object).has(key);
        if (log.isLoggable(Level.FINE)) {
            log.fine(object.toString() + " has " + key + " = " + result);
        }
        return result;
    }

    default public Object atArrayIndex(String message, Logger log, int index) {
        Object o;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("atArrayIndex asked to find " + index + " from " + this.loggableJson(message));
        }
        if ((o = new JSONTokener(message).nextValue()) instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            Object result = array.get(index);
            if (log.isLoggable(Level.FINE)) {
                log.fine(array.toString() + " idx " + index + " = " + result);
            }
            return result;
        }
        return null;
    }

    default public int indexOfKey(String message, String key, Logger log) {
        Object o;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("indexOfKey asked to find " + key + " from " + this.loggableJson(message));
        }
        if ((o = new JSONTokener(message).nextValue()) instanceof JSONObject) {
            Iterator keys = ((JSONObject)o).keys();
            int index = 0;
            while (keys.hasNext()) {
                if (key.equals(keys.next().toString())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    default public <T> T parse(String message, Class<T> expectedType) {
        Object value = new JSONTokener(message).nextValue();
        if (value.getClass().isAssignableFrom(expectedType)) {
            return expectedType.cast(value);
        }
        throw new JSONException(String.format("Expected json type %s but found %s", expectedType, value.getClass().getSimpleName()));
    }

    default public void sanityCheck(String msg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Json Extractor receives: " + msg);
        }
        if (msg.length() < 3) {
            this.failSanity("JSON input too short to extract from ", msg);
        }
        if ('{' != msg.charAt(0) && '[' != msg.charAt(0)) {
            this.failSanity("JSON input should begin with { or [, not " + msg.charAt(0) + ". ", msg);
        }
    }

    default public void failSanity(String why, String msg) {
        BajaRuntimeException ae = new BajaRuntimeException(why + msg);
        log.log(Level.WARNING, ae.getMessage(), ae);
        throw ae;
    }

    default public String loggableJson(String message) {
        String loggable = message.length() > 60 ? message.substring(0, 60) : message;
        return WHITESPACE.matcher(loggable).replaceAll("");
    }
}

