/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.proofOfConcept.tools;

import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ThreadPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="int", defaultValue="0", flags=11), @NiagaraProperty(name="query", type="BOrd", defaultValue="BOrd.make(\"slot:/|bql:select count(*) from jsonToolkit:JsonExportMarker\")")})
@NiagaraAction(name="execute", flags=2064)
public class BCountBql
extends BComponent {
    public static final Property out = BCountBql.newProperty((int)11, (int)0, null);
    public static final Property query = BCountBql.newProperty((int)0, (BValue)BOrd.make((String)"slot:/|bql:select count(*) from jsonToolkit:JsonExportMarker"), null);
    public static final Action execute = BCountBql.newAction((int)2064, null);
    public static final Type TYPE = Sys.loadType(BCountBql.class);
    private static final Logger log = Log.child("pointReport");
    private static final String CELL = "|cell:0,0";

    public int getOut() {
        return this.getInt(out);
    }

    public void setOut(int v) {
        this.setInt(out, v, null);
    }

    public BOrd getQuery() {
        return (BOrd)this.get(query);
    }

    public void setQuery(BOrd v) {
        this.set(query, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doExecute() {
        BInteger c;
        BOrd o = BOrd.make((String)(this.getQuery() + CELL));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Counting " + this.getName() + ' ' + o);
        }
        try {
            BObject r = o.get((BObject)Sys.getStation());
            c = (BInteger)r;
        }
        catch (IndexOutOfBoundsException | NullPointerException npe) {
            c = BInteger.make((int)0);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Count from bql " + this.getName(), npe);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Running point report count", e);
            throw e;
        }
        log.info(this.getName() + " Bql Count Found " + c);
        this.setOut(c.getInt());
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(query)) {
            this.execute();
        }
    }

    public void started() {
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() {
        this.execute();
    }

    public IFuture post(Action action, BValue argument, Context context) {
        return ThreadPool.post(this, action, argument, context);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"calculator.png");
    }
}

