/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support.exporter;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.util.Log;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"jsonToolkit:JsonSchema"})})
public class BJsonExporter
extends BExporter {
    public static final Type TYPE = Sys.loadType(BJsonExporter.class);
    private static final Logger log = Log.child(TYPE.getTypeName());

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "json";
    }

    public void export(ExportOp op) {
        BJsonSchema schema = (BJsonSchema)op.get();
        try (OutputStreamWriter osw = new OutputStreamWriter(op.getOutputStream(), StandardCharsets.UTF_8);){
            osw.write(schema.getOutput());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exporting Schema " + schema.getName(), e);
        }
    }

    public BIcon getIcon() {
        return BIcon.std((String)"braces.png");
    }
}

