/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BSSOConfiguration;
import com.tridium.bql.util.BqlUtil;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.program.BProgram;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaConfigFolder;
import com.tridiumx.jsonToolkit.outbound.schema.support.ExcludedJsonTypeException;
import com.tridiumx.jsonToolkit.outbound.schema.support.UnsupportedConversionTypeException;
import com.tridiumx.jsonToolkit.util.Log;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryService;
import javax.baja.control.BControlPoint;
import javax.baja.naming.OrdTarget;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebService;

public final class JsonSchemaUtil {
    public static final Logger logger = Log.child("jsonSchema");
    private static final String EXCLUDED_SUBSTITUTE = "";

    private JsonSchemaUtil() {
    }

    public static BValue toBValue(Object value) throws UnsupportedConversionTypeException {
        BValue result;
        if (value instanceof BValue) {
            result = ((BValue)value).newCopy();
        } else if (value instanceof String) {
            result = BString.make((String)value.toString());
        } else if (value instanceof Double) {
            result = BDouble.make((double)((Double)value));
        } else if (value instanceof Integer) {
            result = BInteger.make((int)((Integer)value));
        } else if (value instanceof Float) {
            result = BFloat.make((float)((Float)value).floatValue());
        } else if (value instanceof Long) {
            result = BLong.make((long)((Long)value));
        } else if (value instanceof Boolean) {
            result = BBoolean.make((boolean)((Boolean)value));
        } else if (value instanceof Number) {
            Number number = (Number)value;
            result = BDouble.make((double)number.doubleValue());
        } else {
            UnsupportedConversionTypeException unsupportedConvEx = new UnsupportedConversionTypeException("Currently unsupported conversion type: " + value.getClass().getName());
            logger.log(Level.WARNING, "Consider adding an override to process unsupported types", unsupportedConvEx);
            throw unsupportedConvEx;
        }
        return result;
    }

    public static void checkExcludedValue(Object value) throws ExcludedJsonTypeException {
        if (BqlUtil.excludeFromResults((Object)value) || JsonSchemaUtil.excludeFromEgress(value)) {
            String msg = "Filtering instance of " + (value instanceof BObject ? ((BObject)value).getType().getDisplayName(Context.NULL) : value.getClass().getName());
            ExcludedJsonTypeException e = new ExcludedJsonTypeException(msg);
            logger.log(Level.WARNING, "Removing Excluded type ", e);
            throw e;
        }
    }

    public static boolean excludeFromEgress(Object resultCandidate) {
        return resultCandidate instanceof BIUnlinkable || resultCandidate instanceof BProgram || resultCandidate instanceof BUserService || resultCandidate instanceof BUser || resultCandidate instanceof BAuditHistoryService || resultCandidate instanceof BCategoryService || resultCandidate instanceof BCategory || resultCandidate instanceof BRoleService || resultCandidate instanceof BRole || resultCandidate instanceof BWebService || resultCandidate instanceof BAuthenticationSchemeFolder || resultCandidate instanceof BGlobalPasswordConfiguration || resultCandidate instanceof BUserPasswordConfiguration || resultCandidate instanceof BPasswordStrength || resultCandidate instanceof BSSOConfiguration || resultCandidate instanceof BAuthenticationScheme;
    }

    public static Object toJsonType(Object value, BJsonSchemaConfigFolder config) {
        if (Objects.isNull((Object)config)) {
            throw new BajaRuntimeException("toJsonType required a reference to the Schema config");
        }
        if (value == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Replacing null with \"\"");
            }
            return EXCLUDED_SUBSTITUTE;
        }
        try {
            JsonSchemaUtil.checkExcludedValue(value);
            BValue v = value instanceof BValue ? ((BValue)value).newCopy() : JsonSchemaUtil.toBValue(value);
            if (v != null) {
                BValue overridden = config.getOverrides().processOverrides(v);
                JsonSchemaUtil.checkExcludedValue(overridden);
                if (!overridden.equals((Object)v)) {
                    return overridden;
                }
                if (v instanceof BInteger) {
                    return ((BInteger)v).getInt();
                }
                if (v instanceof BLong) {
                    return ((BLong)v).getLong();
                }
                if (v instanceof BNumber) {
                    return JsonSchemaUtil.decimalToJsonType(v, config);
                }
                if (v instanceof BBoolean) {
                    return ((BBoolean)v).getBoolean();
                }
                if (v instanceof BControlPoint) {
                    return JsonSchemaUtil.toJsonType(((BControlPoint)v).getStatusValue(), config);
                }
                if (v instanceof BStatusValue) {
                    return JsonSchemaUtil.toJsonType(((BStatusValue)v).getValueValue(), config);
                }
                if (v instanceof BAbsTime) {
                    return config.formatTime((BAbsTime)v);
                }
                return v.toString();
            }
        }
        catch (ExcludedJsonTypeException ex) {
            return EXCLUDED_SUBSTITUTE;
        }
        catch (UnsupportedConversionTypeException unsupportedConversionTypeException) {
            // empty catch block
        }
        return value.toString();
    }

    private static Object decimalToJsonType(Object value, BJsonSchemaConfigFolder config) {
        if (value == BDouble.NEGATIVE_INFINITY || value == BFloat.NEGATIVE_INFINITY) {
            return Double.MIN_VALUE;
        }
        if (value == BDouble.POSITIVE_INFINITY || value == BFloat.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (value == BFloat.NaN || value == BDouble.NaN) {
            return 0.0;
        }
        double doubleValue = ((BNumber)value).getDouble();
        return config != null ? new BigDecimal(doubleValue).setScale(config.getNumericPrecision(), 4).doubleValue() : doubleValue;
    }

    public static String getSlotPath(Object obj) {
        if (obj instanceof BObject) {
            return JsonSchemaUtil.getSlotPath((BObject)obj);
        }
        return obj.toString();
    }

    public static String getSlotPath(BObject object) {
        if (object.isComponent()) {
            return object.asComponent().getSlotPath().toString();
        }
        if (object.isComplex()) {
            return object.asComplex().getParentComponent().getSlotPath().toString() + '/' + object.asComplex().getName();
        }
        return object.toString();
    }

    public static String getSlotPath(OrdTarget ordTarget) {
        BObject target = ordTarget.get();
        if (target.isSimple()) {
            StringBuilder path = new StringBuilder(JsonSchemaUtil.getSlotPath((BObject)ordTarget.getComponent()));
            for (Property prop : ordTarget.getPropertyPathInComponent()) {
                path.append('/').append(prop.getName());
            }
            return path.toString();
        }
        return JsonSchemaUtil.getSlotPath(target);
    }

    public static String currentBasePath(BJsonSchema schema) {
        return JsonSchemaUtil.getSlotPath((BObject)schema.getBaseObject());
    }

    public static BFacets getFacetsForTarget(BObject target) {
        BFacets[] f;
        BFacets foundFacets = null;
        if (target.getType().is(BFacets.TYPE)) {
            foundFacets = (BFacets)target.as(BFacets.class);
        } else if (target.getType().is(BComponent.TYPE) && (f = (BFacets[])((BComponent)target).getChildren(BFacets.class)).length > 0) {
            foundFacets = f[0];
        }
        return foundFacets;
    }
}

