/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.subscription;

import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundSlotsContainer;
import com.tridiumx.jsonToolkit.outbound.schema.config.BSlotSelectionType;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaBoundProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaPropertyList;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.BindingSlotFilter;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.ChildSlotRenamedFilter;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SlotWhiteListFilter;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.Subscription;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionEventFilter;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.FilterResult;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BPointFolder;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public final class SubscriptionFactory {
    private static final List<Type> FOLDER_LIKE = Arrays.asList(BFolder.TYPE, BPointFolder.TYPE);
    public static final SubscriptionEventFilter PROPAGATE_FILTER = event -> FilterResult.PROPAGATE;
    public static final SubscriptionEventFilter IGNORE_ALL_FILTER = event -> FilterResult.IGNORE;
    public static final SubscriptionEventFilter COMPONENT_CHANGED_FILTER = event -> event.getId() == 20 || event.getId() == 13 ? FilterResult.PROPAGATE : FilterResult.CONTINUE;

    private SubscriptionFactory() {
    }

    public static Subscription makeSubscription(BJsonSchemaBoundMember member, OrdTarget ordTarget) {
        BObject target = ordTarget.get();
        int depth = SubscriptionFactory.isFolderLikeTarget(target) ? 1 : 0;
        return new Subscription(ordTarget.getPropertyPathInComponent(), depth).withFilter(new ChildSlotRenamedFilter(member)).withFilter(COMPONENT_CHANGED_FILTER).withFilter(SubscriptionFactory.getSlotFilter(member, ordTarget, target, depth > 0)).withFilter(SubscriptionFactory.changeToleranceFilter(ordTarget)).withFilter(SubscriptionFactory.globalBlacklistFilter());
    }

    private static boolean isFolderLikeTarget(BObject bindingTarget) {
        return FOLDER_LIKE.stream().anyMatch(folderType -> bindingTarget.getType().is(folderType));
    }

    public static BComponent getSubscriptionTarget(OrdTarget ordTarget, BJsonSchemaBoundMember binding) {
        BObject target = ordTarget.get();
        if (!target.isComponent() || binding instanceof BJsonSchemaBoundProperty) {
            return ordTarget.getComponent();
        }
        return target.asComponent();
    }

    private static SubscriptionEventFilter getSlotFilter(BJsonSchemaBoundMember member, OrdTarget ordTarget, BObject target, boolean subscribedWithDepth) {
        if (SubscriptionFactory.allowsAllSlotEvents(member) && target.isComponent()) {
            return PROPAGATE_FILTER;
        }
        if (!target.isComponent()) {
            return new BindingSlotFilter(ordTarget);
        }
        if (member instanceof BJsonSchemaBoundSlotsContainer) {
            return new SlotWhiteListFilter(member, target, subscribedWithDepth);
        }
        return IGNORE_ALL_FILTER;
    }

    private static boolean allowsAllSlotEvents(BJsonSchemaBoundMember member) {
        return member instanceof BJsonSchemaBoundProperty || member instanceof BJsonSchemaPropertyList || member instanceof BJsonSchemaBoundSlotsContainer && ((BJsonSchemaBoundSlotsContainer)member).getSlotsToInclude().equals((Object)BSlotSelectionType.allSlots);
    }

    private static SubscriptionEventFilter changeToleranceFilter(OrdTarget ordTarget) {
        BJsonExportMarker[] changeToleranceMarkers;
        BComponent nearestParentComponent = ordTarget.getComponent();
        if (nearestParentComponent instanceof BNumericPoint && (changeToleranceMarkers = (BJsonExportMarker[])nearestParentComponent.getChildren(BJsonExportMarker.class)).length > 0) {
            return changeToleranceMarkers[0];
        }
        return null;
    }

    private static SubscriptionEventFilter globalBlacklistFilter() {
        try {
            BJsonSchemaService service = BJsonSchemaService.service();
            return service.getGlobalCovSlotFilter();
        }
        catch (FeatureNotLicensedException | ServiceNotFoundException se) {
            if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
                JsonSchemaUtil.logger.finest(String.format("%s missing so skipping use of global slot filter", BJsonSchemaService.TYPE.getTypeName()));
            }
            return null;
        }
    }
}

