/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.subscription;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.Subscription;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionEventHandler;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;

public class SchemaBoundMemberSubscriber
extends Subscriber {
    private final BJsonSchema schema;
    private final BJsonSchemaBoundMember schemaBoundMember;
    private final Subscription subscription;
    private final SubscriptionEventHandler handler;
    private static final int[] MONITORED_EVENT_TYPES = new int[]{0, 1, 2, 3, 4, 13, 20};
    private static final Set<Integer> MONITORED_EVENTS = Collections.unmodifiableSet(new HashSet(Arrays.stream(MONITORED_EVENT_TYPES).boxed().collect(Collectors.toSet())));
    private static final BComponentEventMask MASK = BComponentEventMask.make((int[])MONITORED_EVENT_TYPES);

    public SchemaBoundMemberSubscriber(BJsonSchemaBoundMember schemaBoundMember, Subscription subscription, SubscriptionEventHandler handler) {
        this.schemaBoundMember = schemaBoundMember;
        this.subscription = subscription;
        this.handler = handler;
        this.schema = schemaBoundMember.getSchema();
        this.setMask(MASK);
    }

    public void subscribeTo(BComponent target) {
        this.subscription.addSubscriptionTarget(target);
        this.subscribe(target, this.subscription.getDepth());
        JsonSchemaUtil.logger.fine(String.format("[%s] subscribing to [%s]", this.schemaBoundMember.getSchemaPath(), target.getSlotPath()));
    }

    public void event(BComponentEvent event) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("Json Schema [%s] Sub evt: [%s] src: [%s] slot: [%s] value: [%s]", this.schema.getName(), event.getId(), event.getSourceComponent(), event.getSlot(), event.getValue()));
        }
        boolean propagate = MONITORED_EVENTS.contains(event.getId()) && this.subscription.test(event);
        this.schema.getConfig().getDebug().getMetrics().subscriptionEvent(propagate);
        if (propagate) {
            this.handler.handle(event);
        }
    }

    protected void subscribed(BComponent component, Context cx) {
        super.subscribed(component, cx);
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("Json Schema [%s] subscribing to [%s]", this.schema.getName(), component.getSlotPath()));
        }
        this.schema.getConfig().getDebug().getMetrics().subscription();
    }

    protected void unsubscribed(BComponent component, Context context) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("Json Schema [%s] unsubscribing from [%s]", this.schema.getName(), component.getSlotPath()));
        }
        super.unsubscribed(component, context);
        this.schema.getConfig().getDebug().getMetrics().unsubscribeEvent();
    }
}

