/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query;

import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.sys.BIObject;

public class QueryResultHolder {
    private final List<String> columnNames;
    private final List<Map<String, BIObject>> resultList;
    private final Logger log = Log.child("queryResult");

    public QueryResultHolder(BITable<?> queryResult) {
        Column[] columns = queryResult.getColumns().list();
        this.columnNames = Arrays.stream(columns).map(col -> col.getDisplayName(null)).collect(Collectors.toList());
        this.debugHeader();
        try (TableCursor cursor = queryResult.cursor();){
            this.resultList = new ArrayList<Map<String, BIObject>>();
            while (cursor.next()) {
                LinkedHashMap<String, BIObject> values = new LinkedHashMap<String, BIObject>();
                for (Column column : columns) {
                    values.put(column.getDisplayName(null), cursor.cell(column));
                }
                this.resultList.add(values);
                this.debugRow(columns, cursor);
            }
        }
    }

    private void debugHeader() {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
            this.log.finest("Caching Json Schema Query Result");
            StringBuilder header = new StringBuilder("Column: |");
            this.columnNames.forEach(cn -> header.append(QueryResultHolder.spacedOutColumn(cn)));
            int headerLength = header.length();
            header.append('\n');
            for (int i = 0; i < headerLength; ++i) {
                header.append('-');
            }
            this.log.finest(header.toString());
        }
    }

    private void debugRow(Column[] columns, TableCursor<?> cursor) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
            StringBuilder row = new StringBuilder("Row:    |");
            for (Column column : columns) {
                row.append(QueryResultHolder.spacedOutColumn(cursor.cell(column).toString()));
            }
            this.log.finest(row.toString());
        }
    }

    private static String spacedOutColumn(String string) {
        return String.format("%-18s|", string.length() > 18 ? string.substring(0, 18) : string);
    }

    public List<Map<String, BIObject>> getResultList() {
        return Collections.unmodifiableList(this.resultList);
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }
}

