/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaPropertyList;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dictionaryNamespaceFilter", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:TagNamespaceFE\"))")}), @NiagaraProperty(name="tagIdListFilter", type="String", defaultValue="*"), @NiagaraProperty(name="includeNameSpace", type="boolean", defaultValue="true"), @NiagaraProperty(name="jsonName", type="String", defaultValue="BString.DEFAULT", override=true, flags=5), @NiagaraProperty(name="jsonNameSource", type="jsonToolkit:JsonSchemaNameSource", defaultValue="BJsonSchemaNameSource.displayName", override=true, flags=4)})
public class BJsonSchemaTagList
extends BJsonSchemaPropertyList {
    public static final Property dictionaryNamespaceFilter = BJsonSchemaTagList.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:TagNamespaceFE")));
    public static final Property tagIdListFilter = BJsonSchemaTagList.newProperty((int)0, (String)"*", null);
    public static final Property includeNameSpace = BJsonSchemaTagList.newProperty((int)0, (boolean)true, null);
    public static final Property jsonName = BJsonSchemaTagList.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property jsonNameSource = BJsonSchemaTagList.newProperty((int)4, (BValue)BJsonSchemaNameSource.displayName, null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaTagList.class);
    private static final String ALL = "*";

    public String getDictionaryNamespaceFilter() {
        return this.getString(dictionaryNamespaceFilter);
    }

    public void setDictionaryNamespaceFilter(String v) {
        this.setString(dictionaryNamespaceFilter, v, null);
    }

    public String getTagIdListFilter() {
        return this.getString(tagIdListFilter);
    }

    public void setTagIdListFilter(String v) {
        this.setString(tagIdListFilter, v, null);
    }

    public boolean getIncludeNameSpace() {
        return this.getBoolean(includeNameSpace);
    }

    public void setIncludeNameSpace(boolean v) {
        this.setBoolean(includeNameSpace, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaTagList make(BOrd ord, String nameSpaceFilter, String tagIdList, boolean includeNamespace) {
        BJsonSchemaTagList tagList = new BJsonSchemaTagList();
        tagList.setBinding(ord);
        tagList.setDictionaryNamespaceFilter(nameSpaceFilter);
        tagList.setTagIdListFilter(tagIdList);
        tagList.setIncludeNameSpace(includeNamespace);
        return tagList;
    }

    @Override
    public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        BObject target = this.getTarget();
        if (target != null && target.isComponent()) {
            Tags targetTags = this.getTarget().asComponent().tags();
            Collection<Tag> filteredTags = targetTags.getAll();
            if (!this.getDictionaryNamespaceFilter().isEmpty()) {
                filteredTags = targetTags.getInDictionary(this.getDictionaryNamespaceFilter());
            }
            if (!this.getTagIdListFilter().equals(ALL)) {
                String[] tags = this.getTagIdListFilter().split(",");
                filteredTags = BJsonSchemaTagList.getMatchingTagsById(filteredTags, Arrays.asList(tags));
            }
            filteredTags.forEach(tag -> this.writeProperty(jsonWriter, this.getIncludeNameSpace() ? tag.getId().getQName() : tag.getId().getName(), (BObject)tag.getValue().as(BValue.class)));
        } else {
            JsonSchemaUtil.logger.warning(String.format("Json schema [%s] tag list [%s] must be bound to component, found [%s]", this.getSchema(), this.getSchemaPath(), target != null ? target.getType() : "null"));
        }
    }

    private static Collection<Tag> getMatchingTagsById(Collection<Tag> targetTags, List<String> requestedTagNames) {
        Map<String, Tag> upperCaseTagNames = targetTags.stream().collect(Collectors.toMap(targetTag -> targetTag.getId().getQName().toUpperCase(), targetTag -> targetTag));
        return requestedTagNames.stream().filter(requestedTagName -> upperCaseTagNames.containsKey(requestedTagName.toUpperCase())).map(requestedTagName -> (Tag)upperCaseTagNames.get(requestedTagName.toUpperCase())).collect(Collectors.toList());
    }
}

