/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ord", type="baja:Ord", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"jsonToolkit:SlotOrdFE\")")}), @NiagaraProperty(name="facetKey", type="String", defaultValue="units")})
public class BJsonSchemaFacetProperty
extends BJsonSchemaProperty<BObject> {
    public static final Property ord = BJsonSchemaFacetProperty.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")));
    public static final Property facetKey = BJsonSchemaFacetProperty.newProperty((int)0, (String)"units", null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaFacetProperty.class);

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public String getFacetKey() {
        return this.getString(facetKey);
    }

    public void setFacetKey(String v) {
        this.setString(facetKey, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaFacetProperty make(BOrd ord, String facetKey) {
        BJsonSchemaFacetProperty facetProperty = new BJsonSchemaFacetProperty();
        facetProperty.setOrd(ord);
        facetProperty.setFacetKey(facetKey);
        return facetProperty;
    }

    private BObject lookupFacet(String facetKey, BValue target) {
        BFacets foundFacets = JsonSchemaUtil.getFacetsForTarget((BObject)target);
        if (foundFacets == null) {
            Log.log.warning(String.format("Json schema [%s] Cannot fetch facets from object [%s]", this.getSchema().getName(), target.toDebugString()));
        }
        try {
            if (foundFacets != null) {
                BObject facet = foundFacets.getFacet(facetKey);
                if (Log.log.isLoggable(Level.FINE)) {
                    Log.log.fine("Found facet " + facet);
                }
                return facet;
            }
        }
        catch (Exception e) {
            if (Log.log.isLoggable(Level.FINE)) {
                Log.log.log(Level.WARNING, "Error reading facets from " + target.toDebugString(), e);
            }
            Log.log.log(Level.WARNING, "Error reading facets " + target.toDebugString());
        }
        return BString.DEFAULT;
    }

    @Override
    public BObject getJsonValue() {
        BComplex base = this.getSchema().getBaseObject();
        if (this.getOrd() != null && !this.getOrd().isNull()) {
            try {
                BValue target = (BValue)this.getOrd().get((BObject)base);
                return this.lookupFacet(this.getFacetKey(), target);
            }
            catch (UnresolvedException ue) {
                Log.log.log(Level.WARNING, this.getSchema() + ": base:" + base.getName() + ": cannot find child component with facets: " + this.getOrd(), ue);
            }
        } else {
            Log.log.warning(String.format("Json schema: [%s] cannot function with null ord in [%s]", this.getSchema().getName(), this.getName()));
        }
        return BString.DEFAULT;
    }
}

