/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaPropertyList;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="facetCsvList", type="String", defaultValue="*"), @NiagaraProperty(name="writeEmptyStringsForMissingFacets", type="boolean", defaultValue="false")})
public class BJsonSchemaFacetList
extends BJsonSchemaPropertyList {
    public static final Property facetCsvList = BJsonSchemaFacetList.newProperty((int)0, (String)"*", null);
    public static final Property writeEmptyStringsForMissingFacets = BJsonSchemaFacetList.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaFacetList.class);
    private static final String ALL = "*";

    public String getFacetCsvList() {
        return this.getString(facetCsvList);
    }

    public void setFacetCsvList(String v) {
        this.setString(facetCsvList, v, null);
    }

    public boolean getWriteEmptyStringsForMissingFacets() {
        return this.getBoolean(writeEmptyStringsForMissingFacets);
    }

    public void setWriteEmptyStringsForMissingFacets(boolean v) {
        this.setBoolean(writeEmptyStringsForMissingFacets, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaFacetList make(BOrd ord, String facetCsvList, boolean writeEmptyStringsForMissingFacets) {
        BJsonSchemaFacetList facetList = new BJsonSchemaFacetList();
        facetList.setBinding(ord);
        facetList.setFacetCsvList(facetCsvList);
        facetList.setWriteEmptyStringsForMissingFacets(writeEmptyStringsForMissingFacets);
        return facetList;
    }

    @Override
    public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        BObject target = this.getTarget();
        if (target == null) {
            return;
        }
        BFacets foundFacets = JsonSchemaUtil.getFacetsForTarget(target);
        if (foundFacets != null) {
            String[] chosenFacets = this.getUserChosenFacetNames(foundFacets);
            Arrays.stream(chosenFacets).forEach(chosenFacet -> {
                BObject facet = foundFacets.get(chosenFacet);
                if (facet != null || this.getWriteEmptyStringsForMissingFacets()) {
                    this.writeProperty(jsonWriter, (String)chosenFacet, facet);
                } else if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
                    JsonSchemaUtil.logger.fine(String.format("Json schema [%s] facet list [%s] unable to find facet [%s] in target [%s] for ", this.schemaName(), this.getSchemaPath(), chosenFacet, JsonSchemaUtil.getSlotPath(target)));
                }
            });
        } else {
            JsonSchemaUtil.logger.warning(String.format("Json schema [%s] facet list [%s] must be bound to a facet slot or a component that has a facet slot, found [%s]", this.schemaName(), this.getSchemaPath(), target.getType()));
        }
    }

    private String[] getUserChosenFacetNames(BFacets foundFacets) {
        String[] chosenFacets = this.getFacetCsvList().equals(ALL) ? foundFacets.list() : this.getFacetCsvList().split(",");
        return chosenFacets;
    }
}

