/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.alarm;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.alarm.property.BIJsonAlarmDataResolver;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.object.BJsonSchemaObject;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaBuilder;
import com.tridiumx.jsonToolkit.util.BEngineCycleAlarmQueue;
import com.tridiumx.jsonToolkit.util.BEngineCycleMessageQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.BStringWritable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="publishPoint", type="baja:Ord", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"jsonToolkit:SlotOrdFE\")")}), @NiagaraProperty(name="jsonSchema", type="jsonToolkit:JsonSchema", defaultValue="new JsonSchemaBuilder().withRootObject().withUpdateStrategy(BJsonSchemaUpdateStrategy.onDemandOnly).build()"), @NiagaraProperty(name="queue", type="BEngineCycleAlarmQueue", defaultValue="new BEngineCycleAlarmQueue()", flags=4)})
@NiagaraAction(name="processAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", flags=4)
public class BJsonAlarmRecipient
extends BAlarmRecipient {
    public static final Property enabled = BJsonAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Property publishPoint = BJsonAlarmRecipient.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")));
    public static final Property jsonSchema = BJsonAlarmRecipient.newProperty((int)0, (BValue)new JsonSchemaBuilder().withRootObject().withUpdateStrategy(BJsonSchemaUpdateStrategy.onDemandOnly).build(), null);
    public static final Property queue = BJsonAlarmRecipient.newProperty((int)4, (BValue)new BEngineCycleAlarmQueue(), null);
    public static final Action processAlarm = BJsonAlarmRecipient.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BJsonAlarmRecipient.class);
    private BLink publishLink;
    private final Object mutex = new Object();
    private static final String ENABLED_LINK_NAME = "enabledLink";
    private static final String JSON_LINK_PREFIX = "jsonLink";
    private static final String QUEUE_LINK_NAME = "queueLink";
    private static final Logger log = BIJsonAlarmDataResolver.log;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getPublishPoint() {
        return (BOrd)this.get(publishPoint);
    }

    public void setPublishPoint(BOrd v) {
        this.set(publishPoint, (BValue)v, null);
    }

    public BJsonSchema getJsonSchema() {
        return (BJsonSchema)this.get(jsonSchema);
    }

    public void setJsonSchema(BJsonSchema v) {
        this.set(jsonSchema, (BValue)v, null);
    }

    public BEngineCycleAlarmQueue getQueue() {
        return (BEngineCycleAlarmQueue)this.get(queue);
    }

    public void setQueue(BEngineCycleAlarmQueue v) {
        this.set(queue, (BValue)v, null);
    }

    public void processAlarm(BAlarmRecord parameter) {
        this.invoke(processAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleAlarm(BAlarmRecord record) {
        if (this.getEnabled()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " Handling alarm " + record.toSummaryString());
            }
            this.getQueue().enqueue((BAlarmRecord)record.newCopy());
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getName() + " Not Handing alarm when disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessAlarm(BAlarmRecord record) {
        Object object = this.mutex;
        synchronized (object) {
            BJsonAlarmRecipient.process(record, this.getJsonSchema());
            this.getJsonSchema().doGenerateJson(null);
        }
    }

    private static void process(BAlarmRecord record, BComponent component) {
        if (component.getType().is(BIJsonAlarmDataResolver.TYPE)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolving " + component.getName());
            }
            ((BIJsonAlarmDataResolver)component).resolve(record);
        } else {
            for (BComponent comp : component.getChildComponents()) {
                BJsonAlarmRecipient.process(record, comp);
            }
        }
    }

    public boolean isChildLegal(BComponent child) {
        return !(child instanceof BIJsonAlarmDataResolver);
    }

    public void started() {
        this.addRootObjectToSchema();
        this.linkOutputToPublish();
        this.linkEnabledToSchema();
        this.linkQueueToProcessAlarm();
    }

    public void stopped() {
        this.unlinkPublishPoint();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(publishPoint)) {
            this.unlinkPublishPoint();
            this.linkOutputToPublish();
        }
    }

    private void linkOutputToPublish() {
        if (!this.isRunning() || this.getPublishPoint() == null || this.getPublishPoint().equals((Object)BOrd.NULL)) {
            return;
        }
        try {
            BStringWritable point = (BStringWritable)this.getPublishPoint().get((BObject)Sys.getStation());
            if (point != null) {
                BLink[] links;
                for (BLink candidateLink : links = point.getLinks()) {
                    if (!candidateLink.getName().startsWith(JSON_LINK_PREFIX)) continue;
                    try {
                        log.info("Removing duplicate link " + candidateLink.getName() + " from " + this.getName());
                        if (candidateLink.isActive()) {
                            candidateLink.deactivate();
                        }
                        point.remove((BComplex)candidateLink);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Cleaning up old duplicate links", e);
                    }
                }
                this.publishLink = point.makeLink((BComponent)this.getJsonSchema(), (Slot)BJsonSchema.output, (Slot)BStringWritable.in10, Context.NULL);
                point.add("jsonLink?", (BValue)this.publishLink, 2);
                this.publishLink.activate();
            }
        }
        catch (NullOrdException | UnresolvedException e) {
            this.getJsonSchema().getConfig().getDebug().getMetrics().resolveError();
            log.log(Level.WARNING, this.getName() + ": Unable to link to publish point: " + this.getPublishPoint(), e);
        }
    }

    private void addRootObjectToSchema() {
        if (this.getJsonSchema().getRoot() == null) {
            this.getJsonSchema().add("root", (BValue)new BJsonSchemaObject());
        }
    }

    private void unlinkPublishPoint() {
        if (this.publishLink != null) {
            try {
                BComponent target;
                if (this.publishLink.isActive()) {
                    this.publishLink.deactivate();
                }
                if ((target = this.publishLink.getTargetComponent()) != null) {
                    target.remove((BComplex)this.publishLink);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Un-linking publish point: " + e.getMessage(), e);
            }
        }
    }

    private void linkEnabledToSchema() {
        BJsonSchema schema = this.getJsonSchema();
        if (schema.get(ENABLED_LINK_NAME) == null) {
            BLink enabledLink = this.makeLink((BComponent)this, (Slot)enabled, (Slot)BJsonSchema.enabled, Context.NULL);
            schema.add(ENABLED_LINK_NAME, (BValue)enabledLink);
            enabledLink.activate();
            schema.setFlags((Slot)BJsonSchema.enabled, schema.getFlags((Slot)BJsonSchema.enabled) | 1);
        }
    }

    private void linkQueueToProcessAlarm() {
        if (this.get(QUEUE_LINK_NAME) == null) {
            BLink queueLink = this.makeLink(this.getQueue(), (Slot)BEngineCycleMessageQueue.out, (Slot)processAlarm, Context.NULL);
            this.add(QUEUE_LINK_NAME, (BValue)queueLink);
            queueLink.activate();
        }
    }
}

