/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaConfigException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIJsonProperty<T>
extends BIJsonSchemaMember {
    public static final Type TYPE = Sys.loadType(BIJsonProperty.class);

    public T getJsonValue();

    @Override
    public BJsonSchema getSchema();

    @Override
    default public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        if (this.getParent() instanceof BJsonSchema) {
            throw new JsonSchemaConfigException("Properties not valid at the top level of a json payload");
        }
        if (jsonKeysValid) {
            JsonSchemaNameUtil.writeKey(this, jsonWriter, this.getJsonName());
        }
        jsonWriter.value(JsonSchemaUtil.toJsonType(this.getJsonValue(), this.getSchema().getConfig()));
    }
}

