/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridiumx.jsonToolkit.inbound.routing.BJsonRouter;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="key", type="baja:String", defaultValue="messageType"), @NiagaraProperty(name="resendWithBlank", type="boolean", defaultValue="false")})
public class BJsonMessageRouter
extends BJsonRouter {
    public static final Property key = BJsonMessageRouter.newProperty((int)0, (String)"messageType", null);
    public static final Property resendWithBlank = BJsonMessageRouter.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BJsonMessageRouter.class);

    public String getKey() {
        return this.getString(key);
    }

    public void setKey(String v) {
        this.setString(key, v, null);
    }

    public boolean getResendWithBlank() {
        return this.getBoolean(resendWithBlank);
    }

    public void setResendWithBlank(boolean v) {
        this.setBoolean(resendWithBlank, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        Object value = this.lookupKey(message.toString(), LOG, false, this.getKey());
        if (value == null) {
            throw new RoutingFailedException(message.toString(), String.format("Unable to find message key: [%s]", this.getKey()), null);
        }
        String msgType = SlotPath.escape((String)value.toString());
        try {
            if (this.getResendWithBlank() && this.get(msgType).equals((Object)message)) {
                this.setNewValueOnSlot(message.toString(), msgType, (BValue)BString.DEFAULT);
            }
            this.setNewValueOnSlot(message.toString(), msgType, (BValue)message);
        }
        catch (Exception e) {
            throw new RoutingFailedException(message.toString(), String.format("Problem parsing messageType [%s]: " + e.getMessage(), msgType), e);
        }
    }

    @Override
    protected Property[] getRerunTriggers() {
        return new Property[]{key};
    }
}

