/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.jsonToolkit.inbound.routing.BJsonRouter;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.UnsupportedConversionTypeException;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="defaultMissing", type="boolean", defaultValue="true")
public class BJsonDemuxRouter
extends BJsonRouter {
    public static final Property defaultMissing = BJsonDemuxRouter.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BJsonDemuxRouter.class);
    private static final Logger log = Log.child(TYPE.getTypeName());

    public boolean getDefaultMissing() {
        return this.getBoolean(defaultMissing);
    }

    public void setDefaultMissing(boolean v) {
        this.setBoolean(defaultMissing, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        String in = message.toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " routing message " + this.loggableJson(message.toString()));
        }
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        if (in.length() <= 3) {
            throw new RoutingFailedException(in, this.getName() + " Message to short to demux");
        }
        if (this.getSlotCount() == this.getFrozenPropertiesArray().length) {
            throw new RoutingFailedException(in, this.getName() + " demux requires slots adding to extract data!");
        }
        Property[] props = this.getDynamicPropertiesArray();
        ArrayList knownKeys = new ArrayList(props.length);
        Arrays.stream(props).forEach(prop -> {
            if (prop.getType().is(BString.TYPE) || prop.getType().is(BNumber.TYPE) || prop.getType().is(BBoolean.TYPE)) {
                knownKeys.add(prop.getName());
            }
        });
        if (knownKeys.size() < 1 && !this.getLearnMode()) {
            throw new RoutingFailedException(in, "No Keys found in input");
        }
        Map values = this.lookupKeyValues(in);
        for (Map.Entry value : values.entrySet()) {
            String jsonKey = (String)value.getKey();
            Object jsonValue = value.getValue();
            if (jsonValue == null || jsonValue == JSONObject.NULL) {
                log.warning("Demux is unable to determine type for key with null value : " + jsonKey);
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Parsing " + jsonKey + " : " + jsonValue);
            }
            try {
                if (jsonValue instanceof JSONObject || jsonValue instanceof JSONArray) {
                    jsonValue = jsonValue.toString();
                }
                BValue bValue = JsonSchemaUtil.toBValue(jsonValue);
                Property property = this.getProperty(jsonKey);
                if (!this.getLearnMode() && property == null) continue;
                this.setNewValueOnSlot(message.toString(), SlotPath.escape((String)jsonKey), bValue);
                knownKeys.remove(jsonKey);
            }
            catch (UnsupportedConversionTypeException unsup) {
                throw new RoutingFailedException(in, "Could not convert to BValue k:" + jsonKey + " v:" + jsonValue, unsup);
            }
        }
        if (!knownKeys.isEmpty() && this.getDefaultMissing()) {
            knownKeys.forEach(knownKey -> {
                Property property = this.getProperty((String)knownKey);
                this.resetDynamicProperty(this, property);
            });
        }
    }
}

