/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.exportMarker.register;

import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerIdInvalidException;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerNotFoundException;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="resetAllMarkerIds", flags=384), @NiagaraAction(name="removeAllMarkers", flags=384)})
@NiagaraTopics(value={@NiagaraTopic(name="markerAdded", flags=8), @NiagaraTopic(name="markerRemoved", flags=8)})
public class BExportMarkerRegister
extends BComponent {
    public static final Action resetAllMarkerIds = BExportMarkerRegister.newAction((int)384, null);
    public static final Action removeAllMarkers = BExportMarkerRegister.newAction((int)384, null);
    public static final Topic markerAdded = BExportMarkerRegister.newTopic((int)8, null);
    public static final Topic markerRemoved = BExportMarkerRegister.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BExportMarkerRegister.class);
    private final HashMap<String, BJsonExportMarker> markerMap = new HashMap();

    public void resetAllMarkerIds() {
        this.invoke(resetAllMarkerIds, null, null);
    }

    public void removeAllMarkers() {
        this.invoke(removeAllMarkers, null, null);
    }

    public void fireMarkerAdded(BValue event) {
        this.fire(markerAdded, event, null);
    }

    public void fireMarkerRemoved(BValue event) {
        this.fire(markerRemoved, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.clearRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegister() {
        HashMap<String, BJsonExportMarker> hashMap = this.markerMap;
        synchronized (hashMap) {
            this.markerMap.clear();
        }
    }

    public void doRemoveAllMarkers(Context cx) throws ExportMarkerIdInvalidException {
        Log.audit(cx, "Invoked", this.getName(), removeAllMarkers.getName(), null, null);
        for (BJsonExportMarker exportMarker : this.getMarkers()) {
            BComponent component = (BComponent)exportMarker.getParent();
            component.remove((BComplex)exportMarker);
        }
        this.clearRegister();
    }

    public void doResetAllMarkerIds(Context cx) {
        Log.audit(cx, "Invoked", this.getName(), resetAllMarkerIds.getName(), null, null);
        for (BJsonExportMarker marker : this.getMarkers()) {
            marker.resetId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BJsonExportMarker lookupExportMarker(String id) throws ExportMarkerNotFoundException {
        HashMap<String, BJsonExportMarker> hashMap = this.markerMap;
        synchronized (hashMap) {
            BJsonExportMarker marker = this.markerMap.get(id);
            if (marker == null) {
                throw new ExportMarkerNotFoundException(id);
            }
            return marker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMarker(BJsonExportMarker exportMarker) throws ExportMarkerIdInvalidException {
        Log.log.finest(() -> "Adding markerMap entry: " + exportMarker.getId());
        exportMarker.checkInvalidId();
        HashMap<String, BJsonExportMarker> hashMap = this.markerMap;
        synchronized (hashMap) {
            this.markerMap.put(exportMarker.getId(), exportMarker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMarker(BJsonExportMarker marker) throws ExportMarkerIdInvalidException {
        Log.log.finest(() -> "Removing markerMap entry: " + marker.getId());
        marker.checkInvalidId();
        HashMap<String, BJsonExportMarker> hashMap = this.markerMap;
        synchronized (hashMap) {
            this.markerMap.remove(marker.getId());
            this.fireMarkerRemoved((BValue)marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMarker(String oldId, BJsonExportMarker marker) throws ExportMarkerNotFoundException, ExportMarkerIdInvalidException {
        HashMap<String, BJsonExportMarker> hashMap = this.markerMap;
        synchronized (hashMap) {
            this.unregisterMarker(this.lookupExportMarker(oldId));
            this.registerMarker(marker);
            this.fireMarkerAdded((BValue)marker);
        }
    }

    public Collection<BJsonExportMarker> getMarkers() {
        return Collections.unmodifiableCollection(this.markerMap.values());
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Registered Export Markers");
        out.prop((Object)"Count", this.getMarkers().size());
        for (BJsonExportMarker m : this.getMarkers()) {
            out.prop((Object)(m.getId() + " (" + m.getName() + ')'), (Object)((BComponent)m.getParent()).getSlotPath());
        }
        super.spy(out);
    }

    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(super.getIcon());
    }

    public boolean isParentLegal(BComponent bComponent) {
        return ParentLegal.is((BComplex)this, (BComplex)bComponent, BJsonSchemaService.TYPE);
    }
}

