/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.exportMarker.filter;

import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.exportMarker.filter.BAbstractExportMarkerFilter;
import com.tridiumx.jsonToolkit.exportMarker.register.BExportMarkerRegister;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaBoundQueryResult;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQueryFolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BObjectsArray;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaBuilder;
import java.util.Collection;
import java.util.logging.Level;
import javax.baja.history.BHistoryId;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="currentQuery", type="baja:Ord", defaultValue="BOrd.DEFAULT", flags=65), @NiagaraProperty(name="columns", type="String", defaultValue="timestamp, value, status"), @NiagaraProperty(name="updateSendSinceTime", type="boolean", defaultValue="false"), @NiagaraProperty(name="historyExportFilter", type="jsonToolkit:JsonSchema", defaultValue="new JsonSchemaBuilder().withRootObject().withUpdateStrategy(BJsonSchemaUpdateStrategy.onDemandOnly).build()")})
@NiagaraAction(name="sendSinceLastExport", flags=24)
public class BHistoryExportMarkerFilter
extends BAbstractExportMarkerFilter {
    public static final Property currentQuery = BHistoryExportMarkerFilter.newProperty((int)65, (BValue)BOrd.DEFAULT, null);
    public static final Property columns = BHistoryExportMarkerFilter.newProperty((int)0, (String)"timestamp, value, status", null);
    public static final Property updateSendSinceTime = BHistoryExportMarkerFilter.newProperty((int)0, (boolean)false, null);
    public static final Property historyExportFilter = BHistoryExportMarkerFilter.newProperty((int)0, (BValue)new JsonSchemaBuilder().withRootObject().withUpdateStrategy(BJsonSchemaUpdateStrategy.onDemandOnly).build(), null);
    public static final Action sendSinceLastExport = BHistoryExportMarkerFilter.newAction((int)24, null);
    public static final Type TYPE = Sys.loadType(BHistoryExportMarkerFilter.class);
    private static final String EXPORT_MARKER_QUERY = "ExportMarkerQuery?";
    private static final String RESULT_NAME = "RenameMe?";

    public BOrd getCurrentQuery() {
        return (BOrd)this.get(currentQuery);
    }

    public void setCurrentQuery(BOrd v) {
        this.set(currentQuery, (BValue)v, null);
    }

    public String getColumns() {
        return this.getString(columns);
    }

    public void setColumns(String v) {
        this.setString(columns, v, null);
    }

    public boolean getUpdateSendSinceTime() {
        return this.getBoolean(updateSendSinceTime);
    }

    public void setUpdateSendSinceTime(boolean v) {
        this.setBoolean(updateSendSinceTime, v, null);
    }

    public BJsonSchema getHistoryExportFilter() {
        return (BJsonSchema)this.get(historyExportFilter);
    }

    public void setHistoryExportFilter(BJsonSchema v) {
        this.set(historyExportFilter, (BValue)v, null);
    }

    public void sendSinceLastExport() {
        this.invoke(sendSinceLastExport, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private void linkToSchemaQuery() {
        BJsonSchemaQuery targetFirstQuery;
        BJsonSchemaQueryFolder queryFolder = this.getHistoryExportFilter().getQueries();
        BJsonSchemaQuery[] queries = (BJsonSchemaQuery[])queryFolder.getChildren(BJsonSchemaQuery.class);
        if (queries == null || queries.length == 0) {
            BJsonSchemaQuery query = new BJsonSchemaQuery();
            queryFolder.add(EXPORT_MARKER_QUERY, (BValue)query);
            queries = (BJsonSchemaQuery[])queryFolder.getChildren(BJsonSchemaQuery.class);
            BJsonSchemaBoundQueryResult result = BJsonSchemaBoundQueryResult.make(query.getName(), BObjectsArray.TYPE.getTypeSpec());
            this.getHistoryExportFilter().getRoot().add(RESULT_NAME, (BValue)result);
        }
        if (queries != null && queries.length > 0 && 0 == (targetFirstQuery = queries[0]).getLinks((Slot)BJsonSchemaQuery.queryOrd).length) {
            targetFirstQuery.linkTo(this, (Slot)currentQuery, (Slot)BJsonSchemaQuery.queryOrd);
        }
    }

    @Override
    public void doSendSince(BAbsTime time) {
        this.send(false, time);
    }

    public void doSendSinceLastExport() {
        this.send(true, BAbsTime.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(boolean useExportMarkerTime, BAbsTime time) {
        if (!this.isRunning()) {
            return;
        }
        this.linkToSchemaQuery();
        Object object = this.lock;
        synchronized (object) {
            this.resetCounter();
            for (BJsonExportMarker m : BHistoryExportMarkerFilter.getMarkers()) {
                if (useExportMarkerTime) {
                    time = m.getSendHistorySince();
                }
                try {
                    this.exportHistory(m, time);
                }
                catch (Exception e) {
                    log.info("Interrupt exporting " + m);
                }
                if (!this.getUpdateSendSinceTime()) continue;
                m.setSendHistorySince(BAbsTime.now());
            }
            this.setCount(this.counter);
        }
    }

    private static Collection<BJsonExportMarker> getMarkers() {
        BExportMarkerRegister register = BJsonSchemaService.register();
        if (register == null) {
            ServiceNotFoundException se = new ServiceNotFoundException("Could not locate export maker register, is service installed");
            log.log(Level.WARNING, "Exporting History Data", (Throwable)se);
            throw se;
        }
        return register.getMarkers();
    }

    private void exportHistory(BJsonExportMarker marker, BAbsTime startFrom) throws InterruptedException {
        BHistoryExt[] exts;
        this.updateActiveId(marker);
        for (BHistoryExt e : exts = (BHistoryExt[])((BComponent)marker.getParent()).getChildren(BHistoryExt.class)) {
            BHistoryId hid = e.getHistoryConfig().getId();
            if (!e.getEnabled()) {
                log.info("Not exporting data for disabled history extension " + e.getSlotPath());
                break;
            }
            String bql = String.format("history:%s|bql:select %s where timestamp >= '%s'", hid, this.getColumns(), startFrom.encodeToString());
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("[%s] Built query: %s", this.getName(), bql));
            }
            BOrd query = BOrd.make((String)bql);
            long startCount = this.getSchemaGenerationCount();
            long startTime = Clock.ticks();
            this.setCurrentQuery(query);
            this.getHistoryExportFilter().generateJson();
            while (this.getSchemaGenerationCount() <= startCount && this.checkQueryTimeoutExpired(startTime)) {
                Thread.sleep(10L);
            }
            ++this.counter;
            this.interMessageSleep();
        }
    }

    private boolean checkQueryTimeoutExpired(long startTime) {
        return Clock.ticks() < startTime + this.getHistoryExportFilter().getQueries().getQueriesMaxExecutionTime().getMillis();
    }

    private long getSchemaGenerationCount() {
        return this.getHistoryExportFilter().getMetrics().getSchemaGenerations() + this.getHistoryExportFilter().getMetrics().getSchemaGenerationFails();
    }

    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(BIcon.std((String)"history.png"));
    }
}

