/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.exportMarker.filter;

import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.exportMarker.filter.BAbstractExportMarkerFilter;
import com.tridiumx.jsonToolkit.exportMarker.filter.BAlarmFilterMode;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerIdInvalidException;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="mode", type="jsonToolkit:AlarmFilterMode", defaultValue="BAlarmFilterMode.DEFAULT")
@NiagaraAction(name="in", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", flags=2056)
@NiagaraTopic(name="out", eventType="alarm:AlarmRecord", flags=8)
public class BAlarmExportMarkerFilter
extends BAbstractExportMarkerFilter {
    public static final Property mode = BAlarmExportMarkerFilter.newProperty((int)0, (BValue)BAlarmFilterMode.DEFAULT, null);
    public static final Action in = BAlarmExportMarkerFilter.newAction((int)2056, (BValue)new BAlarmRecord(), null);
    public static final Topic out = BAlarmExportMarkerFilter.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BAlarmExportMarkerFilter.class);

    public BAlarmFilterMode getMode() {
        return (BAlarmFilterMode)this.get(mode);
    }

    public void setMode(BAlarmFilterMode v) {
        this.set(mode, (BValue)v, null);
    }

    public void in(BAlarmRecord parameter) {
        this.invoke(in, (BValue)parameter, null);
    }

    public void fireOut(BAlarmRecord event) {
        this.fire(out, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSendSince(BAbsTime since) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getMode() == BAlarmFilterMode.passAll) {
            log.warning("Alarm boost not supported in mode " + BAlarmFilterMode.passAll.getTag());
            return;
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        Object object = this.lock;
        synchronized (object) {
            this.resetCounter();
            try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);
                 Cursor almCursor = conn.getOpenAlarms();){
                while (almCursor.next()) {
                    BAlarmRecord record = (BAlarmRecord)almCursor.get();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Considering send boost for old alarm " + record);
                    }
                    if (!record.getTimestamp().isAfter(since) && !record.getTimestamp().equals((Object)since)) continue;
                    this.in(record);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Historic Alarm Sending", e);
            }
            finally {
                this.setCount(this.counter);
            }
        }
    }

    public void doIn(BAlarmRecord record) {
        if (!this.isRunning()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getName() + " considering new alarm: " + record);
        }
        try {
            switch (this.getMode().getOrdinal()) {
                case 3: {
                    return;
                }
                case 2: {
                    this.fireRecord(record);
                    break;
                }
                case 1: {
                    BJsonExportMarker marker = BAlarmExportMarkerFilter.getMarker(record);
                    if (marker != null) {
                        this.updateActiveId(marker);
                        this.fireRecord(record);
                    }
                    break;
                }
                default: {
                    BJsonExportMarker marker = BAlarmExportMarkerFilter.getMarker(record);
                    if (marker != null) {
                        marker.checkInvalidId();
                        this.updateActiveId(marker);
                        this.fireRecord(record);
                    }
                    break;
                }
            }
        }
        catch (ExportMarkerIdInvalidException | ExportMarkerNotFoundException | BajaRuntimeException e) {
            log.log(Level.FINE, this.getName() + " Filtered alarm", e);
        }
    }

    private void fireRecord(BAlarmRecord record) {
        this.fireOut(record);
        ++this.counter;
        this.interMessageSleep();
    }

    private static BJsonExportMarker getMarker(BAlarmRecord record) throws ExportMarkerNotFoundException {
        BComponent parent;
        BOrd ord = record.getSource().get(0);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Found ord of: " + ord);
        }
        try {
            BComponent alarmExt = (BComponent)ord.get((BObject)Sys.getStation());
            if (!(alarmExt instanceof BAlarmSourceExt)) {
                throw new ExportMarkerNotFoundException("Export Markers cannot be applied to this Alarm Source: " + alarmExt.getType());
            }
            BAlarmSourceExt ext = (BAlarmSourceExt)alarmExt;
            parent = (BComponent)ext.getParent();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found parent to be: " + parent.getSlotPath());
            }
        }
        catch (UnresolvedException ue) {
            throw new ExportMarkerNotFoundException("Filtering Alarm: cannot find source object " + record, (Exception)((Object)ue));
        }
        BJsonExportMarker[] markers = (BJsonExportMarker[])parent.getChildren(BJsonExportMarker.class);
        if (markers.length == 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Filtering Alarm: No Export Marker found on alarm source");
            }
            throw new ExportMarkerNotFoundException("Filtering Alarm: No Id found on export marker, source point is not registered.");
        }
        return markers[0];
    }

    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(BIcon.std((String)"navOnly/alarmService.png"));
    }
}

