/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.history;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraSystemHistoryExport;
import com.tridium.nd.ui.history.BNiagaraHistoryExportManager;
import com.tridium.nd.ui.history.NiagaraImportLearn;
import java.util.ArrayList;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BHistoryExportManager;
import javax.baja.driver.ui.history.ExportLearn;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class NiagaraExportLearn
extends ExportLearn {
    static Lexicon lex = Lexicon.make(BNiagaraHistoryExportManager.class);
    static String lexLocal = lex.getText("historyExportManager.local");
    String parentStationName;

    public NiagaraExportLearn(BHistoryExportManager manager) {
        super(manager);
    }

    public Object[] getDiscovery(BComponent target) {
        Object[] d = super.getDiscovery(target);
        BNiagaraStation station = NiagaraImportLearn.getStation(target);
        String targetStationName = station.getName();
        this.parentStationName = null;
        if (station != null) {
            for (BComplex parent = station.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BStation)) continue;
                this.parentStationName = ((BStation)parent).getStationName();
                break;
            }
        }
        boolean needFilter = false;
        for (int i = 0; i < d.length; ++i) {
            BIHistory history;
            if (d[i] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i];
                if (!dev.getDeviceName().equals(targetStationName)) continue;
                needFilter = true;
                break;
            }
            if (!(d[i] instanceof BIHistory) || !(history = (BIHistory)d[i]).getId().getDeviceName().equals(targetStationName)) continue;
            needFilter = true;
            break;
        }
        if (!needFilter) {
            return d;
        }
        ArrayList<Object> result = new ArrayList<Object>(d.length);
        for (int i = 0; i < d.length; ++i) {
            BIHistory history;
            if (d[i] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i];
                if (dev.getDeviceName().equals(targetStationName)) continue;
                result.add(dev);
                continue;
            }
            if (!(d[i] instanceof BIHistory) || (history = (BIHistory)d[i]).getId().getDeviceName().equals(targetStationName)) continue;
            result.add(history);
        }
        return result.toArray();
    }

    public boolean isExisting(Object discovery, BComponent component) {
        BHistoryId expId;
        if (!(discovery instanceof BIHistory)) {
            return false;
        }
        if (!(component instanceof BHistoryExport)) {
            return false;
        }
        BIHistory h = (BIHistory)discovery;
        if (component instanceof BNiagaraSystemHistoryExport) {
            BHistoryConfig config = h.getConfig();
            if (config == null) {
                return false;
            }
            String list = ((BNiagaraSystemHistoryExport)component).getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                return false;
            }
            PatternFilter[] patterns = PatternFilter.parseList((String)list);
            return patterns.length > 0 && BLocalHistoryDatabase.acceptSystemTags((BHistoryConfig)config, (PatternFilter[])patterns);
        }
        BHistoryExport exp = (BHistoryExport)component;
        BHistoryId id = h.getId();
        return id.equals((Object)(expId = exp.getHistoryId())) || expId.equals((Object)id.toShorthand(this.parentStationName));
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        int size = cols != null ? cols.length : 0;
        MgrColumn[] newCols = new MgrColumn[size + 1];
        for (int i = 0; i < size; ++i) {
            newCols[i] = cols[i];
        }
        newCols[size] = new NiagaraImportLearn.SystemTagColumn();
        return newCols;
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BIHistory history = (BIHistory)discovery;
        BHistoryId shorthandId = history.getId().toShorthand(this.parentStationName);
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexLocal + "_" + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }
}

