/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.nv.BSlotInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BNiagaraPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BNiagaraPointManager.class);
    static final Logger LOG = Logger.getLogger("niagaraDriver");
    private static final Version VER_3_7 = new Version("3.7");
    private static final Version VER_4_4 = new Version("4.4");
    private static final Version VER_4_9U1 = new Version("4.9.1.29");
    private static final BSlotInfo[] EMPTY_SLOT_INFO_ARRAY = new BSlotInfo[0];
    final Lexicon driverLex = Lexicon.make((String)"driver");
    final String lexOut = this.driverLex.getText("out");
    final String lexSlotPath = UiLexicon.bajaui().getText("slotPath");
    final String lexHandle = UiLexicon.bajaui().getText("handle");
    final String lexType = UiLexicon.bajaui().getText("type");
    final String lexDisplayNames = UiLexicon.bajaui().getText("displayNames");
    final String lexDisplayName = UiLexicon.bajaui().getText("displayName");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colDisplayName = new DisplayNameColumn(this.lexDisplayName, 3);
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colPointId = new PointIdColumn(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.pointId}, 1);
    MgrColumn colString = new MgrColumn.ToString(this.lexOut, 0);
    MgrColumn colSubStatus = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.subscriptionStatus}, 0);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.enabled}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.tuningPolicyName}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.readValue}, 2);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.conversion}, 3);
    MgrColumn colDisplayNames = new DisplayNamesColumn(this.lexDisplayNames, 6);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colDisplayName, this.colType, this.colPointId, this.colString, this.colEnabled, this.colFacets, this.colTuning, this.colSubStatus, this.colFaultCause, this.colReadValue, this.colDeviceFacets, this.colConversion, this.colDisplayNames};
    MgrColumn dcolPath = new DiscoveredPathColumn(this.lexSlotPath, "toPathString");
    MgrColumn dcolHandle = new NiagaraLearn.Column(this.lexHandle, "handle", 2);
    MgrColumn dcolType = new NiagaraLearn.Column(this.lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    BIPointFolder folder;
    BNiagaraStation station;
    BNiagaraPointDeviceExt points;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public static String toSlotPathString(String ordString) {
        if (ordString.startsWith("station:|")) {
            return ordString.substring(9);
        }
        if (!ordString.startsWith("slot:")) {
            return "slot:" + ordString;
        }
        return ordString;
    }

    public static void computeFacets(BSlotInfo parentInfo, BSlotInfo[] childInfos) {
        try {
            if (BTypeSpec.make((String)parentInfo.getTypeSpec()).getTypeInfo().is(BControlPoint.TYPE)) {
                for (int i = 0; i < childInfos.length; ++i) {
                    if (!childInfos[i].getSlotName().equals("out")) continue;
                    parentInfo.setFacets(childInfos[i].getFacets());
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadNodes(LearnNode[] nodes, boolean loadChildren) {
        if (loadChildren || !this.loadNodesPartially(nodes)) {
            for (int i = 0; i < nodes.length; ++i) {
                LearnNode node = nodes[i];
                if (node.mySlotInfo != null && node.partiallyLoaded && (!loadChildren || node.fullyLoaded)) continue;
                String ord = node.parent != null ? node.path : "slot:" + node.get(this.dcolPath).toString();
                BFoxSession session = (BFoxSession)this.station.getSession();
                BSlotInfo[] infos = null;
                BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
                try {
                    infos = channel.discoverSlots(this.station.getStationName(), BOrd.make((String)("station:|" + ord)));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Could not discover slots for " + ord, e);
                }
                node.mySlotInfo = infos[0];
                node.childSlotInfos = new BSlotInfo[infos.length - 1];
                System.arraycopy(infos, 1, node.childSlotInfos, 0, node.childSlotInfos.length);
                node.partiallyLoaded = true;
                node.fullyLoaded = true;
                node.name = node.mySlotInfo.getSlotName();
                node.path = BNiagaraPointManager.toSlotPathString(node.mySlotInfo.getSlotOrd().relativizeToSession().toString());
                BNiagaraPointManager.computeFacets(node.mySlotInfo, node.childSlotInfos);
                node.facets = node.mySlotInfo.getFacets();
                node.displayName = node.mySlotInfo.getSlotDisplayName();
                try {
                    BIcon infoIcon = node.mySlotInfo.getSlotIcon();
                    if (BIcon.DEFAULT.equals((Object)infoIcon)) continue;
                    node.icon = BImage.make((BIcon)infoIcon);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean loadNodesPartially(LearnNode[] nodes) {
        Version remoteVersion;
        Version subordinateStationVersion;
        String subordinateStationVersionStr = this.station.getVersion();
        try {
            subordinateStationVersion = subordinateStationVersionStr.isEmpty() ? Version.ZERO : new Version(subordinateStationVersionStr);
        }
        catch (Exception e) {
            subordinateStationVersion = Version.ZERO;
        }
        if (subordinateStationVersion.compareTo(VER_3_7) < 0) {
            return false;
        }
        BFoxSession session = (BFoxSession)this.station.getSession();
        try {
            remoteVersion = new Version(session.getConnection().session().getRemoteHello().getString("app.version", ""));
        }
        catch (Exception e) {
            remoteVersion = Version.ZERO;
        }
        if (remoteVersion.compareTo(VER_4_9U1) < 0) {
            return false;
        }
        boolean manualOutSlotMode = subordinateStationVersion.compareTo(VER_4_4) < 0;
        HashMap<BOrd, LearnNode> ordsToNodes = new HashMap<BOrd, LearnNode>();
        ArrayList<BOrd> ordList = new ArrayList<BOrd>();
        for (LearnNode node : nodes) {
            if (node.mySlotInfo != null && node.partiallyLoaded) continue;
            boolean needsOutSlotOrd = manualOutSlotMode;
            if (needsOutSlotOrd) {
                try {
                    String typeSpec = node.get(this.dcolType).toString();
                    TypeInfo type = Sys.getRegistry().getType(typeSpec);
                    needsOutSlotOrd = type.is(BControlPoint.TYPE);
                }
                catch (Exception typeSpec) {
                    // empty catch block
                }
            }
            if (node.parent != null) {
                BOrd ord = BOrd.make((String)node.path);
                ordList.add(ord);
                ordsToNodes.put(ord, node);
                if (!needsOutSlotOrd) continue;
                ordList.add(BOrd.make((String)(node.path + "/out")));
                continue;
            }
            String slotPath = "slot:" + node.get(this.dcolPath).toString();
            BOrd ord = BOrd.make((String)slotPath);
            ordList.add(ord);
            ordsToNodes.put(ord, node);
            if (!needsOutSlotOrd) continue;
            ordList.add(BOrd.make((String)(slotPath + "/out")));
        }
        if (!ordsToNodes.isEmpty()) {
            BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
            try {
                BSlotInfo[] infos = channel.discoverPartialSlots(this.station.getStationName(), ordList.toArray(new BOrd[ordList.size()]));
                for (int i = 0; i < infos.length; ++i) {
                    BOrd ord = infos[i].getSlotOrd();
                    LearnNode node = (LearnNode)ordsToNodes.get(ord);
                    if (node == null) continue;
                    node.mySlotInfo = infos[i];
                    int nextIdx = i + 1;
                    if (nextIdx < infos.length && infos[nextIdx].getSlotOrd().equals((Object)BOrd.make((String)(ord.encodeToString() + "/out")))) {
                        node.childSlotInfos = new BSlotInfo[1];
                        node.childSlotInfos[0] = infos[nextIdx];
                    } else {
                        node.childSlotInfos = EMPTY_SLOT_INFO_ARRAY;
                    }
                    node.partiallyLoaded = true;
                    node.fullyLoaded = false;
                    node.name = node.mySlotInfo.getSlotName();
                    node.path = BNiagaraPointManager.toSlotPathString(node.mySlotInfo.getSlotOrd().relativizeToSession().toString());
                    BNiagaraPointManager.computeFacets(node.mySlotInfo, node.childSlotInfos);
                    node.facets = node.mySlotInfo.getFacets();
                    node.displayName = node.mySlotInfo.getSlotDisplayName();
                    try {
                        BIcon infoIcon = node.mySlotInfo.getSlotIcon();
                        if (BIcon.DEFAULT.equals((Object)infoIcon)) continue;
                        node.icon = BImage.make((BIcon)infoIcon);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Could not discover partial slots in batch, reverting to legacy discover slots", e);
                }
                return false;
            }
        }
        return true;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.folder = (BIPointFolder)value;
        try {
            this.points = (BNiagaraPointDeviceExt)this.folder.getDeviceExt();
            this.station = (BNiagaraStation)this.points.getDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doLoadValue(value, cx);
    }

    public static class DiscoveredPathColumn
    extends NiagaraLearn.Column {
        public DiscoveredPathColumn(String displayName, String projection) {
            super(displayName, projection);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return SlotPath.unescape((String)super.toDisplayString(row, value, cx));
        }
    }

    static class DisplayNameColumn
    extends MgrColumn {
        DisplayNameColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BFormat format;
            BNameMap map;
            if (row instanceof LearnNode) {
                LearnNode node = (LearnNode)row;
                return node.displayName;
            }
            BComplex c = (BComplex)row;
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public BValue load(MgrEditRow row) {
            BFormat format;
            BNameMap map;
            LearnNode node = (LearnNode)row.getDiscovery();
            if (node != null) {
                return node.displayName;
            }
            BComponent c = row.getTarget();
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (value == null) {
                return;
            }
            LearnNode node = (LearnNode)row.getDiscovery();
            if (node != null) {
                node.displayName = (BFormat)value;
            } else {
                BComponent c = row.getTarget();
                BComponent parent = (BComponent)c.getParent();
                if (parent != null) {
                    BNameMap map = (BNameMap)parent.get("displayNames");
                    if (map == null) {
                        if (!value.equals((Object)BFormat.DEFAULT)) {
                            map = BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)c.getName(), (BFormat)((BFormat)value));
                            parent.add("displayNames", (BValue)map);
                        }
                    } else {
                        map = !value.equals((Object)BFormat.DEFAULT) ? BNameMap.make((BNameMap)map, (String)c.getName(), (BFormat)((BFormat)value)) : BNameMap.remove((BNameMap)map, (String)c.getName());
                        parent.set("displayNames", (BValue)map);
                    }
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BFormat displayName = (BFormat)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)displayName);
            }
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            editor.loadValue((BObject)displayName, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BFormat displayName = BFormat.make((String)editor.saveValue().toString());
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)displayName);
                ((LearnNode)rows[i].getDiscovery()).displayName = displayName;
            }
        }
    }

    static class DisplayNamesColumn
    extends MgrColumn {
        DisplayNamesColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BValue val;
            if (row instanceof BComplex && (val = ((BComplex)row).get("displayNames")) instanceof BNameMap) {
                return val;
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            BValue result = row.getTarget().get("displayNames");
            if (result != null) {
                result = result.newCopy();
            }
            return result;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BValue old;
            if (value == null) {
                return;
            }
            BComponent target = row.getTarget();
            BNameMap names = (BNameMap)value;
            String[] propNames = names.list();
            if (propNames != null) {
                for (int i = 0; i < propNames.length; ++i) {
                    if (target.get(propNames[i]) != null) continue;
                    names = BNameMap.remove((BNameMap)names, (String)propNames[i]);
                }
            }
            if ((old = target.get("displayNames")) == null) {
                target.add("displayNames", (BValue)names, 261, cx);
            } else if (!old.equivalent((Object)names)) {
                target.set(target.getProperty("displayNames"), (BValue)names, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            Context cx = rows[0].getManager().getCurrentContext();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)cx);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BWbFieldEditor fe = (BWbFieldEditor)editor;
            BValue val = (BValue)fe.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    static class PointIdColumn
    extends MgrColumn.PropPath {
        PointIdColumn(Property[] path, int flags) {
            super(path, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return SlotPath.unescape((String)value.toString());
        }
    }

    class Controller
    extends PointController {
        Controller(BNiagaraPointManager mgr) {
            super((BPointManager)mgr);
            this.cancel.setFlags(0);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            Learn learn = (Learn)BNiagaraPointManager.this.getLearn();
            learn.bqlDiscover(BNiagaraPointManager.this.station, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            LearnNode[] nodes = new LearnNode[discovery.length];
            System.arraycopy(discovery, 0, nodes, 0, discovery.length);
            BNiagaraPointManager.this.loadNodes(nodes, false);
            return super.doAdd(discovery, cx);
        }
    }

    class State
    extends PointState {
        BITable<?> lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BNiagaraPointManager manager = (BNiagaraPointManager)m;
            Learn learn = (Learn)manager.getLearn();
            this.lastLearn = learn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNiagaraPointManager manager = (BNiagaraPointManager)m;
            Learn learn = (Learn)manager.getLearn();
            if (this.lastLearn != null) {
                learn.updateTable(this.lastLearn);
            }
        }
    }

    class LearnNode
    extends NiagaraLearn.Node {
        LearnNode parent;
        String name;
        BFormat displayName;
        String path;
        BSlotInfo mySlotInfo;
        BSlotInfo[] childSlotInfos;
        BFacets facets;
        boolean partiallyLoaded;
        boolean fullyLoaded;

        public LearnNode() {
            this.displayName = BFormat.DEFAULT;
            this.childSlotInfos = EMPTY_SLOT_INFO_ARRAY;
        }

        public LearnNode(LearnNode parent, BSlotInfo mySlotInfo) {
            BFormat displayString;
            BTypeSpec typeSpec;
            String ord;
            block15: {
                this.displayName = BFormat.DEFAULT;
                this.childSlotInfos = EMPTY_SLOT_INFO_ARRAY;
                this.parent = parent;
                this.mySlotInfo = mySlotInfo;
                this.name = mySlotInfo.getSlotName();
                this.path = parent.path + "/" + this.name;
                BNiagaraPointManager.computeFacets(this.mySlotInfo, this.childSlotInfos);
                this.facets = this.mySlotInfo.getFacets();
                ord = "";
                if (mySlotInfo.getIsComponent()) {
                    ord = "" + mySlotInfo.getSlotOrd().relativizeToSession().toString();
                }
                typeSpec = null;
                try {
                    typeSpec = BTypeSpec.make((String)mySlotInfo.getTypeSpec());
                }
                catch (Exception e) {
                    typeSpec = BValue.TYPE.getTypeSpec();
                }
                try {
                    BIcon infoIcon = mySlotInfo.getIcon();
                    if (BIcon.DEFAULT.equals((Object)infoIcon)) {
                        this.icon = BImage.make((BIcon)typeSpec.getInstance().getIcon());
                    } else {
                        try {
                            this.icon = BImage.make((BIcon)infoIcon);
                        }
                        catch (Exception ex) {
                            this.icon = BImage.make((BIcon)typeSpec.getInstance().getIcon());
                        }
                    }
                }
                catch (Exception e) {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"object.png"));
                }
                displayString = this.displayName = mySlotInfo.getSlotDisplayName();
                if (displayString.equals((Object)BFormat.DEFAULT)) {
                    if (mySlotInfo.getIsFrozen()) {
                        try {
                            BTypeSpec parentTypeSpec = null;
                            BObject obj = parent.cells[2];
                            parentTypeSpec = obj instanceof BTypeSpec ? (BTypeSpec)obj : BTypeSpec.make((String)obj.toString());
                            if (parentTypeSpec.equals((Object)BValue.TYPE.getTypeSpec())) {
                                displayString = BString.make((String)TextUtil.toFriendly((String)SlotPath.unescape((String)mySlotInfo.getSlotName())));
                                break block15;
                            }
                            BComplex complex = parentTypeSpec.getInstance().asComplex();
                            Property prop = complex.getProperty(mySlotInfo.getSlotName());
                            displayString = BString.make((String)prop.getDefaultDisplayName(BNiagaraPointManager.this.getCurrentContext()));
                        }
                        catch (Exception e) {
                            displayString = BString.make((String)TextUtil.toFriendly((String)SlotPath.unescape((String)mySlotInfo.getSlotName())));
                        }
                    } else {
                        displayString = BString.make((String)SlotPath.unescape((String)mySlotInfo.getSlotName()));
                    }
                }
            }
            this.cells = new BObject[]{displayString, BString.make((String)ord), typeSpec};
        }

        @Override
        public boolean hasChildren() {
            if (this.mySlotInfo == null) {
                return true;
            }
            return this.mySlotInfo.getIsComponent();
        }

        @Override
        public NiagaraLearn.Node[] getChildren() {
            this.loadNode(true);
            if (!this.mySlotInfo.getIsComponent()) {
                return new LearnNode[0];
            }
            ArrayList<LearnNode> kids = new ArrayList<LearnNode>(this.childSlotInfos.length);
            for (int i = 0; i < this.childSlotInfos.length; ++i) {
                String typeInfo;
                if ((this.childSlotInfos[i].getSlotFlags() & 4) != 0 || (typeInfo = this.childSlotInfos[i].getTypeSpec()).equals(BLink.TYPE.getTypeSpec().toString()) || typeInfo.equals(BWsAnnotation.TYPE.getTypeSpec().toString())) continue;
                kids.add(new LearnNode(this, this.childSlotInfos[i]));
            }
            return kids.toArray(new LearnNode[kids.size()]);
        }

        void loadNode(boolean loadChildren) {
            if (this.mySlotInfo == null || !this.partiallyLoaded || loadChildren && !this.fullyLoaded) {
                BNiagaraPointManager.this.loadNodes(new LearnNode[]{this}, loadChildren);
            }
        }

        public String toPointId() {
            if (this.path == null) {
                this.path = BNiagaraPointManager.toSlotPathString(this.cells[0].toString());
            }
            return this.path;
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BNiagaraPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.dcols;
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            ArrayList list = new ArrayList();
            String typeSpec = BNiagaraPointManager.this.dcolType.get(dis).toString();
            TypeInfo type = Sys.getRegistry().getType(typeSpec);
            PointModel.addPointTypes((TypeInfo)type, list, (boolean)false);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            LearnNode node = (LearnNode)discovery;
            node.loadNode(false);
            row.setDefaultName(node.name);
            row.setCell(BNiagaraPointManager.this.colFacets, (BValue)node.facets);
            row.setCell(BNiagaraPointManager.this.colDeviceFacets, (BValue)node.facets);
            row.setCell(BNiagaraPointManager.this.colPointId, (BValue)BString.make((String)node.toPointId()));
        }

        @Override
        protected NiagaraLearn.Node makeNode() {
            return new LearnNode();
        }

        public boolean isExisting(Object dis, BComponent comp) {
            LearnNode node = (LearnNode)dis;
            if (comp instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)comp;
                BNiagaraProxyExt ext = (BNiagaraProxyExt)pt.getProxyExt();
                return ext.getPointId().equals(node.toPointId());
            }
            return false;
        }
    }

    class Model
    extends PointModel {
        Model(BNiagaraPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            Model.addBooleanPointTypes(list, (boolean)false);
            Model.addNumericPointTypes(list, (boolean)false);
            Model.addEnumPointTypes(list, (boolean)false);
            Model.addStringPointTypes(list, (boolean)false);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = rows[i].getName();
                values[i] = rows[i].getTarget();
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            BNameMap map = (BNameMap)container.get("displayNames");
            for (int i = 0; i < rows.length; ++i) {
                Object discoveredPoint = rows[i].getDiscovery();
                BFormat displayName = null;
                displayName = discoveredPoint == null ? (BFormat)rows[i].getCell(BNiagaraPointManager.this.colDisplayName) : ((LearnNode)discoveredPoint).displayName;
                if (displayName == null || displayName.equals((Object)BFormat.DEFAULT)) continue;
                if (map == null) {
                    map = BNameMap.NULL;
                    container.add("displayNames", (BValue)map);
                }
                map = BNameMap.make((BNameMap)map, (String)names[i], (BFormat)displayName);
            }
            if (map != null) {
                container.set("displayNames", (BValue)map);
            }
            return null;
        }
    }
}

