/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util.jwt.token;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.datatypes.BJwtEncAlgorithm;
import com.tridium.mqttClientDriver.util.jwt.token.BToken;
import com.tridium.mqttClientDriver.util.jwt.token.Log;
import com.tridium.mqttClientDriver.util.jwt.token.TokenFactory;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="certificateAlias", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))")}), @NiagaraProperty(name="algorithm", type="abstractMqttDriver:JwtEncAlgorithm", defaultValue="BJwtEncAlgorithm.DEFAULT"), @NiagaraProperty(name="validity", type="BRelTime", defaultValue="BRelTime.makeMinutes(20)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"minute\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(5)"), @Facet(name="BFacets.MAX", value="BRelTime.makeDays(1)")}), @NiagaraProperty(name="advanceExpiration", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(1)")}), @NiagaraProperty(name="privateKey", type="BPassword", defaultValue="BPassword.DEFAULT", flags=5), @NiagaraProperty(name="privateKeyExpiration", type="int", defaultValue="1", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"year\")"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="5")})})
public class BTokenParameters
extends BComponent {
    public static final Property certificateAlias = BTokenParameters.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Property algorithm = BTokenParameters.newProperty((int)0, (BValue)BJwtEncAlgorithm.DEFAULT, null);
    public static final Property validity = BTokenParameters.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)20), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)5))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeDays((int)1))));
    public static final Property advanceExpiration = BTokenParameters.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)1))));
    public static final Property privateKey = BTokenParameters.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    public static final Property privateKeyExpiration = BTokenParameters.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"year")), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (int)5)));
    public static final Type TYPE = Sys.loadType(BTokenParameters.class);
    private Clock.Ticket reconnectTicket = Clock.expiredTicket;
    private BToken token;

    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    public BJwtEncAlgorithm getAlgorithm() {
        return (BJwtEncAlgorithm)this.get(algorithm);
    }

    public void setAlgorithm(BJwtEncAlgorithm v) {
        this.set(algorithm, (BValue)v, null);
    }

    public BRelTime getValidity() {
        return (BRelTime)this.get(validity);
    }

    public void setValidity(BRelTime v) {
        this.set(validity, (BValue)v, null);
    }

    public BRelTime getAdvanceExpiration() {
        return (BRelTime)this.get(advanceExpiration);
    }

    public void setAdvanceExpiration(BRelTime v) {
        this.set(advanceExpiration, (BValue)v, null);
    }

    public BPassword getPrivateKey() {
        return (BPassword)this.get(privateKey);
    }

    public void setPrivateKey(BPassword v) {
        this.set(privateKey, (BValue)v, null);
    }

    public int getPrivateKeyExpiration() {
        return this.getInt(privateKeyExpiration);
    }

    public void setPrivateKeyExpiration(int v) {
        this.setInt(privateKeyExpiration, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void scheduleReconnect() {
        BAbsTime reconnectTime = this.token.getExpires().subtract(this.getAdvanceExpiration());
        this.clearReconnectTicket();
        this.reconnectTicket = Clock.schedule((BComponent)this.getAuthenticator(), (BAbsTime)reconnectTime, (Action)BAbstractMqttDevice.connect, null);
        Log.log.fine(() -> "Scheduled reconnect for " + this.reconnectTicket + " at " + reconnectTime);
    }

    public void stopped() throws Exception {
        this.clearReconnectTicket();
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(validity) || property.equals(privateKey) || property.equals(algorithm) || property.equals(advanceExpiration)) {
            Log.log.finest("Restarting connection due to change of " + property.getName());
            this.clearReconnectTicket();
            this.token.doReset();
            try {
                this.getAuthenticator().getMqttClient().connect();
            }
            catch (Exception e) {
                if (Log.log.isLoggable(Level.FINE)) {
                    Log.log.warning("The client did not connect. Cause is " + e);
                }
                Log.log.warning("The client did not connect. Cause is " + e.getMessage());
            }
        }
        if (property.equals(privateKeyExpiration)) {
            this.resetExpirationDateOfKeys();
        }
    }

    private void resetExpirationDateOfKeys() {
        BDate creationDateOfKeys;
        BDate expirationDateofKeys = creationDateOfKeys = this.getAuthenticator().getCreationDateOfRsaKeys();
        for (int i = 0; i < this.getPrivateKeyExpiration(); ++i) {
            expirationDateofKeys = expirationDateofKeys.nextYear();
        }
        if (expirationDateofKeys.isBefore(BDate.today())) {
            Log.log.warning("The date has already passed. Please select correct year.");
        } else {
            this.getAuthenticator().setExpirationDateOfRsaKeys(expirationDateofKeys);
        }
    }

    private void clearReconnectTicket() {
        if (this.reconnectTicket != null && !this.reconnectTicket.isExpired()) {
            this.reconnectTicket.cancel();
            this.reconnectTicket = Clock.expiredTicket;
        }
    }

    public void addTokenAsPassword(MqttConnectOptions options) {
        if (this.token == null || this.token.getExpires().isBefore(BAbsTime.now())) {
            this.generateNewToken();
        }
        options.setPassword(this.token.getToken().toCharArray());
    }

    private PrivateKey loadPrivateKey() throws Exception {
        String privatePem = AccessController.doPrivileged(() -> ((BPassword)this.getPrivateKey()).getValue());
        Key privateKey = NKey.decodeFromString((String)privatePem);
        return (PrivateKey)privateKey;
    }

    public BToken getToken() {
        return this.token;
    }

    public void setToken(BToken token) {
        this.token = token;
    }

    private void generateNewToken() {
        try {
            PrivateKey key = this.loadPrivateKey();
            this.token = TokenFactory.update(this.token, key, this.getValidity(), this.getAlgorithm(), this.getAuthenticator().getGcpIotParameters().getProjectId());
            this.setToken(this.token);
            Nre.getSecurityAuditor().audit(new SecurityAuditEvent("Token generation", this.getAuthenticator().getClientID(), "A new token has been generated"));
        }
        catch (Exception e) {
            BajaRuntimeException bre = new BajaRuntimeException("Could not generate new JWT token", (Throwable)e);
            if (Log.log.isLoggable(Level.FINE)) {
                Log.log.log(Level.WARNING, bre.getLocalizedMessage(), (Throwable)bre);
            } else {
                Log.log.log(Level.WARNING, bre.getLocalizedMessage());
            }
            throw bre;
        }
    }

    public BGcpAuthenticator getAuthenticator() {
        return (BGcpAuthenticator)this.getParent();
    }

    public boolean isNavChild() {
        return false;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean valid = parent.getType().is(BGcpAuthenticator.TYPE);
        if (!valid) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.TokenParameters", null);
        }
        return true;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"clock.png");
    }
}

