/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util;

import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.sys.BComponent;

public class MqttSubscriberTopics {
    private ConcurrentHashMap<String, BMqttClientAbstractSubscriberPoint> stringTopicMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, BMqttClientAbstractSubscriberPoint> wildCardTopicMap = new ConcurrentHashMap();
    private static String SINGLE_MATCHING_WILDCARD = "+";
    private static String MULTI_MATCHING_WILDCARD = "#";
    private static final String TOPIC_LEVEL_SEPARATOR = "/";
    private static final String MULTI_LEVEL_WILDCARD_PATTERN = "/" + MULTI_MATCHING_WILDCARD;
    private static final char NUL = '\u0000';

    public void clearSubscriberMap() {
        if (!this.stringTopicMap.isEmpty()) {
            this.stringTopicMap = new ConcurrentHashMap();
        }
        if (!this.wildCardTopicMap.isEmpty()) {
            this.wildCardTopicMap = new ConcurrentHashMap();
        }
    }

    public boolean putTopic(String topic, BMqttClientAbstractSubscriberPoint comp) {
        if (topic.contains(SINGLE_MATCHING_WILDCARD) || topic.contains(MULTI_MATCHING_WILDCARD)) {
            this.wildCardTopicMap.put(topic, comp);
        } else {
            this.stringTopicMap.put(topic, comp);
        }
        return true;
    }

    public BComponent removeTopic(String topic) {
        if (topic.contains(SINGLE_MATCHING_WILDCARD) || topic.contains(MULTI_MATCHING_WILDCARD)) {
            return (BComponent)this.wildCardTopicMap.remove(topic);
        }
        return (BComponent)this.stringTopicMap.remove(topic);
    }

    public boolean isTopicAlreadySubscribed(String topic) {
        return this.stringTopicMap.containsKey(topic) || this.wildCardTopicMap.containsKey(topic);
    }

    public List<BMqttClientAbstractSubscriberPoint> findAllSubscribedPoints(String topic) {
        ArrayList<BMqttClientAbstractSubscriberPoint> points = new ArrayList<BMqttClientAbstractSubscriberPoint>();
        BMqttClientAbstractSubscriberPoint subsPoint = this.stringTopicMap.get(topic);
        if (subsPoint != null) {
            points.add(subsPoint);
        }
        for (Map.Entry<String, BMqttClientAbstractSubscriberPoint> entry : this.wildCardTopicMap.entrySet()) {
            if (!this.checkForTopicMatching(entry.getKey(), topic)) continue;
            points.add(entry.getValue());
        }
        return points;
    }

    private boolean checkForTopicMatching(String topicOfPoint, String topicWhereMessageArrived) {
        String[] topicOfPointArr = topicOfPoint.split(TOPIC_LEVEL_SEPARATOR);
        String[] topicWhereMessageArrivedArr = topicWhereMessageArrived.split(TOPIC_LEVEL_SEPARATOR);
        int topicWhereMessageArrivedLength = topicWhereMessageArrivedArr.length;
        for (int index = 0; index < topicOfPointArr.length; ++index) {
            if (index >= topicWhereMessageArrivedLength) {
                return false;
            }
            if (topicWhereMessageArrivedArr[index].equals(topicOfPointArr[index]) || SINGLE_MATCHING_WILDCARD.equals(topicOfPointArr[index])) continue;
            return MULTI_MATCHING_WILDCARD.equals(topicOfPointArr[index]);
        }
        return topicOfPointArr.length >= topicWhereMessageArrivedLength;
    }

    public boolean isValidTopic(String topicToSubscribe) {
        boolean isValidTopic = true;
        if (topicToSubscribe.contains(MULTI_MATCHING_WILDCARD)) {
            isValidTopic = this.isValidMultiMatchingWildCardTopic(topicToSubscribe);
        } else if (topicToSubscribe.contains(SINGLE_MATCHING_WILDCARD)) {
            isValidTopic = this.isValidSingleMatchingWildCardTopic(topicToSubscribe);
        }
        return isValidTopic;
    }

    private boolean isValidSingleMatchingWildCardTopic(String topicString) {
        boolean isValidSingleMatchingWildCardTopic = true;
        char singleLevelWildcardChar = SINGLE_MATCHING_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topicString.toCharArray();
        int length = chars.length;
        char prev = '\u0000';
        char next = '\u0000';
        for (int i = 0; i < length; ++i) {
            prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar || (prev == topicLevelSeparatorChar || prev == '\u0000') && (next == topicLevelSeparatorChar || next == '\u0000')) continue;
            isValidSingleMatchingWildCardTopic = false;
            break;
        }
        return isValidSingleMatchingWildCardTopic;
    }

    private boolean isValidMultiMatchingWildCardTopic(String topicToSubscribe) {
        boolean isValidTopic = true;
        if (this.isMoreThanOneMultiWildCardChar(topicToSubscribe) || topicToSubscribe.contains(MULTI_MATCHING_WILDCARD) && topicToSubscribe.length() > 1 && !topicToSubscribe.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
            isValidTopic = false;
        }
        return isValidTopic;
    }

    private boolean isMoreThanOneMultiWildCardChar(String topicToSubscribe) {
        boolean isMoreThanOneMultiWildCardChar = false;
        int idx = 0;
        int count = 0;
        while ((idx = topicToSubscribe.indexOf(MULTI_MATCHING_WILDCARD, idx)) != -1) {
            if (++count > 1) {
                isMoreThanOneMultiWildCardChar = true;
                break;
            }
            idx += MULTI_MATCHING_WILDCARD.length();
        }
        return isMoreThanOneMultiWildCardChar;
    }
}

