/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.aws;

import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTopic;
import com.tridium.mqttClientDriver.authenticator.IBasicMqttOptions;
import com.tridium.mqttClientDriver.clients.aws.MqttAwsSubsCallable;
import java.util.concurrent.ThreadPoolExecutor;

public class MqttAwsTopic
extends AWSIotTopic {
    private ThreadPoolExecutor executorService;
    private IBasicMqttOptions connectOptions;

    public MqttAwsTopic(String topic, AWSIotQos qos, ThreadPoolExecutor executorService, IBasicMqttOptions connectOptions) {
        super(topic, qos);
        this.executorService = executorService;
        this.connectOptions = connectOptions;
    }

    @Override
    public void onMessage(AWSIotMessage message) {
        if (this.executorService != null) {
            this.executorService.submit(new MqttAwsSubsCallable(this.connectOptions, this.topic, message));
        }
    }
}

