/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.aws;

import com.amazonaws.services.iot.client.AWSIotMessage;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.IBasicMqttOptions;
import com.tridium.mqttClientDriver.clients.aws.MqttAwsMessage;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.util.MqttSubscriberTopics;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class MqttAwsSubsCallable
implements Callable<String> {
    private String topic;
    private IBasicMqttOptions options;
    private AWSIotMessage message;
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.mqttClient");

    public MqttAwsSubsCallable(IBasicMqttOptions options, String topic, AWSIotMessage message) {
        this.topic = topic;
        this.options = options;
        this.message = message;
    }

    @Override
    public String call() throws Exception {
        try {
            this.updatePoints(this.options, this.topic, this.message);
            return this.topic;
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
            return null;
        }
    }

    private void updatePoints(IBasicMqttOptions connectOptions, String topic, AWSIotMessage message) {
        MqttSubscriberTopics subscriberMaps = connectOptions.getSubscriberMap();
        try {
            List<BMqttClientAbstractSubscriberPoint> points = subscriberMaps.findAllSubscribedPoints(topic);
            for (BMqttClientAbstractSubscriberPoint subscriberPoint : points) {
                MqttAwsMessage awsMessage = new MqttAwsMessage(topic, message.getQos(), message.getStringPayload());
                subscriberPoint.saveValueToPoint(awsMessage);
            }
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
            logger.warning(BAbstractMqttDevice.lex.get("couldNotSubscribe"));
            return;
        }
    }
}

