/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp.async;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.BMqttCallbackRouter;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public final class Callback {
    static final Logger log = BMqttCallbackRouter.log;
    static boolean pubErrorLogged;

    private Callback() {
    }

    public static class MqttSubsCallable
    implements Callable<String> {
        private final BAbstractMqttDevice device;
        private final String topic;
        private final MqttMessage message;

        public MqttSubsCallable(BAbstractMqttDevice device, String topic, MqttMessage message) {
            this.device = device;
            this.topic = topic;
            this.message = message;
        }

        @Override
        public String call() {
            try {
                BAbstractMqttAuthenticator authenticator = this.device.getAuthenticator(true);
                if (authenticator.getType().is(BGcpAuthenticator.TYPE)) {
                    BGcpAuthenticator gauth = (BGcpAuthenticator)authenticator;
                    gauth.getCallbackRouter().getHandler().handleMessage(this.topic, this.message);
                }
                return this.topic;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Call for " + this.device + ' ' + this.topic + ' ' + this.message, e);
                } else {
                    log.log(Level.WARNING, "Calling " + this.device, e);
                }
                return null;
            }
        }
    }

    public static class MqttPubCallable
    implements Callable<String> {
        private final MqttAsyncClient mqttClient;
        private final String topic;
        private final MqttMessage mqttMessage;

        public MqttPubCallable(MqttAsyncClient mqttClient, MqttMessage mqttMessage, String topic) {
            this.mqttClient = mqttClient;
            this.topic = topic;
            this.mqttMessage = mqttMessage;
        }

        @Override
        public String call() {
            try {
                if (this.mqttClient != null && this.mqttClient.isConnected()) {
                    this.mqttClient.publish(this.topic, this.mqttMessage);
                }
                return this.topic;
            }
            catch (Exception e) {
                if (!pubErrorLogged) {
                    if (log.isLoggable(Level.FINE)) {
                        log.severe(BAbstractMqttDevice.lex.getText("publishMessageLost", new Object[]{e.getMessage()}));
                    } else {
                        log.severe(BAbstractMqttDevice.lex.getText("publishMessageLost"));
                    }
                    pubErrorLogged = true;
                }
                return null;
            }
        }
    }
}

