/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp;

import com.tridium.mqttClientDriver.BAbstractMqttCallbackHandler;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.async.Callback;
import com.tridium.mqttClientDriver.handler.BPointCallbackHandler;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.mqttClientDriver.util.jwt.ParentLegal;
import com.tridium.mqttClientDriver.util.jwt.token.Log;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="callbackType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"abstractMqttDriver:PointCallbackHandler\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"abstractMqttDriver:AbstractMqttCallbackHandler\")")}), @NiagaraProperty(name="handler", type="abstractMqttDriver:AbstractMqttCallbackHandler", defaultValue="new BPointCallbackHandler()")})
public class BMqttCallbackRouter
extends BComponent
implements MqttCallback {
    public static final Property callbackType = BMqttCallbackRouter.newProperty((int)0, (BValue)BTypeSpec.make((String)"abstractMqttDriver:PointCallbackHandler"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"abstractMqttDriver:AbstractMqttCallbackHandler")));
    public static final Property handler = BMqttCallbackRouter.newProperty((int)0, (BValue)new BPointCallbackHandler(), null);
    public static final Type TYPE = Sys.loadType(BMqttCallbackRouter.class);
    public static final Logger log = Log.child("callback");
    private static final long reconnectSleepTime = AccessController.doPrivileged(() -> Long.getLong("mqtt.connectionLostWaitingTime", BRelTime.makeSeconds((int)30).getMillis()));

    public BTypeSpec getCallbackType() {
        return (BTypeSpec)this.get(callbackType);
    }

    public void setCallbackType(BTypeSpec v) {
        this.set(callbackType, (BValue)v, null);
    }

    public BAbstractMqttCallbackHandler getHandler() {
        return (BAbstractMqttCallbackHandler)this.get(handler);
    }

    public void setHandler(BAbstractMqttCallbackHandler v) {
        this.set(handler, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        BAbstractMqttDevice device;
        if (log.isLoggable(Level.FINE)) {
            log.fine("messageArrived: " + topic + ' ' + message);
        }
        if ((device = this.getAuthenticator().getMqttDevice()).isClientConnectedToBroker()) {
            this.getAuthenticator().executor.getExecutorService().submit(new Callback.MqttSubsCallable(device, topic, message));
        } else {
            log.warning("Received message while not connected to broker. " + message);
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        BAbstractMqttDevice device = this.getAuthenticator().getMqttDevice();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getAuthenticator().getClientID() + ": " + cause.getMessage());
        }
        String message = BAbstractMqttDevice.lex.get("connLost");
        device.setStatusMessage(message);
        this.getHandler().handleDisconnect(cause);
        device.getMqttClientDriverNetwork().removeClientIdFromList(this.getAuthenticator().getClientID());
        this.getAuthenticator().executor.getExecutorService().shutdown();
        while (!device.isClientConnectedToBroker()) {
            try {
                Thread.sleep(reconnectSleepTime);
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "During connection lost wait", e);
            }
            if (this.getAuthenticator().getCurrentMqttAction() == MqttActions.DISCONNECT) break;
            try {
                device.doConnect();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Connecting", e);
            }
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Delivery Complete " + token);
        }
    }

    public void started() throws Exception {
        if (this.isRunning()) {
            this.checkCallback();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(callbackType) || property.equals(handler)) {
            this.checkCallback();
        }
    }

    public void checkCallback() {
        if (!this.getCallbackType().getResolvedType().equals(this.getHandler().getType())) {
            this.setHandler((BAbstractMqttCallbackHandler)this.getCallbackType().getInstance());
        }
    }

    public BGcpAuthenticator getAuthenticator() {
        return (BGcpAuthenticator)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BAbstractMqttAuthenticator.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"connections.png");
    }
}

