/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.virtual;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.report.grid.BCompGridRow;
import com.tridium.report.grid.BComponentGrid;
import com.tridium.report.grid.BIComponentGrid;
import com.tridium.report.grid.BSingleRow;
import com.tridium.report.grid.GridCompUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.grid.GridModel;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"report:ComponentGrid"})})
public class BNiagaraVirtualComponentGrid
extends BNiagaraVirtualComponent
implements BIComponentGrid {
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualComponentGrid.class);
    private static final Logger LOG = Logger.getLogger("niagaraVirtualComponentGrid");

    public Type getType() {
        return TYPE;
    }

    @Override
    public GridModel resolve(BObject base, Context cx) {
        this.loadSlots();
        this.lease();
        return BComponentGrid.resolve(this, base, cx);
    }

    @Override
    public BCompGridRow[] getRows() {
        BOrd baseOrd = this.getNiagaraVirtualCompInfo().getSlotOrd();
        BCompGridRow[] rows = (BSingleRow[])this.getChildren(BSingleRow.class);
        HashMap<String, BCompGridRow> ordMap = new HashMap<String, BCompGridRow>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (BSingleRow)rows[i].newCopy(true);
            rows[i].setOrd(BOrd.make((BOrd)baseOrd, (BOrd)rows[i].getOrd()).normalize().relativizeToSession());
            ordMap.put("" + ((BSingleRow)rows[i]).getOrd(), rows[i]);
        }
        ArrayList<String> ordList = new ArrayList<String>(ordMap.keySet());
        Map<Object, Object> ordsToVirtualOrds = Collections.emptyMap();
        if (Sys.isStation()) {
            ordsToVirtualOrds = this.convertOrdsToVirtualOrds(ordList, null);
        } else {
            try {
                ordsToVirtualOrds = this.getSysChannel().niagaraRpc(this.getNavOrd(), "convertOrdsToVirtualOrds", new Object[]{ordList}).orElse(Collections.emptyMap());
            }
            catch (Exception err) {
                LOG.log(Level.WARNING, "Could not convert ORDs to Virtual ORDs", err);
            }
        }
        for (BCompGridRow row : rows) {
            String ordStr = (String)ordsToVirtualOrds.get("" + ((BSingleRow)row).getOrd());
            if (ordStr == null) continue;
            ((BSingleRow)row).setOrd(BOrd.make((String)ordStr));
        }
        return rows;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)}, permissions="r")
    public Map<String, String> convertOrdsToVirtualOrds(List<String> ordList, Context cx) {
        return this.convertOrdsToVirtualOrds(this.getComms(), ordList, this.getNiagaraVirtualGateway().getNavOrd().relativizeToSession());
    }

    private Map<String, String> convertOrdsToVirtualOrds(INiagaraVirtualCommsAdapter comms, List<String> ordList, BOrd baseOrd) {
        if (ordList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap handlesToOrds = new HashMap();
        HashMap<String, ArrayList<OrdQuery>> ordToQueries = new HashMap<String, ArrayList<OrdQuery>>();
        for (String ordStr : ordList) {
            try {
                OrdQuery[] queries = BOrd.make((String)ordStr).parse();
                ordToQueries.put(ordStr, new ArrayList<OrdQuery>(Arrays.asList(queries)));
                Arrays.stream(queries).filter(BNiagaraVirtualComponentGrid::isHandleQuery).map(OrdQuery::getBody).distinct().forEach(handle -> handlesToOrds.computeIfAbsent(handle, ord -> new ArrayList()).add(ordStr));
            }
            catch (NullOrdException | SyntaxException throwable) {}
        }
        if (!handlesToOrds.isEmpty()) {
            comms.handleToPath(new ArrayList(handlesToOrds.keySet()), "" + this.getOrdInSession()).forEach((handle, path) -> handlesToOrds.getOrDefault(handle, Collections.emptyList()).forEach(ord -> ordToQueries.computeIfPresent((String)ord, (o, queries) -> queries.stream().map(query -> BNiagaraVirtualComponentGrid.isHandleQuery(query) && handle.equals(query.getBody()) ? path : query).collect(Collectors.toList()))));
        }
        return ordToQueries.keySet().stream().filter(ord -> ((List)ordToQueries.get(ord)).stream().allMatch(query -> BNiagaraVirtualComponentGrid.isSlotPath(query) || query.isHost() || query.isSession() || query.getScheme().equals("station"))).collect(Collectors.toMap(Function.identity(), ord -> {
            String virtualPath = "/" + ((List)ordToQueries.get(ord)).stream().filter(BNiagaraVirtualComponentGrid::isSlotPath).map(query -> (SlotPath)query).map(query -> {
                ArrayList<String> names = new ArrayList<String>(query.depth() + 1);
                if (BNiagaraVirtualComponentGrid.isVirtualPath((OrdQuery)query)) {
                    names.add("virtual");
                }
                Collections.addAll(names, query.getNames());
                return String.join((CharSequence)"/", names);
            }).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"));
            return BOrd.make((BOrd)baseOrd, (OrdQuery)new VirtualPath(virtualPath)).normalize().toString();
        }));
    }

    private static boolean isVirtualPath(OrdQuery query) {
        return query instanceof VirtualPath;
    }

    private static boolean isHandleQuery(OrdQuery query) {
        return "h".equals(query.getScheme());
    }

    private static boolean isSlotPath(OrdQuery query) {
        return query instanceof SlotPath;
    }

    protected BSysChannel getSysChannel() {
        BFoxSession foxSession = (BFoxSession)this.getSession();
        return (BSysChannel)foxSession.getConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    public void started() throws Exception {
        super.started();
        GridCompUtil.addOperatorFlagToAllRowsAndColumns(this);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning()) {
            GridCompUtil.addOperatorSlotFlagIfRowOrColumn(this, property);
        }
    }

    public AgentList getAgents(Context cx) {
        return GridCompUtil.reorderAgents(super.getAgents(cx));
    }
}

