/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid;

import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.BCompGridRow;
import com.tridium.report.grid.BIComponentGrid;
import javax.baja.agent.AgentList;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComplex;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public final class GridCompUtil {
    private GridCompUtil() {
    }

    public static AgentList reorderAgents(AgentList agents) {
        agents.toTop("report:GridLabelPane");
        agents.toTop("report:GridTable");
        return agents;
    }

    public static void addOperatorFlagToAllRowsAndColumns(BIComponentGrid grid) {
        for (BCompGridColumn bCompGridColumn : grid.getColumns()) {
            GridCompUtil.addOperatorSlotFlagIfRowOrColumn(grid, bCompGridColumn.getPropertyInParent());
        }
        for (BStruct bStruct : grid.getRows()) {
            GridCompUtil.addOperatorSlotFlagIfRowOrColumn(grid, bStruct.getPropertyInParent());
        }
    }

    public static void addOperatorSlotFlagIfRowOrColumn(BIComponentGrid grid, Property property) {
        BComplex complex = (BComplex)grid;
        BValue value = complex.get(property);
        if (value instanceof BCompGridColumn || value instanceof BCompGridRow) {
            complex.setFlags((Slot)property, complex.getFlags((Slot)property) | 0x100);
        }
    }

    public static IPropertyValidator getPropertyModifyValidator(BIProtected target, Context cx) {
        if (target == null || cx == null || cx.getUser() == null) {
            return null;
        }
        return (validatable, context) -> {
            if (!cx.getUser().getPermissionsFor(target).hasAdminWrite()) {
                GridCompUtil.throwMustHaveModifyPermissions();
            }
        };
    }

    public static void checkModifyPermissionsIfRowOrColumn(BIProtected target, BValue value, Context cx) {
        if (cx != null && cx.getUser() != null && (value instanceof BCompGridColumn || value instanceof BCompGridRow) && !cx.getUser().getPermissionsFor(target).hasAdminWrite()) {
            GridCompUtil.throwMustHaveModifyPermissions();
        }
    }

    private static void throwMustHaveModifyPermissions() {
        throw new LocalizableRuntimeException("report", "mustHaveModifyPermissions");
    }
}

