/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.exporters;

import com.tridium.data.BDataTable;
import com.tridium.file.exporters.BITableToText;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.baja.data.BIDataValue;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BGridToText
extends BExporter {
    public static final Type TYPE = Sys.loadType(BGridToText.class);

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "txt";
    }

    public void export(ExportOp op) throws Exception {
        BIGrid grid = (BIGrid)op.get();
        BComponent gridComp = (BComponent)grid;
        GridModel model = grid.resolve((BObject)gridComp, (Context)op);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
        out.println(gridComp.getName());
        out.println(gridComp.getSlotPath());
        out.println(BAbsTime.now());
        out.println("");
        out.flush();
        BDataTable table = BGridToText.makeTable(model, (Context)op);
        ExportOp sub = ExportOp.make((OrdTarget)new OrdTarget((OrdTarget)op, (BObject)table), (OutputStream)op.getOutputStream());
        new BITableToText().export(sub);
    }

    public static BDataTable makeTable(GridModel model, Context cx) {
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        BDataTable t = new BDataTable();
        for (int c = 0; c < colCount; ++c) {
            String displayName = model.getColumnName(c);
            String name = SlotPath.escape((String)displayName);
            t.addColumn(name, displayName, BString.TYPE, 0, BFacets.NULL);
        }
        t.startRows();
        for (int r = 0; r < rowCount; ++r) {
            t.startRow();
            for (int c = 0; c < colCount; ++c) {
                String v = "";
                BObject obj = model.getObjectAt(r, c);
                if (obj != null) {
                    BFormat f = model.getColumnFormat(c);
                    v = f == null ? obj.toString() : f.format((Object)obj, cx);
                }
                t.set((BIDataValue)BString.make((String)v), BFacets.NULL);
            }
            t.endRow();
        }
        t.endRows();
        return t;
    }
}

