/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.report.BReport;
import javax.baja.report.BReportRecipient;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileRecipient
extends BReportRecipient {
    public static final Property ord = BFileRecipient.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:DirectoryOrdFE")));
    public static final Property appendTimestamp = BFileRecipient.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BFileRecipient.class);
    private static final BIcon icon = BIcon.std((String)"file.png");

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public boolean getAppendTimestamp() {
        return this.getBoolean(appendTimestamp);
    }

    public void setAppendTimestamp(boolean v) {
        this.setBoolean(appendTimestamp, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void handleRoute(BReport report) throws Exception {
        String filename = report.getFileName();
        if (this.getAppendTimestamp()) {
            int i = filename.lastIndexOf(".");
            filename = filename.substring(0, i) + new SimpleDateFormat("-yyyyMMdd-HHmm").format(new Date()) + filename.substring(i);
        }
        BIFile file = (BIFile)this.getOrd().resolve().get();
        BDirectory dir = file.getFileSpace().makeDir(file.getFilePath(), null);
        FilePath path = dir.getFilePath().merge(filename);
        BIFile target = file.getFileSpace().makeFile(path, null);
        OutputStream out = target.getOutputStream();
        byte[] buf = report.getContent();
        out.write(buf, 0, buf.length);
        out.flush();
        out.close();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == ord) {
            BOrd ord = (BOrd)this.get(property);
            if (ord.equals((Object)BOrd.NULL) || ord.equals((Object)BOrd.DEFAULT)) {
                return;
            }
            BObject object = ord.get();
            if (object instanceof BIFile) {
                BIFile file = (BIFile)object;
                if (!file.isDirectory()) {
                    this.setOrd(BOrd.DEFAULT);
                    throw new BajaRuntimeException("Invalid ORD: " + ord.encodeToString() + ". ORD must resolve to a File Directory.");
                }
            } else {
                this.setOrd(BOrd.DEFAULT);
                throw new BajaRuntimeException("Invalid ORD: " + ord.encodeToString() + ". ORD must resolve to a File Directory.");
            }
        }
        super.changed(property, context);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

