/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.sys;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.json.JAppWriter;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceAppFile;
import com.tridium.ace.sys.BIAceSpace;
import com.tridium.json.JSONObject;
import com.tridium.nre.util.FileLock;
import com.tridium.sys.engine.EngineUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAceSpace
extends BComponentSpace
implements BIAceSpace {
    public static final Type TYPE = Sys.loadType(BAceSpace.class);
    BAceAppFile appFile;
    boolean modified;
    public static final int JSON_INDENT = 2;

    public Type getType() {
        return TYPE;
    }

    public BAceSpace(BAceAppFile appFile) {
        super(appFile.getFileName(), null, BOrd.make((BOrd)appFile.getOrdInSession(), (String)"ace:"));
        this.appFile = appFile;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void modified(BComponent c, Context context) {
        this.modified = true;
    }

    public void childParented(BComponent c, Property property, BValue newChild, Context context) {
        BBoolean auto;
        if (context != null && (auto = (BBoolean)context.getFacet("niagaraAutoStart")) != null && !auto.getBoolean()) {
            return;
        }
        if (newChild instanceof BAceComponent) {
            EngineUtil.activateLinks((BComponent)((BComponent)newChild));
        } else if (newChild instanceof BAceLink) {
            EngineUtil.activate((BLink)((BLink)newChild));
        }
    }

    public void childUnparented(BComponent c, Property property, BValue oldChild, Context context) {
        if (oldChild instanceof BAceComponent) {
            EngineUtil.deactivateLinks((BComponent)((BComponent)oldChild));
        } else if (oldChild instanceof BLink) {
            EngineUtil.deactivate((BLink)((BLink)oldChild));
        }
    }

    public int hashCode() {
        return this.appFile.toString(null).hashCode();
    }

    public boolean isSpaceReadonly() {
        return this.appFile != null && this.appFile.isReadonly();
    }

    public boolean isMounted() {
        return this.appFile != null;
    }

    public BHost getHost() {
        if (this.appFile == null) {
            return null;
        }
        return this.appFile.getHost();
    }

    public BISession getSession() {
        if (this.appFile == null) {
            return null;
        }
        return this.appFile.getSession();
    }

    public BOrd getAbsoluteOrd() {
        if (this.appFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.appFile.getAbsoluteOrd(), (String)"ace:");
    }

    public BOrd getOrdInHost() {
        if (this.appFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.appFile.getOrdInHost(), (String)"ace:");
    }

    public BOrd getOrdInSession() {
        if (this.appFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.appFile.getOrdInSession(), (String)"ace:");
    }

    public BINavNode getNavParent() {
        return this.getAceAppFile();
    }

    public BAceAppFile getAceAppFile() {
        return this.appFile;
    }

    public BAceApp getRootComponent() {
        return (BAceApp)super.getRootComponent();
    }

    void save() throws Exception {
        this.checkLock();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JAppWriter aceAppWriter = new JAppWriter();
            aceAppWriter.encode((OutputStream)os, this.appFile, this.appFile.getCatalog());
            JSONObject appJson = new JSONObject(os.toString());
            try (OutputStream fos = this.appFile.getOutputStream();){
                fos.write(appJson.toString(2).getBytes(Charset.forName("UTF-8")));
                this.modified = false;
            }
        }
    }

    void close() {
        this.appFile = null;
        this.setRootComponent(null);
    }

    public void checkLock() throws Exception {
        if (this.appFile.getStore() instanceof BLocalFileStore) {
            BLocalFileStore store = (BLocalFileStore)this.appFile.getStore();
            File localFile = store.getLocalFile();
            BAceAppFile.LOG.fine("Check lock " + localFile);
            FileLock.check((File)localFile);
        }
    }

    protected void setModified(boolean value) {
        this.modified = value;
    }
}

