/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.program;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.app.App;
import com.tridium.ace.app.Link;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.util.LicenseUtil;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.util.CompUtil;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="getMissingModules", returnType="BString", flags=4)
public class BAceViewApp
extends BSimpleJob {
    public static final Action getMissingModules = BAceViewApp.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAceViewApp.class);
    private static final Lexicon LEX = Lexicon.make((String)"ace");
    private BAceDevice dev;
    private NComm comm;
    private BAddress adr;
    private Catalog catalog;
    private BString unloadedModules = null;

    public BString getMissingModules() {
        return (BString)this.invoke(getMissingModules, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAceViewApp() {
    }

    public BAceViewApp(BAceDevice dev) {
        this.dev = dev;
        this.comm = dev.getAceNetwork().ncomm();
        this.adr = dev.getAddress();
        this.catalog = dev.loadCatalog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        try {
            BAceComponent[] cps;
            byte[] appEmb;
            Object object = this.dev.lock;
            synchronized (object) {
                this.dev.implSaveApp();
                appEmb = this.dev.implReadFile("app.ace");
                if (appEmb == null) {
                    throw new BajaRuntimeException("Can't read app.ace");
                }
            }
            this.log().message(LEX.get("ace.viewApp.read"));
            JAppReader aceAppReader = new JAppReader(true);
            Catalog catalog = aceAppReader.decodeCatalog(new ByteArrayInputStream(appEmb));
            App app = aceAppReader.decode(new ByteArrayInputStream(appEmb), catalog);
            HashMap<Integer, BAceComponent> aceComponents = new HashMap<Integer, BAceComponent>();
            BAceApp aceApp = aceAppReader.buildComponentTree(app, aceComponents, catalog);
            int limit = LicenseUtil.getComponentLimit();
            if (aceApp.getComponentCnt() > limit) {
                throw new Exception("There are more components than license permits");
            }
            if (this.dev.get("App") != null) {
                this.dev.remove("App", BNNetwork.noWrite);
            }
            Property p = this.dev.add("App", aceApp.newCopy(true), 2, BNNetwork.noWrite);
            Hashtable<Integer, BAceComponent> compMap = new Hashtable<Integer, BAceComponent>();
            for (BAceComponent cp : cps = (BAceComponent[])CompUtil.getDescendants((BComponent)this.dev.get(p).asComponent(), BAceComponent.class)) {
                compMap.put(cp.getObjectId(), cp);
            }
            this.processLinks(app, compMap);
            this.processReadonly(compMap);
            String modules = aceAppReader.verifyTypes();
            if (modules.length() > 1) {
                this.unloadedModules = BString.make((String)modules);
            }
            this.log().success(LEX.get("ace.viewApp.complete"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.failed(e);
        }
    }

    private void processReadonly(Hashtable<Integer, BAceComponent> compMap) {
        BAceProxyExt[] a;
        for (BAceProxyExt ext : a = (BAceProxyExt[])DrUtil.getDecendantsByClass((BComponent)this.dev.getPoints(), BAceProxyExt.class)) {
            BAceComponent ac;
            if (!ext.getParentPoint().isWritablePoint() || (ac = compMap.get(ext.getCompId())) == null) continue;
            ac.setReadonly(ext.getPropId(), true);
        }
    }

    private void processLinks(App aceApp, Hashtable<Integer, BAceComponent> compMap) throws Exception {
        for (Link lnk : aceApp.getLinks()) {
            BAceComponent srcComp = compMap.get(new Integer(lnk.getFromComponentId()));
            BAceComponent tgtComp = compMap.get(new Integer(lnk.getToComponentId()));
            Property sourceSlot = srcComp.getProperty(lnk.getFromSlotName());
            Property targetSlot = tgtComp.getProperty(lnk.getToSlotName());
            if (srcComp == null) {
                this.log().message("missing srcComp for link " + this.linkToString(lnk));
            }
            if (tgtComp == null) {
                this.log().message("missing tgtComp for link " + this.linkToString(lnk));
            }
            if (sourceSlot == null) {
                this.log().message("missing sourceSlot for link " + this.linkToString(lnk));
            }
            if (targetSlot == null) {
                this.log().message("missing targetSlot for link " + this.linkToString(lnk));
            }
            if (srcComp == null || tgtComp == null || sourceSlot == null || targetSlot == null) continue;
            BAceLink newLink = new BAceLink(srcComp.getHandleOrd(), sourceSlot.getName(), targetSlot.getName());
            tgtComp.add(null, (BValue)newLink, BNNetwork.noWrite);
            newLink.activate();
        }
    }

    String linkToString(Link lnk) {
        return Integer.toString(lnk.getFromComponentId()) + ":" + lnk.getFromSlotName() + " to " + Integer.toString(lnk.getToComponentId()) + ":" + lnk.getToSlotName();
    }

    public BString doGetMissingModules() {
        return this.unloadedModules;
    }
}

