/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.program;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.datatypes.BAceReadFileParams;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="getData", returnType="BBlob", flags=4)
public class BAceReadFileJob
extends BSimpleJob {
    public static final Action getData = BAceReadFileJob.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAceReadFileJob.class);
    private BBlob blob;
    private BAceNetwork ace;
    private BAceReadFileParams param;

    public BBlob getData() {
        return (BBlob)this.invoke(getData, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAceReadFileJob() {
    }

    public BAceReadFileJob(BAceNetwork ace, BAceReadFileParams param) {
        this.ace = ace;
        this.param = param;
    }

    public void run(Context cx) throws Exception {
        String fileName = this.param.getAppFileName();
        BAceDevice dev = (BAceDevice)this.param.getDev().resolve((BObject)this.ace).getComponent();
        if (dev != null) {
            try {
                this.blob = dev.readFile(BString.make((String)fileName));
                this.log().message("Uploaded " + dev.getDisplayName(null));
            }
            catch (Throwable e) {
                this.log().failed("Failed to upload " + dev.getDisplayName(null), e);
                this.failed(e);
            }
        } else {
            throw new Exception("Failed to upload: device is null");
        }
    }

    public BBlob doGetData() {
        return this.blob;
    }
}

