/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.AceSystemFacets;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.point.ComponentCollector;
import com.tridium.ace.point.PointGatherer;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;

public abstract class BasePointGatherer
implements PointGatherer {
    protected final Catalog catalog;

    BasePointGatherer(Catalog catalog) {
        this.catalog = catalog;
    }

    protected void gatherKitComponentPoints(ComponentCollector collector, String typeName) {
        int delimNdx = typeName.indexOf("::");
        if (delimNdx > 0 && delimNdx < typeName.length() - 2) {
            String kitName = typeName.substring(0, delimNdx);
            String componentName = typeName.substring(delimNdx + 2);
            CatalogKit kit = this.catalog.get(kitName);
            if (kit != null) {
                this.gatherComponentPoints(collector, kit, typeName, componentName);
            }
        }
    }

    private void gatherComponentPoints(ComponentCollector collector, CatalogKit kit, String typeName, String componentName) {
        AceType component = kit.type(componentName);
        if (component != null) {
            this.gatherThisComponentPoints(collector, component, typeName);
        }
    }

    private void gatherThisComponentPoints(ComponentCollector collector, AceType component, String typeName) {
        for (AceSlot slot : component.getSlots()) {
            boolean config = slot.isConfiguration();
            BAceSlotTypeEnum slotType = BasePointGatherer.getSlotTypeFromFacets(slot.getFacets());
            BAcePrimitiveTypeEnum dataType = slot.getPrimType();
            if (slot.getSlotId() == 0 || slot.getSlotId() == 1 || dataType == BAcePrimitiveTypeEnum.s64 || dataType == BAcePrimitiveTypeEnum.byteArray) continue;
            String slotName = slot.getName();
            int slotId = component.getSlotIndex(slotName);
            BValue defaultValue = slot.getDefaultValue();
            collector.foundKitPoint(typeName, slotId, slotName, dataType, slotType, config, slot.getFacets().toFacets(), defaultValue);
        }
    }

    private static BAceSlotTypeEnum getSlotTypeFromFacets(AceSystemFacets slotFacets) {
        BBoolean actionValue = (BBoolean)slotFacets.getValue("action");
        if (actionValue != null && actionValue == BBoolean.TRUE) {
            return BAceSlotTypeEnum.action;
        }
        BBoolean inputValue = (BBoolean)slotFacets.getValue("input");
        if (inputValue != null && inputValue == BBoolean.TRUE) {
            return BAceSlotTypeEnum.input;
        }
        BBoolean configValue = (BBoolean)slotFacets.getValue("config");
        if (configValue != null && configValue == BBoolean.TRUE) {
            return BAceSlotTypeEnum.input;
        }
        BBoolean outputValue = (BBoolean)slotFacets.getValue("output");
        if (outputValue != null && outputValue == BBoolean.TRUE) {
            return BAceSlotTypeEnum.output;
        }
        return BAceSlotTypeEnum.unknown;
    }
}

