/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.kit;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceDynamicComp;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.CatalogKit;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;

public interface AceType
extends Comparable<AceType> {
    public static final Lexicon lex = Lexicon.make((String)"ace");
    public static final Logger log = Logger.getLogger(AceType.class.getSimpleName());

    public String getTypeName();

    public String getKitName();

    public CatalogKit getKit();

    default public AceType getJson() {
        return this;
    }

    default public List<AceSlot> getProperties() {
        return this.getSlots().stream().filter(slot -> !slot.isAction()).collect(Collectors.toList());
    }

    default public List<AceSlot> getActions() {
        return this.getSlots().stream().filter(slot -> slot.isAction()).collect(Collectors.toList());
    }

    default public List<AceSlot> getConfigurationSlots() {
        return this.getSlots().stream().filter(slot -> slot.isConfiguration()).collect(Collectors.toList());
    }

    public List<AceSlot> getSlots();

    public AceSlot getSlot(String var1);

    public Integer getSlotIndex(String var1);

    default public BAceComponent newInstance() {
        return this.newInstance(false);
    }

    default public BAceComponent newInstance(boolean online) {
        try {
            Type componentType = Sys.getType((String)("ace:Ace" + this.getTypeName()));
            log.finer("New Instance: " + componentType.getTypeInfo().toString());
            return (BAceComponent)componentType.getInstance();
        }
        catch (InstantiationError err) {
            log.finer("  Failed to create AceComponent: " + err.getLocalizedMessage());
        }
        catch (TypeNotFoundException err) {
            // empty catch block
        }
        BAceDynamicComp c = new BAceDynamicComp(this.getTypeName(), this.getKitName());
        c.loadFromAceType(this, online);
        return c;
    }

    default public AceSlot getSlot(int slotId) {
        return this.getSlots().get(slotId);
    }

    public void addFacet(String var1, BIDataValue var2);

    public BFacets getFacets();
}

