/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.json;

import com.tridium.ace.app.App;
import com.tridium.ace.enums.AceSystemFacets;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.json.JComponent;
import com.tridium.ace.json.JSlot;
import com.tridium.ace.kit.AceCatalog;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogHeader;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.kit.TypeNameException;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.query.BNull;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;

public class JCatalogReader {
    public static Lexicon lex = Lexicon.make((String)"ace");
    private static final Logger LOG = Logger.getLogger("JCatalogReader");

    public static Catalog load(InputStream is, KitRegistry catalog) throws IOException {
        Catalog newCatalog = JCatalogReader.load(is);
        for (CatalogKit kit : newCatalog.kits()) {
            if (catalog.get(kit.getName()) == null) {
                catalog.add(kit);
                continue;
            }
            String message = "Duplicate kit name '" + kit.getName() + "' found - kept first instance and discarded others";
            LOG.warning(message);
        }
        catalog.addDefaultApp(newCatalog.getDefaultApp());
        catalog.addCatalogHeader(newCatalog.getCatalogHeader());
        return catalog;
    }

    public static Catalog load(InputStream is) throws IOException {
        String product;
        String platformVersion;
        JSONObject metaData;
        AceCatalog catalog = new AceCatalog();
        long start = Clock.ticks();
        LOG.fine("loading catalog JSON");
        JSONTokener tok = new JSONTokener((Reader)new InputStreamReader(is, Charset.forName("UTF-8")));
        JSONObject root = new JSONObject(tok);
        JSONArray jKits = root.getJSONArray("kits");
        String schVersion = JSONUtil.getString((JSONObject)root, (String)"catalogSchemaVersion");
        if (schVersion.length() < 1) {
            LOG.info("There is not catalogSchemaVersion in catalog");
        }
        if ((metaData = root.getJSONObject("catalogMetaData")) == null) {
            throw new IOException("Failed to get catalogMetaData");
        }
        String frameworkVersion = JSONUtil.getString((JSONObject)metaData, (String)"frameworkVersion");
        if (frameworkVersion.length() < 1) {
            LOG.info("There is not frameworkVersion in catalog");
        }
        if ((platformVersion = JSONUtil.getString((JSONObject)metaData, (String)"platformVersion")).length() < 1) {
            LOG.info("There is not platformVersion in catalog");
        }
        if ((product = JSONUtil.getString((JSONObject)metaData, (String)"product")).length() < 1) {
            throw new IOException("There is not product in catalog");
        }
        String vendor = JSONUtil.getString((JSONObject)metaData, (String)"vendor");
        if (vendor.length() < 1) {
            throw new IOException("There is not vendor in catalog");
        }
        CatalogHeader header = new CatalogHeader(schVersion, frameworkVersion, platformVersion, product, vendor);
        catalog.addCatalogHeader(header);
        LOG.fine("Loading " + jKits.length() + " kits");
        for (int i = 0; i < jKits.length(); ++i) {
            JSONObject jKit = jKits.getJSONObject(i);
            String kitName = JSONUtil.getString((JSONObject)jKit, (String)"kitName");
            String kitDisplayName = jKit.has("kitDisplayName") ? JSONUtil.getString((JSONObject)jKit, (String)"kitDisplayName") : kitName;
            long checksum = jKit.getLong("checksum");
            JSONArray jTypes = jKit.getJSONArray("types");
            LOG.fine("loading kit: " + kitName);
            CatalogKit kit = new CatalogKit(kitName, kitDisplayName, checksum, catalog);
            if (catalog.get(kitName) == null) {
                catalog.add(kit);
            } else {
                String message = "Duplicate kit name '" + kitName + "' found - kept first instance and discarded others";
                LOG.warning(message);
            }
            LOG.fine("Loading " + jTypes.length() + " types");
            for (int typeIdx = 0; typeIdx < jTypes.length(); ++typeIdx) {
                JSONObject jType = jTypes.getJSONObject(typeIdx);
                try {
                    AceType aceType = JCatalogReader.loadType(jType, typeIdx, kit);
                    String qname = aceType.getTypeName();
                    if (kit.type(aceType.getTypeName()) != null) {
                        throw new TypeNameException("Duplicate type name: " + qname);
                    }
                    kit.add(aceType);
                    LOG.fine("loaded type: " + aceType.getTypeName());
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("Failed to load type: " + jType, e);
                }
            }
            LOG.fine("Loaded KitRegistry in " + (Clock.ticks() - start) + " ms");
        }
        try {
            JSONObject defaultApp = root.getJSONObject("defaultApp");
            JAppReader aceAppReader = new JAppReader();
            App app = aceAppReader.decode(defaultApp, (Catalog)catalog);
            catalog.addDefaultApp(app);
        }
        catch (JSONException e) {
            LOG.fine("No default app in catalog");
        }
        return catalog;
    }

    private static AceType loadType(JSONObject jType, int typeIdx, CatalogKit kit) throws TypeNameException, IOException {
        JComponent aceType;
        try {
            aceType = JCatalogReader.decode(jType);
            aceType.setKit(kit);
        }
        catch (Exception e) {
            throw new IOException("Failed to decode aceType from JSON", e);
        }
        return aceType;
    }

    public static JComponent decode(JSONObject compObject) {
        JSONObject compType = compObject.getJSONObject("type");
        JComponent jcomp = new JComponent();
        jcomp.setAceType(JSONUtil.getString((JSONObject)compType, (String)"name"));
        if (compObject.has("facets")) {
            JSONObject compFacets = compObject.getJSONObject("facets");
            Iterator itr = compFacets.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Object facet = compFacets.get(key);
                if (facet instanceof Boolean) {
                    jcomp.addFacet(key, (BIDataValue)BBoolean.make((boolean)((Boolean)facet)));
                    continue;
                }
                jcomp.addFacet(key, (BIDataValue)BString.make((String)facet.toString()));
            }
        }
        if (compObject.has("slots")) {
            JSONArray props = compObject.getJSONArray("slots");
            for (int i = 0; i < props.length(); ++i) {
                JSONObject facets;
                JSONObject p = props.getJSONObject(i);
                JSlot js = new JSlot();
                js.name = JSONUtil.getString((JSONObject)p, (String)"name");
                js.primType = BAcePrimitiveTypeEnum.fromJsonName(JSONUtil.getString((JSONObject)p, (String)"slotType"));
                js.id = i;
                if (p.has("length")) {
                    js.len = p.getInt("length");
                }
                if (p.has("facets") && (facets = p.getJSONObject("facets")).length() > 0) {
                    js.slotFacets = new AceSystemFacets();
                    Iterator iterator = facets.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        Object facet = facets.get(key);
                        if (facet instanceof Boolean) {
                            js.slotFacets.addSystemFacet(key, (BIDataValue)BBoolean.make((boolean)((Boolean)facet)));
                            continue;
                        }
                        if (facet instanceof Integer) {
                            js.slotFacets.addSystemFacet(key, (BIDataValue)BInteger.make((int)((Integer)facet)));
                            continue;
                        }
                        if (facet instanceof Long) {
                            js.slotFacets.addSystemFacet(key, (BIDataValue)BLong.make((long)((Long)facet)));
                            continue;
                        }
                        if (facet instanceof Number) {
                            js.slotFacets.addSystemFacet(key, (BIDataValue)BDouble.make((double)((Number)facet).doubleValue()));
                            continue;
                        }
                        js.slotFacets.addSystemFacet(key, (BIDataValue)BString.make((String)facet.toString()));
                    }
                    if (js.slotFacets.facets.get((Object)BAceSlotTypeEnum.config) != null) {
                        js.slotFacets.facets.remove((Object)BAceSlotTypeEnum.output);
                    }
                }
                if (p.has("default")) {
                    js.hasDefault = true;
                    Object d = p.get("default");
                    js.defaultValue = JCatalogReader.defaultJSONValue(d, js.primType);
                }
                jcomp.addSlot(js);
            }
        }
        JCatalogReader.linkEnumRange(jcomp);
        return jcomp;
    }

    private static void linkEnumRange(JComponent jcomp) {
        for (AceSlot js : jcomp.getSlots()) {
            String enumList;
            BIDataValue eList;
            if (!js.getFacets().facets.containsKey((Object)BAceSlotTypeEnum.enumList) || (eList = js.getFacets().facets.get((Object)BAceSlotTypeEnum.enumList)) == null || !(enumList = eList.toString(null)).startsWith("::")) continue;
            String rngPropName = js.getName();
            AceSlot sl = jcomp.getSlot(enumList.substring(2));
            if (sl == null) continue;
            BIDataValue val = sl.getFacets().facets.get((Object)BAceSlotTypeEnum.enumRange);
            if (val != null) {
                rngPropName = rngPropName + "," + val.toString(null);
            }
            sl.getFacets().addSystemFacet(BAceSlotTypeEnum.enumRange.getTag(), (BIDataValue)BString.make((String)rngPropName));
            sl.getFacets().addSystemFacet(BAceSlotTypeEnum.fieldEditor.getTag(), (BIDataValue)BString.make((String)"ace:AceEnumRangeFE"));
        }
    }

    protected static BValue defaultJSONValue(Object value, BAcePrimitiveTypeEnum primType) {
        return JCatalogReader.defaultJSONValue(value, BStatus.nullStatus, primType);
    }

    protected static BValue defaultJSONValue(Object value, BStatus status, BAcePrimitiveTypeEnum primType) {
        try {
            switch (primType.getOrdinal()) {
                case 0: {
                    return BNull.DEFAULT;
                }
                case 1: {
                    return BBoolean.make((boolean)((Boolean)value));
                }
                case 2: 
                case 3: 
                case 4: {
                    return BInteger.make((int)((Number)value).intValue());
                }
                case 5: {
                    return BLong.make((long)((Number)value).longValue());
                }
                case 9: {
                    return new BStatusNumeric((double)((Number)value).longValue(), status);
                }
                case 6: {
                    return BFloat.make((float)((Number)value).floatValue());
                }
                case 10: {
                    return new BStatusNumeric((double)((Number)value).floatValue(), status);
                }
                case 7: {
                    return BDouble.make((double)((Number)value).doubleValue());
                }
                case 11: {
                    return new BStatusNumeric(((Number)value).doubleValue(), status);
                }
                case 13: {
                    return BString.make((String)value.toString());
                }
                case 8: {
                    return new BStatusBoolean(((Boolean)value).booleanValue(), status);
                }
                case 12: {
                    return BString.make((String)value.toString());
                }
            }
            System.out.println("Invalid primitive type: " + (Object)((Object)primType));
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private BStatus toStatus(String s) {
        if (s == null) {
            return BStatus.nullStatus;
        }
        try {
            BStatus stat = BStatus.make((int)BStatus.DEFAULT.tagToOrdinal(s));
            if (stat != null) {
                return stat;
            }
        }
        catch (Exception e) {
            return BStatus.nullStatus;
        }
        return BStatus.nullStatus;
    }
}

