/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.enums;

import com.tridium.ace.enums.BAceSlotTypeEnum;
import java.util.HashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class AceSystemFacets {
    public static final AceSystemFacets DEFAULT = AceSystemFacets.make("unknown", (BIDataValue)BBoolean.DEFAULT);
    public Map<BAceSlotTypeEnum, BIDataValue> facets = new HashMap<BAceSlotTypeEnum, BIDataValue>();

    public static AceSystemFacets make(String facetName, BIDataValue value) {
        AceSystemFacets newFacets = new AceSystemFacets();
        newFacets.addSystemFacet(facetName, value);
        return newFacets;
    }

    public void addSystemFacet(String facetName, BIDataValue value) {
        if (facetName.equals("override")) {
            return;
        }
        if (!this.isTag(facetName)) {
            return;
        }
        this.facets.put(BAceSlotTypeEnum.make(facetName), value);
    }

    public boolean isOrdinal(int ordinal) {
        return BAceSlotTypeEnum.DEFAULT.getRange().isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return BAceSlotTypeEnum.DEFAULT.getRange().getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return BAceSlotTypeEnum.DEFAULT.getRange().getDisplayTag(ordinal, cx);
    }

    public boolean isTag(String tag) {
        return BAceSlotTypeEnum.DEFAULT.getRange().isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return BAceSlotTypeEnum.DEFAULT.getRange().tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.facets.isEmpty();
    }

    public boolean hasEntry(String facetName) {
        if (!this.isTag(facetName)) {
            return false;
        }
        return this.facets.containsKey((Object)BAceSlotTypeEnum.make(facetName));
    }

    public BIDataValue getValue(String facetName) {
        if (!this.hasEntry(facetName)) {
            return null;
        }
        return this.facets.get((Object)BAceSlotTypeEnum.make(facetName));
    }

    private BFacets getFacets(BAceSlotTypeEnum slotType) {
        if (this.hasEntry(slotType.getTag())) {
            return BFacets.make((String)slotType.getTag(), (BIDataValue)this.facets.get((Object)slotType));
        }
        return null;
    }

    public BFacets toFacets() {
        String[] names = new String[this.facets.size()];
        BIDataValue[] values = new BIDataValue[this.facets.size()];
        int i = 0;
        for (Map.Entry<BAceSlotTypeEnum, BIDataValue> entry : this.facets.entrySet()) {
            names[i] = entry.getKey().getTag();
            values[i] = entry.getValue();
            ++i;
        }
        return BFacets.make((String[])names, (BIDataValue[])values);
    }
}

