/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.component;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceAction;
import com.tridium.ace.component.BAceDynamicComp;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.datatypes.BExeParam;
import com.tridium.ace.datatypes.BIAceInteger;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.kit.ACE;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.message.AceConst;
import com.tridium.ace.message.AceObjPropValue;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceAppFile;
import com.tridium.ace.sys.BAceSpace;
import com.tridium.ace.util.LicenseUtil;
import com.tridium.ace.util.Meta;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.sys.Nre;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="int", defaultValue="-1", flags=73, facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="meta", type="int", defaultValue="0", flags=1, facets={@Facet(name="\"pId\"", value="0"), @Facet(name="\"type\"", value="\"s32\""), @Facet(name="\"config\"", value="true")}), @NiagaraProperty(name="exeParam", type="BExeParam", defaultValue="BExeParam.DEFAULT", flags=73, facets={@Facet(name="\"pId\"", value="1"), @Facet(name="\"type\"", value="\"u8\""), @Facet(name="\"config\"", value="true")}), @NiagaraProperty(name="loaded", type="boolean", defaultValue="false", flags=6)})
@NiagaraActions(value={@NiagaraAction(name="forceRead"), @NiagaraAction(name="viewChanged", flags=4)})
public abstract class BAceComponent
extends BComponent
implements AceConst,
ICoalesceable {
    public static final int SLOT_META = 0;
    public static final int SLOT_EXE_PARAM = 1;
    public static final int COMPONENT_SLOT_CNT = 2;
    public static final int MINIMUM_EXEC_ORDER = 1;
    public static final Property objectId = BAceComponent.newProperty((int)73, (int)-1, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property meta = BAceComponent.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"pId", (int)0), (BFacets)BFacets.make((String)"type", (String)"s32")), (BFacets)BFacets.make((String)"config", (boolean)true)));
    public static final Property exeParam = BAceComponent.newProperty((int)73, (BValue)BExeParam.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"pId", (int)1), (BFacets)BFacets.make((String)"type", (String)"u8")), (BFacets)BFacets.make((String)"config", (boolean)true)));
    public static final Property loaded = BAceComponent.newProperty((int)6, (boolean)false, null);
    public static final Action forceRead = BAceComponent.newAction((int)0, null);
    public static final Action viewChanged = BAceComponent.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAceComponent.class);
    public static final int LEVEL_BIT_SHIFT = 6;
    public static final int LEVEL_MASK = 3;
    public static final int ORDER_MASK = 63;
    public static final int LEVEL_BITS = 192;
    BStatus status = BStatus.ok;
    boolean covRegistered = false;
    boolean propTabInited = false;
    IntHashMap propTab = new IntHashMap();
    protected static Logger LOG = Logger.getLogger("AceNetwork");
    private static Logger COV_LOG = BAceNetwork.COV_LOG;
    public static Lexicon lex = Lexicon.make((String)"ace");
    private int key = -1;

    public int getObjectId() {
        return this.getInt(objectId);
    }

    public void setObjectId(int v) {
        this.setInt(objectId, v, null);
    }

    public int getMeta() {
        return this.getInt(meta);
    }

    public void setMeta(int v) {
        this.setInt(meta, v, null);
    }

    public BExeParam getExeParam() {
        return (BExeParam)this.get(exeParam);
    }

    public void setExeParam(BExeParam v) {
        this.set(exeParam, (BValue)v, null);
    }

    public boolean getLoaded() {
        return this.getBoolean(loaded);
    }

    public void setLoaded(boolean v) {
        this.setBoolean(loaded, v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void viewChanged() {
        this.invoke(viewChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAceNetwork ace() {
        return (BAceNetwork)DrUtil.getParent((BComplex)this, (Type)BAceNetwork.TYPE);
    }

    public BAceDevice dev() {
        return (BAceDevice)DrUtil.getParent((BComplex)this, (Type)BAceDevice.TYPE);
    }

    public abstract String getAceTypeName();

    public abstract String getAceKitName();

    public boolean isAceApp() {
        return false;
    }

    public void started() throws Exception {
        super.started();
        this.checkStatus();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || this.dev() == null || !this.dev().isOperational()) {
            return;
        }
        if (BNNetwork.noWrite.equals(cx)) {
            return;
        }
        int pId = p.getFacets().geti("pId", -1);
        if (pId >= 0 && !p.isAction()) {
            this.slotChanged(p, pId, cx);
        }
        if (p.getName().equals("wsAnnotation")) {
            this.updateMeta(cx);
        }
        if (p.equals(objectId)) {
            this.dev().clearComponentCache();
            this.dev().covReg().add(this);
        }
    }

    public void updateMeta(Context cx) {
        BWsAnnotation an = (BWsAnnotation)this.get("wsAnnotation");
        if (an == null) {
            return;
        }
        Meta newMeta = Meta.make(this.getMeta());
        newMeta.setX(an.p);
        newMeta.setY(an.q);
        newMeta.setWidth(an.wixelWidth);
        this.setInt(meta, newMeta.getMeta(), cx);
    }

    private void slotChanged(Property p, int pId, Context cx) {
        if (Flags.isLinkTarget((BComplex)this, (Slot)p)) {
            return;
        }
        this.dev().getWriteWorker().write(this, p, pId);
    }

    private void addComponents(BAceComponent cp) {
        BAceComponent[] comps;
        AceUtil.addComponent(cp, null);
        for (BAceComponent acp : comps = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)cp, BAceComponent.class)) {
            AceUtil.addComponent(acp, null);
        }
    }

    private void initOfflineComponent(BAceComponent cp) {
        if (cp.getType().is(BAceDynamicComp.TYPE)) {
            BAceDynamicComp comp = (BAceDynamicComp)cp;
            comp.doImportJson(false);
            for (BAceAction a : (BAceAction[])comp.getChildren(BAceAction.class)) {
                comp.remove(a.getPropertyInParent(), Context.decoding);
            }
        }
        if (cp.getObjectId() < 0 && cp.getHandle() != null) {
            cp.setObjectId(Integer.parseInt((String)cp.getHandle(), 16));
            LOG.finer(" ACE component handle: " + cp.getHandle().toString() + ", objectId: " + cp.getObjectId());
        }
    }

    public void added(Property prop, Context cx) {
        Property ann;
        BAceComponent cp;
        BSpace space = this.getSpace();
        if (space instanceof BAceSpace && prop.getType().is(TYPE)) {
            BAceComponent[] comps;
            cp = (BAceComponent)this.get(prop);
            this.initOfflineComponent(cp);
            for (BAceComponent acp : comps = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)cp, BAceComponent.class)) {
                this.initOfflineComponent(acp);
            }
        }
        if (prop.getName().equals("wsAnnotation") && cx == null && (ann = this.getProperty("wsAnnotation")) != null) {
            this.set(ann, (BValue)BWsAnnotation.merge((BWsAnnotation)ACE.INIT_ANN, (BWsAnnotation)((BWsAnnotation)this.get(ann))));
        }
        super.added(prop, cx);
        if (!this.isRunning() || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        if (prop.getType().is(TYPE)) {
            cp = (BAceComponent)this.get(prop);
            this.addComponents(cp);
        }
        if (prop.getType().is(BAceLink.TYPE)) {
            BAceComponent.getAppComp(this).autoOrder();
            AceUtil.addLink(this, (BAceLink)this.get(prop), cx);
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.getType().is(TYPE)) {
            this.dev().clearComponentCache();
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (context == Context.decoding) {
            return;
        }
        LOG.fine("checkAdd(): name = " + name + ", value = " + value.toString() + ", context = " + (context == null ? "null" : context.toString()));
        if (!(value instanceof BAceComponent)) {
            return;
        }
        if (name.length() > 32) {
            throw new IllegalNameException("ace", "ace.exceedsNameLen", new Object[]{name});
        }
        if (this.getDepth() > 12) {
            throw new LocalizableRuntimeException("ace", "ace.exceedsPathDepth", new Object[]{12});
        }
        if (this.singletonCheck((BAceComponent)value)) {
            throw new LocalizableRuntimeException("ace", "ace.singletonViolation", new Object[]{((BAceComponent)value).getAceTypeName()});
        }
        if (!this.checkCatalog((BAceComponent)value, context)) {
            throw new LocalizableRuntimeException("ace", "ace.catalogMismatch");
        }
        int limit = LicenseUtil.getComponentLimit();
        if (!this.checkComponentNum((BAceComponent)value, limit, context)) {
            throw new LocalizableRuntimeException("ace", "ace.compCountIllegal", new Object[]{limit});
        }
    }

    private boolean checkComponentNum(BAceComponent comp, int limit, Context context) {
        if (Nre.getHostModel().equals("Workstation")) {
            return true;
        }
        if (context != null && context.equals(Context.copying)) {
            return true;
        }
        BAceApp app = BAceComponent.getAppComp(this);
        if (app == null) {
            return true;
        }
        BAceComponent[] cps = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)comp, BAceComponent.class);
        int addCnt = cps.length + 1;
        return app.getComponentCnt() + addCnt <= limit;
    }

    public static BAceApp getAppComp(BAceComponent comp) {
        if (comp instanceof BAceApp) {
            return (BAceApp)comp;
        }
        return (BAceApp)DrUtil.getParent((BComplex)comp, (Type)BAceApp.TYPE);
    }

    private boolean checkCatalog(BAceComponent comp, Context context) {
        if (context == null || context.equals(Context.copying)) {
            return true;
        }
        KitRegistry kr = this.getKitRegistry();
        if (kr == null) {
            LOG.info(lex.getText("ace.getCatalogFailed"));
            return false;
        }
        String kitName = comp.getAceKitName();
        if (kitName.length() < 1) {
            return true;
        }
        String typeName = comp.getAceTypeName();
        CatalogKit ck = kr.get(kitName);
        if (ck == null) {
            return false;
        }
        AceType at = ck.type(typeName);
        if (at == null) {
            return false;
        }
        return comp.isMatchingType(at.newInstance(true), this.getSpace());
    }

    private boolean isMatchingType(BAceComponent comp, BSpace space) {
        IntHashMap compMap = comp.getPropTable();
        IntHashMap map = this.getPropTable();
        if (compMap.size() != map.size()) {
            LOG.fine("the number of properties for " + comp.getAceTypeName() + " is different, " + compMap.size() + " vs " + map.size());
            if (space instanceof BAceSpace) {
                BAceAction[] actions = (BAceAction[])this.getChildren(BAceAction.class);
                if (actions.length != 0) {
                    return false;
                }
                BAceAction[] compActions = (BAceAction[])comp.getChildren(BAceAction.class);
                if (compActions.length + map.size() != compMap.size()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        IntHashMap.Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            Property prop = (Property)iterator.next();
            int pId = iterator.key();
            if (pId < 2) continue;
            Property compProp = (Property)compMap.get(pId);
            if (!prop.getName().equals(compProp.getName())) {
                return false;
            }
            if (!prop.getType().equals(compProp.getType())) {
                return false;
            }
            BFacets compFacets = compProp.getFacets();
            BFacets facets = prop.getFacets();
            if (facets.equals((Object)compFacets)) continue;
            return false;
        }
        return true;
    }

    protected KitRegistry getKitRegistry() {
        KitRegistry kr = null;
        if (this.getSpace() instanceof BAceSpace) {
            BAceAppFile file = ((BAceSpace)this.getSpace()).getAceAppFile();
            kr = (KitRegistry)file.getCatalog();
        } else {
            BAceNetwork net = this.ace();
            if (net != null) {
                kr = net.getNetworkKitRegistry();
            }
        }
        return kr;
    }

    private boolean singletonCheck(BAceComponent c) {
        Property p = c.getProperty("typeFacets");
        if (p == null) {
            return false;
        }
        if (((BFacets)this.get(p)).getb("singleton", false)) {
            BAceApp app;
            BAceApp bAceApp = app = this instanceof BAceApp ? (BAceApp)this : (BAceApp)DrUtil.getParent((BComplex)this, (Type)BAceApp.TYPE);
            if (app == null) {
                return false;
            }
            if (!Sys.isStation()) {
                app.lease(Integer.MAX_VALUE);
            }
            for (BAceComponent comp : (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)app, BAceComponent.class)) {
                if (comp.getHandle() == null || comp.getHandle().equals(c.getHandle()) || !comp.getAceTypeName().equals(c.getAceTypeName()) || !comp.getAceKitName().equals(c.getAceKitName())) continue;
                return true;
            }
        }
        return false;
    }

    private int getDepth() {
        int depth = 1;
        for (BAceComponent c = this; c != null && c instanceof BAceComponent && !(c instanceof BAceApp); c = c.getParent()) {
            ++depth;
        }
        return ++depth;
    }

    public void checkRename(Property prop, String newName, Context cx) {
        super.checkRename(prop, newName, cx);
        if (!prop.getType().is(TYPE)) {
            return;
        }
        if (newName.length() > 32) {
            throw new IllegalNameException("ace", "ace.exceedsNameLen", new Object[]{newName});
        }
    }

    public void renamed(Property prop, String oldName, Context cx) {
        super.renamed(prop, oldName, cx);
        if (!prop.getType().is(TYPE)) {
            return;
        }
        if (BNNetwork.noWrite.equals(cx)) {
            return;
        }
        String path = ((BAceComponent)this.get(prop)).getAcePath();
        AceUtil.renameComponent(this, prop, path, oldName, prop.getName(), cx);
    }

    public void checkRemove(Property p, Context cx) {
        super.checkRemove(p, cx);
        if (!this.isRunning() || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        if (p.getType().is(TYPE)) {
            AceUtil.removeComponent(this, (BAceComponent)this.get(p), cx);
        } else if (p.getType().is(BAceLink.TYPE)) {
            AceUtil.removeLink(this, (BAceLink)this.get(p), cx);
        }
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BAceComponent;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAceComponent;
    }

    public int getExecOrder() {
        return this.getExeParam().getExecOrder();
    }

    public void setExecOrder(int exeOrder, Context cx) {
        this.set(exeParam, (BValue)BExeParam.make(this.getLevel(), exeOrder), cx);
    }

    public int getLevel() {
        return this.getExeParam().getLevel();
    }

    public void setLevel(int level, Context cx) {
        this.set(exeParam, (BValue)BExeParam.make(level, this.getExecOrder()), cx);
    }

    public static int getLevel(int param) {
        return param >> 6 & 3;
    }

    public static int getExecOrder(int param) {
        return param & 0x3F;
    }

    public static int toExeParam(int lev, int order) {
        return order & 0x3F | (lev & 3) << 6;
    }

    public static int getMaxExecutionOrder() {
        return 63;
    }

    private void checkStatus() {
        if (!this.isRunning()) {
            return;
        }
        if (this.dev() == null) {
            this.status = BStatus.nullStatus;
            return;
        }
        this.status = this.dev().getStatus();
    }

    public final BLink makeLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        if (this.requiresAceLink(source, sourceSlot, targetSlot)) {
            if (source.getHandle() != null) {
                return new BAceLink(source.getHandleOrd(), sourceSlot.getName(), targetSlot.getName());
            }
            return new BAceLink(source, sourceSlot, targetSlot);
        }
        return super.makeLink(source, sourceSlot, targetSlot, cx);
    }

    public boolean requiresAceLink(BComponent source, Slot sourceSlot, Slot targetSlot) {
        return source instanceof BAceComponent && sourceSlot.getFacets().get("type") != null && targetSlot.getFacets().get("type") != null;
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        BAcePrimitiveTypeEnum srcTyp;
        boolean tgtIsAce;
        boolean srcIsAce = sourceSlot.getFacets().get("pId") != null;
        boolean bl = tgtIsAce = targetSlot.getFacets().get("pId") != null;
        if (!tgtIsAce && !srcIsAce) {
            return super.doCheckLink(source, sourceSlot, targetSlot, cx);
        }
        if (!tgtIsAce || !srcIsAce) {
            return LinkCheck.makeInvalid((String)"Ace slot must link to ace slot.");
        }
        if (sourceSlot.isAction()) {
            return LinkCheck.makeInvalid((String)"Can't link from ACE actions.");
        }
        if (targetSlot.isAction()) {
            return LinkCheck.makeInvalid((String)"Can't link to ACE actions.");
        }
        String tgtSlotOutput = targetSlot.getFacets().gets("output", "false");
        if (tgtSlotOutput.equals("true")) {
            return LinkCheck.makeInvalid((String)"Target can't be output.");
        }
        BAcePrimitiveTypeEnum tgtTyp = BAcePrimitiveTypeEnum.make(targetSlot.getFacets().gets("type", BAcePrimitiveTypeEnum.nullPrim.getTag()));
        if (!tgtTyp.equals((Object)(srcTyp = BAcePrimitiveTypeEnum.make(sourceSlot.getFacets().gets("type", BAcePrimitiveTypeEnum.nullPrim.getTag())))) && !this.isValidLinkTypes(tgtTyp, srcTyp)) {
            return LinkCheck.makeInvalid((String)("Can not link " + srcTyp.getTag() + " to " + tgtTyp.getTag()));
        }
        return LinkCheck.makeValid();
    }

    private boolean isValidLinkTypes(BAcePrimitiveTypeEnum tgtTyp, BAcePrimitiveTypeEnum srcTyp) {
        switch (tgtTyp.getOrdinal()) {
            case 2: {
                return srcTyp.isByte() || srcTyp.isBool();
            }
            case 3: {
                return srcTyp.isByte() || srcTyp.isShort() || srcTyp.isBool();
            }
            case 5: {
                return srcTyp.isInt() || srcTyp.isLong() || srcTyp.isBool();
            }
            case 1: 
            case 8: {
                return srcTyp.isBool() || srcTyp.isInt() || srcTyp.isLong() || srcTyp.isFloat();
            }
            case 4: 
            case 9: {
                return srcTyp.isInt() || srcTyp.isBool();
            }
            case 6: 
            case 10: {
                return srcTyp.isByte() || srcTyp.isShort() || srcTyp.isFloatOnly() || srcTyp.isBool();
            }
            case 7: 
            case 11: {
                return srcTyp.isInt() || srcTyp.isFloat() || srcTyp.isBool();
            }
            case 12: {
                return srcTyp.isByteArray();
            }
            case 13: {
                return srcTyp.isString();
            }
        }
        return false;
    }

    public void doForceRead() {
        if (!this.isRunning()) {
            throw new LocalizableRuntimeException("ace", "ace.notSupportedOffline");
        }
        this.implForceRead(255);
    }

    private void implForceRead(final int pId) {
        if (!this.dev().isOperational()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AceObjPropValue[] opvs;
                    BAceComponent.this.initPropIdTable();
                    for (AceObjPropValue opv : opvs = AceUtil.readProps(BAceComponent.this.ace().ncomm(), BAceComponent.this.dev().getAddress(), BAceComponent.this.getObjectId(), pId)) {
                        Property p = (Property)BAceComponent.this.propTab.get(opv.propertyId);
                        if (p == null) continue;
                        BAceComponent.this.setProp(p, opv.primVal, BNNetwork.noWrite);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Read failed:" + BAceComponent.this.getObjectId() + ":" + pId, e);
                }
            }
        };
        this.ace().postAsync(r);
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("wiresheet:WireSheet");
        agents.remove("wbutil:CategorySheet");
        agents.remove("tagdictionary:TagManager");
        return agents;
    }

    public boolean invokeAction(int pid, BAcePrimitive v, boolean expectResp) {
        if (!this.isRunning()) {
            return true;
        }
        return AceUtil.invokeAction(this.ace().ncomm(), this.dev().getAddress(), this.getObjectId(), pid, v, expectResp);
    }

    public void updateValue(int propertyId, BAcePrimitive v) {
        Property p = this.getPropertyForPropId(propertyId);
        if (p == null) {
            return;
        }
        this.setProp(p, v, BNNetwork.noWrite);
    }

    public Property getPropertyForPropId(int propertyId) {
        this.initPropIdTable();
        return (Property)this.propTab.get(propertyId);
    }

    public void setReadonly(int propId, boolean readonly) {
        Property p = this.getPropertyForPropId(propId);
        if (p == null) {
            return;
        }
        if (readonly) {
            this.setFlags((Slot)p, this.getFlags((Slot)p) | 1, Context.decoding);
        } else {
            this.setFlags((Slot)p, this.getFlags((Slot)p) & 0xFFFFFFFE, Context.decoding);
        }
    }

    protected void setProp(Property p, BAcePrimitive v, Context cx) {
        BString typTag = (BString)p.getFacets().get("type");
        if (typTag == null) {
            return;
        }
        BAcePrimitiveTypeEnum typ = BAcePrimitiveTypeEnum.fromJsonName(typTag.toString());
        BValue curVal = this.get(p);
        boolean stVal = curVal instanceof BStatusValue;
        if (stVal) {
            ((BStatusValue)curVal).set(BStatusValue.status, (BValue)v.getStatus(), cx);
        }
        try {
            switch (typ.getOrdinal()) {
                case 1: 
                case 8: {
                    if (stVal) {
                        ((BStatusBoolean)curVal).setBoolean(BStatusBoolean.value, v.getBoolean(), cx);
                        break;
                    }
                    this.setBoolean(p, v.getBoolean(), cx);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    int ival = v.getInt();
                    if (curVal instanceof BIEnum) {
                        BEnumRange range = ((BIEnum)curVal).getEnum().getRange();
                        BDynamicEnum de = BDynamicEnum.make((int)ival, (BEnumRange)range);
                        if (stVal) {
                            ((BStatusEnum)curVal).setValue(de);
                            break;
                        }
                        this.set(p, (BValue)de);
                        break;
                    }
                    if (curVal instanceof BIAceInteger) {
                        this.set(p, (BValue)((BIAceInteger)curVal).make(ival), cx);
                        break;
                    }
                    if (stVal) {
                        ((BStatusNumeric)curVal).setDouble(BStatusNumeric.value, (double)ival, cx);
                        break;
                    }
                    this.setInt(p, ival, cx);
                    break;
                }
                case 5: {
                    if (stVal) {
                        ((BStatusNumeric)curVal).setDouble(BStatusNumeric.value, (double)v.getLong(), cx);
                        break;
                    }
                    this.setLong(p, v.getLong(), cx);
                    break;
                }
                case 6: 
                case 10: {
                    if (stVal) {
                        ((BStatusNumeric)curVal).setDouble(BStatusNumeric.value, (double)v.getFloat(), cx);
                        break;
                    }
                    this.setFloat(p, v.getFloat(), cx);
                    break;
                }
                case 7: 
                case 11: {
                    if (stVal) {
                        ((BStatusNumeric)curVal).setDouble(BStatusNumeric.value, v.getDouble(), cx);
                        break;
                    }
                    this.setDouble(p, v.getDouble(), cx);
                    break;
                }
                case 13: {
                    if (curVal instanceof BEnumRange) {
                        this.set(p, (BValue)this.getRange(p, v), cx);
                        break;
                    }
                    if (stVal) {
                        ((BStatusString)curVal).setString(BStatusString.value, v.getString(), cx);
                        break;
                    }
                    this.setString(p, v.getString(), cx);
                    break;
                }
                case 12: {
                    if (p.getFacets().gets("string", "").equals("true")) {
                        if (stVal) {
                            ((BStatusString)curVal).setString(BStatusString.value, v.getString(), cx);
                            break;
                        }
                        this.setString(p, v.getString(), cx);
                        break;
                    }
                    this.set(p, (BValue)BBlob.make((byte[])v.getByteArray()), cx);
                    break;
                }
                default: {
                    LOG.warning(lex.getText("ace.slotTypeError", new Object[]{typ}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BEnumRange getRange(Property p, BAcePrimitive v) throws Exception {
        BEnumRange er = BEnumRange.DEFAULT;
        try {
            String rng = v.getString();
            if (rng.length() > 0) {
                er = (BEnumRange)er.decodeFromString(rng);
            }
        }
        catch (Exception e) {
            LOG.warning("Invalid enumRange \"" + v.getString() + "\" for " + this.getDisplayName(null) + ":" + p.getName());
        }
        return er;
    }

    public BAcePrimitive getPrimitive(Property p) {
        BString typTag = (BString)p.getFacets().get("type");
        if (typTag == null) {
            return null;
        }
        BAcePrimitiveTypeEnum typ = BAcePrimitiveTypeEnum.fromJsonName(typTag.toString());
        BValue curVal = this.get(p);
        return BAcePrimitive.make(typ, curVal);
    }

    public void subscribed() {
        if (!Sys.isStation()) {
            return;
        }
        this.checkCovRegistration();
    }

    public void unsubscribed() {
        if (!Sys.isStation()) {
            return;
        }
        this.checkCovRegistration();
    }

    public void doViewChanged() {
        if (!this.isRunning()) {
            return;
        }
        this.checkCovRegistration();
        for (BAceComponent child : (BAceComponent[])this.getChildren(BAceComponent.class)) {
            child.checkCovRegistration();
        }
    }

    private void checkCovRegistration() {
        if (!Sys.getStation().isRunning()) {
            return;
        }
        this.dev().covReg().add(this);
    }

    public boolean verifyRegistration(boolean reg) {
        if (reg == this.covRegistered) {
            return true;
        }
        this.covRegistered = reg;
        return false;
    }

    public void reassertCov() {
        this.covRegistered = false;
        this.checkCovRegistration();
    }

    protected void initPropIdTable() {
        Property[] props;
        if (this.propTabInited) {
            return;
        }
        for (Property p : props = this.getPropertiesArray()) {
            int pId = p.getFacets().geti("pId", -1);
            if (pId < 0) continue;
            this.propTab.put(pId, (Object)p);
        }
        this.propTabInited = true;
    }

    IntHashMap getPropTable() {
        this.initPropIdTable();
        return this.propTab;
    }

    public String getAceComponentName() {
        return this.getName();
    }

    public String getAceFullPathName() {
        return this.getAcePath() + this.getName();
    }

    public String getAcePath() {
        StringBuilder sb = new StringBuilder();
        for (BComplex p = this.getParent(); p != null && p instanceof BAceComponent && !(p instanceof BAceApp); p = p.getParent()) {
            sb.insert(0, "/");
            sb.insert(0, p.getName());
        }
        return sb.toString();
    }

    public void forEachAceComponent(Consumer<? super BAceComponent> action) {
        action.accept(this);
        for (BAceComponent component : (BAceComponent[])this.getChildren(BAceComponent.class)) {
            component.forEachAceComponent(action);
        }
    }

    public IntHashMap getEnumRangeProps() {
        IntHashMap.Iterator iterator = this.getPropTable().iterator();
        while (iterator.hasNext()) {
            BString enumRangeSlots;
            Property p = (Property)iterator.next();
            int pId = iterator.key();
            if (pId < 2 || (enumRangeSlots = (BString)p.getFacets().get(BAceSlotTypeEnum.enumRange.getTag())) == null || enumRangeSlots.getString().length() < 1) continue;
            try {
                String[] props;
                BEnumRange er = (BEnumRange)this.get(p.getName());
                IntHashMap erProps = new IntHashMap();
                for (String pname : props = enumRangeSlots.getString().split(",")) {
                    Property eprop = this.getProperty(pname);
                    if (eprop == null) continue;
                    int enumSlotId = eprop.getFacets().geti("pId", -1);
                    erProps.put(enumSlotId, (Object)er);
                }
                return erProps;
            }
            catch (Exception e) {
                LOG.warning("Exception caught in getEnumRangeProps " + (e.getMessage() != null ? e.getMessage() : ""));
            }
        }
        return null;
    }

    public Object getCoalesceKey() {
        if (this.key < 0) {
            this.key = this.getObjectId();
        }
        return new Integer(2088960 + this.key);
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("BAceComponent");
        out.prop((Object)"cov registered", this.covRegistered);
        out.endProps();
    }
}

