/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceDeviceFolder;
import com.tridium.ace.app.App;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAceDownloadParams;
import com.tridium.ace.datatypes.BAceReadFileParams;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.json.JComponent;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.program.BAceAppDownloadJob;
import com.tridium.ace.program.BAceReadFileJob;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.util.LicenseUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.util.CompUtil;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="commConfig", type="BCommConfig", defaultValue="new BCommConfig()")})
@NiagaraActions(value={@NiagaraAction(name="downloadApp", parameterType="BAceDownloadParams", defaultValue="new BAceDownloadParams()", returnType="baja:Ord", flags=4), @NiagaraAction(name="uploadApp", parameterType="BAceReadFileParams", defaultValue="new BAceReadFileParams()", returnType="baja:Ord", flags=4)})
public abstract class BAceNetwork
extends BNNetwork {
    public static final Property pollScheduler = BAceNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property commConfig = BAceNetwork.newProperty((int)0, (BValue)new BCommConfig(), null);
    public static final Action downloadApp = BAceNetwork.newAction((int)4, (BValue)new BAceDownloadParams(), null);
    public static final Action uploadApp = BAceNetwork.newAction((int)4, (BValue)new BAceReadFileParams(), null);
    public static final Type TYPE = Sys.loadType(BAceNetwork.class);
    public static final String NETWORK_NAME = "AceNetwork";
    public static Logger COV_LOG = Logger.getLogger("AceCov");
    public static Logger RD_WR_LOG = Logger.getLogger("AceRdWr");
    public static Lexicon LEX = Lexicon.make(BAceNetwork.class);

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BCommConfig getCommConfig() {
        return (BCommConfig)this.get(commConfig);
    }

    public void setCommConfig(BCommConfig v) {
        this.set(commConfig, (BValue)v, null);
    }

    public BOrd downloadApp(BAceDownloadParams parameter) {
        return (BOrd)this.invoke(downloadApp, (BValue)parameter, null);
    }

    public BOrd uploadApp(BAceReadFileParams parameter) {
        return (BOrd)this.invoke(uploadApp, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return NETWORK_NAME;
    }

    public Type getDeviceFolderType() {
        return BAceDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BAceDevice.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "ace");
    }

    public final void started() throws Exception {
        super.started();
        if (this.isFatalFault()) {
            return;
        }
        this.aceNetworkStarted();
    }

    public final void stationStarted() throws Exception {
        this.postAsync(new Runnable(){

            @Override
            public void run() {
                BAceNetwork.this.checkAceComponentCount();
            }
        });
    }

    public final void checkAceComponentCount() {
        BAceDevice[] devs;
        for (BAceDevice dev : devs = (BAceDevice[])CompUtil.getDescendants((BComponent)this, BAceDevice.class)) {
            byte[] appEmb = dev.implReadFile("app.ace");
            if (appEmb == null) continue;
            int compCnt = 0;
            try {
                JAppReader aceAppReader = new JAppReader(true);
                Catalog catalog = aceAppReader.decodeCatalog(new ByteArrayInputStream(appEmb));
                App app = aceAppReader.decode(new ByteArrayInputStream(appEmb), catalog);
                HashMap<Integer, BAceComponent> aceComponents = new HashMap<Integer, BAceComponent>();
                BAceApp aceApp = aceAppReader.buildComponentTree(app, aceComponents, catalog);
                compCnt = aceApp.getComponentCnt();
            }
            catch (Exception e) {
                this.log().info(LEX.getText("ace.invalidappbinfile"));
                return;
            }
            int limit = LicenseUtil.getComponentLimit();
            if (compCnt <= limit) continue;
            this.configFatal(LEX.getText("ace.compCountIllegal", new Object[]{limit}));
            return;
        }
    }

    public void aceNetworkStarted() throws Exception {
    }

    protected boolean useAutoManager() {
        return false;
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NDeviceManager");
        return list;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (!this.checkAceAppSame()) {
            // empty if block
        }
    }

    public BOrd doDownloadApp(BAceDownloadParams params) {
        return new BAceAppDownloadJob(this, params).submit(null);
    }

    public BOrd doUploadApp(BAceReadFileParams params) {
        return new BAceReadFileJob(this, params).submit(null);
    }

    public abstract KitRegistry getNetworkKitRegistry();

    public boolean checkAceAppSame() {
        try {
            KitRegistry kr = this.getNetworkKitRegistry();
            CatalogKit ct = kr.get("core.sys");
            JComponent jc = (JComponent)ct.type("App");
            List<AceSlot> slots = jc.getSlots();
            BAceApp app = new BAceApp();
            int slotId = 0;
            int pId = 0;
            for (AceSlot slot : slots) {
                boolean isAction = slot.getFacets().toFacets().getb("action", false);
                if (isAction) continue;
                String propName = slot.getName();
                Property prop = app.getProperty(propName);
                slotId = slot.getSlotId();
                if (prop == null) {
                    this.log().severe("BAceApp missing property:" + propName);
                    return false;
                }
                pId = prop.getFacets().geti("pId", -1);
                if (slotId == pId) continue;
                this.log().severe("BAceApp missing property:" + propName + ":" + slotId);
                return false;
            }
            return this.checkAppActionsSame(jc);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkAppActionsSame(JComponent jc) {
        String[] actions = new String[]{"save", "quit", "restart", "reboot", "pause", "resume", "scanOnce"};
        int[] appSlotId = new int[]{29, 30, 31, 32, 33, 34, 35};
        for (int i = 0; i < actions.length; ++i) {
            Integer slotIdx = jc.getSlotIndex(actions[i]);
            if (slotIdx == null) {
                this.log().severe("App missing action:" + actions[i]);
                return false;
            }
            if (slotIdx == appSlotId[i]) continue;
            this.log().severe("App action mismatch:" + actions[i] + " catalog id=" + slotIdx + " App id=" + appSlotId[i]);
            return false;
        }
        return true;
    }

    public NComm ncomm() {
        return (NComm)this.getCommConfig().comm();
    }

    public BAceDevice getDevice(BAddress adr) {
        return null;
    }
}

