/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.ui;

import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.ui.NMgrLearn;
import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointController;
import com.tridium.ndriver.ui.point.NPointModel;
import com.tridium.opcUaServer.export.BBooleanExport;
import com.tridium.opcUaServer.export.BEnumExport;
import com.tridium.opcUaServer.export.BNumericExport;
import com.tridium.opcUaServer.export.BStringExport;
import com.tridium.opcUaServer.point.BOpcUaServerLearnPointEntry;
import com.tridium.opcUaServer.point.BOpcUaServerPointFolder;
import com.tridium.opcUaServer.point.BOpcUaServerProxyExt;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaServer:OpcUaServerPointDeviceExt", "opcUaServer:OpcUaServerPointFolder"})})
public class BOpcUaServerPointManager
extends BNPointManager {
    public static final Type TYPE = Sys.loadType(BOpcUaServerPointManager.class);
    static Lexicon lex = Lexicon.make(BOpcUaServerPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colNodeId = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.uaNodeId}, 4);
    MgrColumn colLocalPoint = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.localPoint}, 1);
    MgrColumn colPointSlot = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.localPointSlot}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colToString, this.colNodeId, this.colLocalPoint, this.colPointSlot, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};
    Type proxyExtType = BOpcUaServerProxyExt.TYPE;
    private static final OpcUaMgrTypeInfo numericType = new OpcUaMgrTypeInfo(BNumericExport.TYPE, BNumericPoint.TYPE);
    private static final OpcUaMgrTypeInfo booleanType = new OpcUaMgrTypeInfo(BBooleanExport.TYPE, BBooleanPoint.TYPE);
    private static final OpcUaMgrTypeInfo enumType = new OpcUaMgrTypeInfo(BEnumExport.TYPE, BEnumPoint.TYPE);
    private static final OpcUaMgrTypeInfo stringType = new OpcUaMgrTypeInfo(BStringExport.TYPE, BStringPoint.TYPE);
    private static final Logger logger = Logger.getLogger("opcUaServer");

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn((BAbstractManager)this);
    }

    static class OpcUaMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo exportType;
        private TypeInfo importType;

        OpcUaMgrTypeInfo(Type exportType, Type importType) {
            this.exportType = exportType.getTypeInfo();
            this.importType = importType.getTypeInfo();
        }

        public TypeInfo getExportType() {
            return this.exportType;
        }

        public TypeInfo getImportType() {
            return this.importType;
        }

        public BImage getIcon() {
            return null;
        }

        public String getDisplayName() {
            return this.exportType.getDisplayName(null);
        }

        public BComponent newInstance() {
            return this.newInstance(true);
        }

        public BComponent newInstance(boolean isExport) {
            BControlPoint pnt = (BControlPoint)(isExport ? this.exportType.getInstance() : this.importType.getInstance());
            BOpcUaServerProxyExt ext = new BOpcUaServerProxyExt();
            pnt.setProxyExt((BAbstractProxyExt)ext);
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class Learn
    extends NMgrLearn {
        private BNDiscoveryJob discoveryJob;

        public Learn(BAbstractManager manager) {
            super(manager);
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BOpcUaServerLearnPointEntry disc = (BOpcUaServerLearnPointEntry)discovery;
            BControlPoint instance = (BControlPoint)disc.getPointType().getInstance();
            BStatusValue statusValue = instance.getOutStatusValue();
            if (statusValue instanceof BStatusBoolean) {
                return new OpcUaMgrTypeInfo[]{booleanType};
            }
            if (statusValue instanceof BStatusNumeric) {
                return new OpcUaMgrTypeInfo[]{numericType};
            }
            if (statusValue instanceof BStatusEnum) {
                return new OpcUaMgrTypeInfo[]{enumType};
            }
            if (statusValue instanceof BStatusString) {
                return new OpcUaMgrTypeInfo[]{stringType};
            }
            return new OpcUaMgrTypeInfo[0];
        }

        public boolean hasChildren(Object discovery) {
            return this.getChildren(discovery).length > 0;
        }

        public Object[] getChildren(Object discovery) {
            ArrayList<BOpcUaServerLearnPointEntry> list = new ArrayList<BOpcUaServerLearnPointEntry>();
            BOpcUaServerLearnPointEntry[] children = (BOpcUaServerLearnPointEntry[])((BComponent)discovery).getChildren(BOpcUaServerLearnPointEntry.class);
            if (children == null) {
                return new Object[0];
            }
            for (BOpcUaServerLearnPointEntry child : children) {
                list.add(child);
            }
            return list.toArray();
        }

        public void load(BComponent target) {
            if (target instanceof BOpcUaServerPointFolder) {
                BNDiscoveryJob job = (BNDiscoveryJob)this.getJob();
                if (job != null) {
                    this.updateRoots(job.getRootDiscoveryObjects());
                } else {
                    BValue lj = ((BOpcUaServerPointFolder)target).getDevice().get("lj");
                    if (lj != null && lj instanceof BNDiscoveryJob) {
                        ((BNDiscoveryJob)lj).lease();
                        this.updateRoots(((BNDiscoveryJob)lj).getRootDiscoveryObjects());
                    }
                }
            }
        }

        public void jobComplete(BJob job) {
            if (job instanceof BNDiscoveryJob) {
                this.discoveryJob = (BNDiscoveryJob)job;
                this.updateRoots(this.discoveryJob.getRootDiscoveryObjects());
                BComponent target = this.getManager().getTarget();
                if (target instanceof BIPointFolder) {
                    BDevice device = ((BIPointFolder)target).getDevice();
                    BValue lj = device.get("lj");
                    if (lj != null) {
                        device.remove(lj.asComplex());
                    }
                    device.add("lj", this.discoveryJob.newCopy(), 6);
                }
            }
        }
    }

    class OpcMgrEditRow
    extends MgrEditRow {
        public OpcMgrEditRow(BComponent target, Object discovery, MgrTypeInfo[] types) {
            super(target, discovery, types);
        }

        public BComponent getTarget(boolean isExport) {
            BControlPoint target = (BControlPoint)super.getTarget();
            try {
                BOpcUaServerProxyExt proxyExt = (BOpcUaServerProxyExt)target.getProxyExt().newCopy();
                Object discovery = this.getDiscovery();
                BOpcUaServerLearnPointEntry disc = (BOpcUaServerLearnPointEntry)discovery;
                OpcUaMgrTypeInfo mgrTypeInfo = (OpcUaMgrTypeInfo)this.getAvailableTypes()[0];
                BControlPoint point = (BControlPoint)mgrTypeInfo.newInstance(isExport);
                point.setProxyExt((BAbstractProxyExt)proxyExt);
                return point;
            }
            catch (Exception e) {
                logger.severe("Error while getting targert :" + e.getMessage() + " : " + e.getLocalizedMessage());
                return target;
            }
        }
    }

    class OpcMgrEdit
    extends MgrEdit {
        public OpcMgrEdit(BAbstractManager manager, String title) {
            super(manager, title);
        }

        protected MgrEditRow makeRow(BComponent target, Object discovery, MgrTypeInfo[] types) throws Exception {
            return new OpcMgrEditRow(target, discovery, types);
        }
    }

    class Controller
    extends NPointController {
        Controller(BNPointManager mgr) {
            super(mgr);
        }

        public MgrEdit makeEdit(String label) {
            return new OpcMgrEdit(this.getManager(), label);
        }

        public void updateCommands() {
            super.updateCommands();
            MgrLearn learn = BOpcUaServerPointManager.this.getLearn();
            BLearnTable table = learn.getTable();
            if (table == null) {
                return;
            }
            Object[] selectedObjects = table.getSelectedObjects();
            if (selectedObjects.length == 0) {
                return;
            }
            boolean enable = true;
            this.add.setEnabled(selectedObjects.length > 0 && enable);
        }
    }

    class Model
    extends NPointModel {
        Model(BNPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOpcUaServerPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BAbstractProxyExt ext = (BAbstractProxyExt)BOpcUaServerPointManager.this.proxyExtType.getInstance();
            pt.setProxyExt(ext);
            return pt;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                BValue pointSlot = rows[i].getCell(2);
                boolean isExport = pointSlot.toString().equals("out");
                names[i] = rows[i].getName();
                values[i] = ((OpcMgrEditRow)rows[i]).getTarget(isExport);
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            return null;
        }
    }
}

