/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrioConversion.ui.tool;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioBoardFolder;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.conv.BShunt500OhmConversion;
import com.tridium.ndio.conv.BTabularThermistorConversion;
import com.tridium.ndio.conv.BThermistorType3Conversion;
import com.tridium.ndio.point.BNdioBooleanInputProxyExt;
import com.tridium.ndio.point.BNdioBooleanOutputProxyExt;
import com.tridium.ndio.point.BNdioCounterInputProxyExt;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.ndio.point.BNdioPointFolder;
import com.tridium.ndio.point.BNdioProxyExt;
import com.tridium.ndio.point.BNdioResistiveInputProxyExt;
import com.tridium.ndio.point.BNdioUniversalInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageOutputProxyExt;
import com.tridium.ndio.type.BSlidingWindowRateType;
import com.tridium.ndio.type.BTriggerRateType;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.conv.BNrioShunt500OhmConversion;
import com.tridium.nrio.conv.BNrioTabularThermistorConversion;
import com.tridium.nrio.conv.BNrioThermistorType3Conversion;
import com.tridium.nrio.enums.BNrio16CounterSelectEnum;
import com.tridium.nrio.ext.BLinearCalibrationExt;
import com.tridium.nrio.points.BNrio16PointFolder;
import com.tridium.nrio.points.BNrio16Points;
import com.tridium.nrio.points.BNrio34PriSecPoints;
import com.tridium.nrio.points.BNrioBooleanInputProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.nrio.types.BAbstractRateType;
import com.tridium.nrio.types.BFixedWindowRateType;
import com.tridium.nrioConversion.ui.tool.BNdioToNrioConverter;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.BOptionDialog;
import com.tridium.util.ComponentTreeCursor;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.auth.BStationCnxType;
import java.util.HashMap;
import java.util.Map;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.commands.WordWrap;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BNdioToNrioConverterDialog
extends BOptionDialog {
    public static final Type TYPE = Sys.loadType(BNdioToNrioConverterDialog.class);
    private static final Lexicon lex = Lexicon.make(BNdioToNrioConverter.class);
    private static final int resultsRows = 15;
    private static final int resultsColumns = 60;
    private BCnxConfigPane hostPane;
    private BCheckBox rename;
    private final BTextEditorPane resultsPane = new BTextEditorPane(BNdioToNrioConverterDialog.getLexWrapped("NdioToNrioConverter.openingMessage", 60), 15, 60, false);
    boolean foundNetwork = false;
    private static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});

    public Type getType() {
        return TYPE;
    }

    public BNdioToNrioConverterDialog(BWidget parent) throws Exception {
        super(parent, lex.getText("NdioToNrioConverter.displayName"), (BWidget)new BEdgePane(), 3, null, null);
        this.addContent();
    }

    private void addContent() {
        BEdgePane content = (BEdgePane)this.getContent();
        BCnxHandler[] handlers = BCnxHandler.getHandlersOnType((TypeInfo)BStationCnxType.TYPE.getTypeInfo(), null);
        this.hostPane = new BCnxConfigPane(handlers);
        this.rename = new BCheckBox(lex.getText("NdioToNrioConverter.rename"), false);
        content.setTop((BWidget)this.hostPane);
        content.setCenter((BWidget)this.resultsPane);
        content.setBottom((BWidget)this.rename);
        this.getOkButton().setText(lex.getText("NdioToNrioConverter.run"));
        this.getCancelButton().setText(lex.getText("NdioToNrioConverter.close"));
    }

    public static void show(BWidget parent) throws Exception {
        BNdioToNrioConverterDialog dialog = new BNdioToNrioConverterDialog(parent);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
    }

    public void doButtonPressed(BWidgetEvent event) {
        BWidget src = event.getWidget();
        if (src == this.getOkButton()) {
            new Thread(new WorkerRunnable()).start();
        }
        if (src == this.getCancelButton()) {
            this.close(2);
        }
        if (src == this.getYesButton()) {
            this.close(4);
        }
        if (src == this.getNoButton()) {
            this.close(8);
        }
        if (src == this.getDetailsButton()) {
            this.toggleDetails();
        }
    }

    /*
     * Exception decompiling
     */
    public void convert() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getLexWrapped(String key, int columns) {
        String string = lex.getText(key);
        return WordWrap.wrap((String)string, (int)columns);
    }

    public void process(BComponent c) throws Exception {
        c.lease();
        if (c instanceof BNdioNetwork) {
            c.lease(Integer.MAX_VALUE);
            Map<BComponent, Map<String, BRelation>> relationMap = BNdioToNrioConverterDialog.makeRelationMap(c);
            BComponent parent = (BComponent)c.getParent();
            String name = c.getName();
            BNdioToNrioConverterDialog.ndioToNrio(c, parent);
            if (this.rename.getSelected()) {
                BNdioToNrioConverterDialog.renameToNrio((BComponent)parent.get(name));
            }
            this.foundNetwork = true;
            BNdioToNrioConverterDialog.restoreRelations(relationMap);
        } else {
            BComponent[] kids;
            for (BComponent kid : kids = c.getChildComponents()) {
                this.process(kid);
            }
        }
    }

    private static Map<BComponent, Map<String, BRelation>> makeRelationMap(BComponent root) {
        HashMap<BComponent, Map<String, BRelation>> relationMap = new HashMap<BComponent, Map<String, BRelation>>();
        ComponentTreeCursor cursor = new ComponentTreeCursor(root, null);
        while (cursor.next()) {
            RelationKnob[] relationKnobs;
            Knob[] knobs;
            BValue value = cursor.get();
            if (!(value instanceof BComponent)) continue;
            BComponent component = (BComponent)value;
            for (Knob knob : knobs = component.getKnobs()) {
                BComponent target = (BComponent)knob.getTargetOrd().get((BObject)root);
                for (BLink link : target.getLinks()) {
                    if (link.getSourceOrd().get((BObject)root) != component) continue;
                    Map compMap = relationMap.computeIfAbsent(target, key -> new HashMap());
                    compMap.put(link.getName(), link);
                }
            }
            for (RelationKnob knob : relationKnobs = component.getRelationKnobs()) {
                BComponent target = (BComponent)knob.getRelationOrd().get((BObject)root);
                for (BRelation relation : target.getComponentRelations()) {
                    if (relation.getSourceOrd().get((BObject)root) != component) continue;
                    Map compMap = relationMap.computeIfAbsent(target, key -> new HashMap());
                    compMap.put(relation.getName(), relation);
                }
            }
        }
        return relationMap;
    }

    private static void restoreRelations(Map<BComponent, Map<String, BRelation>> relationMap) {
        for (Map.Entry<BComponent, Map<String, BRelation>> entry : relationMap.entrySet()) {
            BComponent component = entry.getKey();
            component.lease();
            for (Map.Entry<String, BRelation> relationEntry : entry.getValue().entrySet()) {
                if (component.getSlot(relationEntry.getKey()) != null) continue;
                component.add(relationEntry.getKey(), (BValue)relationEntry.getValue());
            }
        }
    }

    public static void renameToNrio(BComponent nrio) {
        ComponentTreeCursor cursor = new ComponentTreeCursor(nrio, null);
        while (cursor.next()) {
            String format;
            BValue value = cursor.get();
            if (!(value instanceof BNrioNetwork) && !(value instanceof BNrioDevice)) continue;
            BComponent comp = (BComponent)value;
            BComponent parent = (BComponent)comp.getParent();
            BFormat displayFormat = comp.getDisplayNameFormat(comp.getPropertyInParent());
            if (displayFormat != null) {
                format = displayFormat.getFormat();
                format = BNdioToNrioConverterDialog.ndioToNrioName(format);
            } else {
                format = comp.getDisplayName(null);
                format = BNdioToNrioConverterDialog.ndioToNrioName(format);
            }
            parent.lease();
            parent.setDisplayName(comp.getPropertyInParent(), BFormat.make((String)format), null);
        }
    }

    public static void ndioToNrio(BComponent ndio, BComponent nrioParent) {
        Property[] props;
        ndio.lease(1);
        Object nrio = ndio instanceof BNdioNetwork ? BNdioToNrioConverterDialog.ndioToNrioNetwork((BNdioNetwork)ndio) : (ndio instanceof BNdioBoardFolder ? BNdioToNrioConverterDialog.ndioToNrioBoardFolder((BNdioBoardFolder)ndio) : (ndio instanceof BNdioBoard ? BNdioToNrioConverterDialog.ndioToNrioBoard((BNdioBoard)ndio) : (ndio instanceof BNdioPointDeviceExt ? BNdioToNrioConverterDialog.ndioToNrioPoints((BNdioPointDeviceExt)ndio, nrioParent) : (ndio instanceof BNdioPointFolder ? BNdioToNrioConverterDialog.ndioToNrioPointFolder((BNdioPointFolder)ndio) : (ndio instanceof BControlPoint ? BNdioToNrioConverterDialog.ndioToNrioPoint((BControlPoint)ndio) : (BComponent)ndio.newCopy(true))))));
        String name = ndio.getName();
        if (ndio.getPropertyInParent().isFrozen() && (nrio = (BComponent)nrioParent.get(name)) == null) {
            return;
        }
        ComponentSlotMap map = (ComponentSlotMap)nrio.fw(1);
        map.setHandle(ndio.getHandle());
        for (Property prop : props = ndio.getPropertiesArray()) {
            BValue val = ndio.get(prop);
            if (val instanceof BComponent) {
                BNdioToNrioConverterDialog.ndioToNrio((BComponent)val, (BComponent)nrio);
                continue;
            }
            if (!prop.isDynamic()) continue;
            if (nrio.getProperty(prop.getName()) != null) {
                nrio.set(prop.getName(), val.newCopy(true));
                continue;
            }
            nrio.add(prop.getName(), val.newCopy(true));
        }
        if (!ndio.getPropertyInParent().isFrozen()) {
            if (nrioParent.getProperty(name) != null) {
                nrioParent.remove(name);
            }
            nrioParent.add(name, (BValue)nrio);
        }
    }

    public static BNrioNetwork ndioToNrioNetwork(BNdioNetwork ndio) {
        BNrioNetwork nrio = new BNrioNetwork();
        nrio.setEnabled(ndio.getEnabled());
        nrio.setAlarmSourceInfo((BAlarmSourceInfo)ndio.getAlarmSourceInfo().newCopy(true));
        nrio.setTuningPolicies((BTuningPolicyMap)ndio.getTuningPolicies().newCopy(true));
        BPingMonitor ndioMonitor = ndio.getMonitor();
        BPingMonitor nrioMonitor = nrio.getMonitor();
        nrioMonitor.setPingEnabled(ndioMonitor.getPingEnabled());
        nrioMonitor.setAlarmOnFailure(ndioMonitor.getAlarmOnFailure());
        nrio.getPollScheduler().setPollEnabled(ndio.getPollScheduler().getPollEnabled());
        return nrio;
    }

    public static BNrioDeviceFolder ndioToNrioBoardFolder(BNdioBoardFolder ndio) {
        return new BNrioDeviceFolder();
    }

    public static BNrioDevice ndioToNrioBoard(BNdioBoard ndio) {
        boolean nrio34 = false;
        ndio.lease(Integer.MAX_VALUE);
        ComponentTreeCursor cursor = new ComponentTreeCursor((BComponent)ndio, null);
        while (cursor.next() && !nrio34) {
            int maxIndex;
            BValue val = cursor.get();
            if (!(val instanceof BNdioProxyExt)) continue;
            int n = maxIndex = val instanceof BNdioUniversalInputProxyExt ? 8 : 4;
            int index = ((BNdioProxyExt)val).getAddress();
            if (index <= maxIndex) continue;
            nrio34 = true;
        }
        Object nrio = nrio34 ? new BNrio34Module() : new BNrio16Module();
        nrio.setEnabled(ndio.getEnabled());
        nrio.setAlarmSourceInfo((BAlarmSourceInfo)ndio.getAlarmSourceInfo().newCopy(true));
        return nrio;
    }

    public static BNrio16Points ndioToNrioPoints(BNdioPointDeviceExt ndio, BComponent nrioParent) {
        if (nrioParent instanceof BNrio34Module) {
            return new BNrio34PriSecPoints();
        }
        return new BNrio16Points();
    }

    public static BNrio16PointFolder ndioToNrioPointFolder(BNdioPointFolder ndio) {
        return new BNrio16PointFolder();
    }

    public static BControlPoint ndioToNrioPoint(BControlPoint ndio) {
        BControlPoint nrio = (BControlPoint)ndio.newCopy(true);
        BPointExtension[] extensions = ndio.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            BPointExtension pointExtension = extensions[i];
            if (pointExtension instanceof com.tridium.ndio.ext.BLinearCalibrationExt) {
                com.tridium.ndio.ext.BLinearCalibrationExt ndioCalibration = (com.tridium.ndio.ext.BLinearCalibrationExt)pointExtension;
                BLinearCalibrationExt nrioCalibration = new BLinearCalibrationExt();
                nrioCalibration.setUnits(ndioCalibration.getUnits());
                nrioCalibration.setOffset(ndioCalibration.getOffset());
                nrioCalibration.setScale(ndioCalibration.getScale());
                nrio.set(ndioCalibration.getName(), (BValue)nrioCalibration);
                continue;
            }
            if (!(pointExtension instanceof BNdioProxyExt)) continue;
            BNrioBooleanInputProxyExt nrioProxyExt = null;
            BNdioProxyExt ndioProxyExt = (BNdioProxyExt)pointExtension;
            boolean enabled = ndioProxyExt.getEnabled();
            int instance = ndioProxyExt.getAddress();
            String tuningPolicyName = ndioProxyExt.getTuningPolicyName();
            BFacets deviceFacets = ndioProxyExt.getDeviceFacets();
            BProxyConversion proxyConversion = ndioProxyExt.getConversion();
            Object nrioConversion = proxyConversion instanceof BShunt500OhmConversion ? BNrioShunt500OhmConversion.make() : (proxyConversion instanceof BTabularThermistorConversion ? BNrioTabularThermistorConversion.make() : (proxyConversion instanceof BThermistorType3Conversion ? BNrioThermistorType3Conversion.DEFAULT : proxyConversion));
            BPollFrequency pollFrequency = ndioProxyExt.getPollFrequency();
            if (pointExtension instanceof BNdioBooleanInputProxyExt) {
                nrioProxyExt = new BNrioBooleanInputProxyExt();
            } else if (pointExtension instanceof BNdioBooleanOutputProxyExt) {
                nrioProxyExt = new BNrioRelayOutputProxyExt();
            } else if (pointExtension instanceof BNdioCounterInputProxyExt) {
                BRelTime interval;
                BNdioCounterInputProxyExt ndioCounter = (BNdioCounterInputProxyExt)pointExtension;
                int outputSelect = ndioCounter.getOutputSelect().getOrdinal();
                double rate = ndioCounter.getRate();
                BTypeSpec rateCalcType = ndioCounter.getRateCalcType();
                float rateCalcScale = ndioCounter.getRateCalc().getScale();
                BNrioCounterInputProxyExt nrioCounter = new BNrioCounterInputProxyExt();
                if (rateCalcType.equals((Object)BTriggerRateType.TYPE.getTypeSpec())) {
                    nrioCounter.setRateCalcType(com.tridium.nrio.types.BTriggerRateType.TYPE.getTypeSpec());
                    com.tridium.nrio.types.BTriggerRateType rateType = new com.tridium.nrio.types.BTriggerRateType();
                    rateType.setScale(rateCalcScale);
                    nrioCounter.setRateCalc((BAbstractRateType)rateType);
                } else if (rateCalcType.equals((Object)com.tridium.ndio.type.BFixedWindowRateType.TYPE.getTypeSpec())) {
                    interval = ((com.tridium.ndio.type.BFixedWindowRateType)ndioCounter.getRateCalc()).getInterval();
                    nrioCounter.setRateCalcType(BFixedWindowRateType.TYPE.getTypeSpec());
                    BFixedWindowRateType rateType = new BFixedWindowRateType();
                    rateType.setInterval(interval);
                    rateType.setScale(rateCalcScale);
                    nrioCounter.setRateCalc((BAbstractRateType)rateType);
                } else if (rateCalcType.equals((Object)BSlidingWindowRateType.TYPE.getTypeSpec())) {
                    interval = (BRelTime)ndioCounter.getRateCalc().get("interval");
                    interval = ((com.tridium.ndio.type.BFixedWindowRateType)ndioCounter.getRateCalc()).getInterval();
                    int windows = ((BSlidingWindowRateType)ndioCounter.getRateCalc()).getWindows();
                    nrioCounter.setRateCalcType(com.tridium.nrio.types.BSlidingWindowRateType.TYPE.getTypeSpec());
                    com.tridium.nrio.types.BSlidingWindowRateType rateType = new com.tridium.nrio.types.BSlidingWindowRateType();
                    rateType.setInterval(interval);
                    rateType.setWindows(windows);
                    rateType.setScale(rateCalcScale);
                    nrioCounter.setRateCalc((BAbstractRateType)rateType);
                }
                nrioCounter.setOutputSelect(BNrio16CounterSelectEnum.make((int)outputSelect));
                nrioCounter.setRate(rate);
                nrioProxyExt = nrioCounter;
            } else if (pointExtension instanceof BNdioResistiveInputProxyExt) {
                nrioProxyExt = new BNrioResistiveInputProxyExt();
            } else if (pointExtension instanceof BNdioVoltageInputProxyExt) {
                nrioProxyExt = new BNrioVoltageInputProxyExt();
            } else {
                if (!(pointExtension instanceof BNdioVoltageOutputProxyExt)) continue;
                nrioProxyExt = new BNrioVoltageOutputProxyExt();
            }
            nrioProxyExt.setInstance(instance);
            nrioProxyExt.setEnabled(enabled);
            if (tuningPolicyName != null && !tuningPolicyName.isEmpty()) {
                nrioProxyExt.setTuningPolicyName(tuningPolicyName);
            }
            if (deviceFacets != null) {
                nrioProxyExt.setDeviceFacets(deviceFacets);
            }
            if (proxyConversion != null) {
                nrioProxyExt.setConversion((BProxyConversion)nrioConversion);
            }
            if (pollFrequency != null) {
                nrioProxyExt.setPollFrequency(pollFrequency);
            }
            nrio.setProxyExt((BAbstractProxyExt)nrioProxyExt);
        }
        return nrio;
    }

    public static String ndioToNrioName(String name) {
        int index = -1;
        do {
            if ((index = name.toLowerCase().indexOf("ndio")) <= -1) continue;
            int dindex = index + 1;
            name = name.substring(0, dindex) + (char)(name.charAt(dindex) + 14) + name.substring(dindex + 1);
        } while (index > -1);
        return name;
    }

    private class UpdateRunnable
    implements Runnable {
        private boolean done = false;

        private UpdateRunnable() {
        }

        @Override
        public void run() {
            String baseMessage = "Processing";
            int numDots = 0;
            while (!this.done) {
                String message = baseMessage;
                for (int i = 0; i < numDots; ++i) {
                    message = message + " .";
                }
                BNdioToNrioConverterDialog.this.resultsPane.setText(message);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                numDots = numDots == 3 ? 0 : numDots + 1;
            }
        }

        public void end() {
            this.done = true;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            BNdioToNrioConverterDialog.this.convert();
        }
    }
}

