/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.virtual.BBacnetVirtualGateway;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.data.BIDataValue;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;

public class BBacnetVirtualObject
extends BVirtualComponent
implements BacnetConst {
    private static final BFacets UNINITIALIZED_FACETS = BFacets.make((String)"initialized", (BIDataValue)BBoolean.FALSE);
    public static final Property objectId = BBacnetVirtualObject.newProperty((int)5, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property facets = BBacnetVirtualObject.newProperty((int)0, (BValue)UNINITIALIZED_FACETS, null);
    public static final Property tuningPolicyName = BBacnetVirtualObject.newProperty((int)0, (String)"defaultPolicy", (BFacets)BFacets.make((String)"fieldEditor", (String)"bacnet:VirtualTuningPolicyNameFE"));
    public static final Property writePriority = BBacnetVirtualObject.newProperty((int)0, (int)-1, null);
    public static final Property prioritizedPoint = BBacnetVirtualObject.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BBacnetVirtualObject.class);
    private static Logger log = Logger.getLogger("bacnet.virtual");
    static final String POLICY_DEF = "policy=";
    static final int POLICY_DEF_LEN = 7;
    static final String PRIORITY_DEF = "priority=";
    static final int PRIORITY_DEF_LEN = 9;
    private BBacnetTuningPolicy cachedPolicy = null;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String v) {
        this.setString(tuningPolicyName, v, null);
    }

    public int getWritePriority() {
        return this.getInt(writePriority);
    }

    public void setWritePriority(int v) {
        this.setInt(writePriority, v, null);
    }

    public boolean getPrioritizedPoint() {
        return this.getBoolean(prioritizedPoint);
    }

    public void setPrioritizedPoint(boolean v) {
        this.setBoolean(prioritizedPoint, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetVirtualObject() {
    }

    public BBacnetVirtualObject(String virtualPathName) {
        try {
            StringTokenizer st = new StringTokenizer(virtualPathName, ";");
            BBacnetObjectIdentifier id = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(st.nextToken());
            this.setObjectId(id);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith(POLICY_DEF)) {
                    this.setTuningPolicyName(s.substring(7));
                    continue;
                }
                if (!s.startsWith(PRIORITY_DEF)) continue;
                try {
                    int pri = Integer.parseInt(s.substring(9));
                    this.setWritePriority(pri);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Invalid priority: " + s + " in virtualPathName for " + virtualPathName, e);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException occurred in BBacnetVirtualObject", e);
        }
    }

    public String toString(Context cx) {
        return this.getObjectId().toString(cx);
    }

    public void started() throws Exception {
        this.discoverFacets();
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BBacnetVirtualProperty;
    }

    public BBacnetDevice device() {
        if (this.getVirtualGateway() == null) {
            return null;
        }
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).device();
    }

    public void updateStatus() {
        SlotCursor sc = this.getProperties();
        while (sc.next(BBacnetVirtualProperty.class)) {
            ((BBacnetVirtualProperty)sc.get()).updateStatus();
        }
    }

    public BBacnetTuningPolicy getPolicy() {
        if (this.cachedPolicy == null) {
            String tpName = this.getTuningPolicyName();
            BBacnetTuningPolicyMap map = this.getPolicyMap();
            BValue x = map.get(tpName);
            if (x instanceof BBacnetTuningPolicy) {
                this.cachedPolicy = (BBacnetTuningPolicy)x;
            } else {
                log.warning("TuningPolicy not found: " + tpName);
                this.cachedPolicy = (BBacnetTuningPolicy)map.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    protected void discoverFacets() {
        this.network().postAsync(new Runnable(){

            @Override
            public void run() {
                HashMap<String, BIDataValue> m = BacnetDiscoveryUtil.discoverFacets(BBacnetVirtualObject.this.getObjectId(), BBacnetVirtualObject.this.device());
                BBacnetVirtualObject.this.setFacets(BFacets.make(m));
                int objectType = BBacnetVirtualObject.this.getObjectId().getObjectType();
                if (objectType == 1 || objectType == 4 || objectType == 14) {
                    BBacnetVirtualObject.this.setPrioritizedPoint(true);
                } else if (objectType == 2 || objectType == 5 || objectType == 19) {
                    BBacnetVirtualObject.this.setPrioritizedPoint(BacnetDiscoveryUtil.checkForPriorityArray(BBacnetVirtualObject.this.getObjectId(), BBacnetVirtualObject.this.device()).getBoolean());
                }
            }
        });
    }

    private BBacnetNetwork network() {
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).network();
    }

    private BBacnetTuningPolicyMap getPolicyMap() {
        BBacnetTuningPolicyMap map = (BBacnetTuningPolicyMap)this.network().get("tuningPolicies");
        if (map != null) {
            return map;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetVirtualObject", 2);
        out.prop((Object)"cachedPolicy", (Object)this.cachedPolicy);
        out.endProps();
    }
}

