/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualComponent;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;

@Deprecated
public class BBacnetVirtualArray
extends BVirtualComponent
implements BacnetConst,
BIBacnetDataType {
    public static final Property arrayTypeSpec = BBacnetVirtualArray.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    public static final Property size = BBacnetVirtualArray.newProperty((int)4, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BBacnetVirtualArray.class);
    private int asnType;
    boolean elementsLoaded = false;
    private static final Logger logger = Logger.getLogger("bacnet");

    public BTypeSpec getArrayTypeSpec() {
        return (BTypeSpec)this.get(arrayTypeSpec);
    }

    public void setArrayTypeSpec(BTypeSpec v) {
        this.set(arrayTypeSpec, (BValue)v, null);
    }

    public int getSize() {
        return this.getInt(size);
    }

    public void setSize(int v) {
        this.setInt(size, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetVirtualArray() {
    }

    public BBacnetVirtualArray(Type arrayType) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)arrayType));
    }

    public BBacnetVirtualArray(Type arrayType, int fixedSize) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)arrayType));
        this.setSize(fixedSize);
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (cx == noWrite) {
            return;
        }
        BComponentSpace space = this.getComponentSpace();
        if (space instanceof BVirtualComponentSpace) {
            int ndx = BBacnetVirtualArray.index(p.getName());
            this.getParent().asComponent().added(this.getPropertyInParent(), (Context)BFacets.make((String)"index", (BIDataValue)BInteger.make((int)ndx)));
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (cx == noWrite) {
            return;
        }
        BComponentSpace space = this.getComponentSpace();
        if (space instanceof BVirtualComponentSpace) {
            int ndx = BBacnetVirtualArray.index(p.getName());
            this.getParent().asComponent().removed(this.getPropertyInParent(), oldValue, (Context)BFacets.make((String)"index", (BIDataValue)BInteger.make((int)ndx)));
        }
    }

    public final void changed(Property p, Context cx) {
        BComponentSpace space;
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (!p.equals(size) && !p.equals(arrayTypeSpec) && (space = this.getComponentSpace()) instanceof BVirtualComponentSpace) {
            if (cx != noWrite) {
                this.getParent().asComponent().changed(this.getPropertyInParent(), (Context)BFacets.make((String)"index", (BIDataValue)BInteger.make((int)this.index(p))));
            } else {
                this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            }
        }
    }

    public final void subscribed() {
        BComponent c;
        BComponentSpace space = this.getComponentSpace();
        if (space instanceof BVirtualComponentSpace && !(c = this.getParent().asComponent()).isSubscribed()) {
            c.subscribed();
        }
    }

    public void unsubscribed() {
        BComponent c;
        BComponentSpace space = this.getComponentSpace();
        if (space instanceof BVirtualComponentSpace && !(c = this.getParent().asComponent()).isSubscribed()) {
            c.unsubscribed();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetVirtualComponent;
    }

    public String toString(Context cx) {
        int size = this.getSize();
        String sz = String.valueOf(size);
        if (size < 0) {
            sz = "N";
        }
        return "BacnetVirtualARRAY[" + sz + "] of " + this.getArrayType();
    }

    public final BValue getElement(int index) {
        if (index == 0) {
            return this.get(size);
        }
        return this.get(this.name(index - 1));
    }

    public final void setElement(int index, BValue value) {
        if (value.getType() == this.getArrayType() && index > 0) {
            this.set(this.name(index - 1), value);
        }
    }

    public static int index(String propName) {
        int sc = (propName = SlotPath.unescape((String)propName)).indexOf(";");
        if (sc < 0) {
            return Integer.parseInt(propName.substring(7));
        }
        return Integer.parseInt(propName.substring(7, sc));
    }

    private Type getArrayType() {
        try {
            return this.getArrayTypeSpec().getResolvedType();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "BacnetVirtualArray:Unable to get resolved Type for " + this.getArrayTypeSpec(), e);
            return null;
        }
    }

    private int asnType() {
        Type t = this.getArrayType();
        this.asnType = t == BBacnetNull.TYPE ? 0 : (t == BBoolean.TYPE ? 1 : (t == BBacnetUnsigned.TYPE ? 2 : (t == BInteger.TYPE ? 3 : (t == BFloat.TYPE ? 4 : (t == BDouble.TYPE ? 5 : (t == BBacnetOctetString.TYPE ? 6 : (t == BString.TYPE ? 7 : (t == BBacnetBitString.TYPE ? 8 : (BEnum.class.isAssignableFrom(t.getTypeClass()) ? 9 : (t == BBacnetDate.TYPE ? 10 : (t == BBacnetTime.TYPE ? 11 : (t == BBacnetObjectIdentifier.TYPE ? 12 : -1))))))))))));
        return this.asnType;
    }

    private String name(int ndx) {
        return "element" + (ndx + 1);
    }

    private int index(Property p) {
        return BBacnetVirtualArray.index(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeAsn(AsnOutput out) {
        AsnOutput asnOutput = out;
        synchronized (asnOutput) {
            SlotCursor c = this.getProperties();
            block20: while (c.next()) {
                try {
                    BValue arrayElement = c.get();
                    if (arrayElement instanceof BOrd) {
                        arrayElement = ((BOrd)arrayElement).get((BObject)this);
                    }
                    if (arrayElement == null || arrayElement.getType() != this.getArrayType()) continue;
                    switch (this.asnType()) {
                        case 0: {
                            out.writeNull();
                            continue block20;
                        }
                        case 1: {
                            out.writeBoolean((BBoolean)c.get());
                            continue block20;
                        }
                        case 2: {
                            out.writeUnsigned((BBacnetUnsigned)c.get());
                            continue block20;
                        }
                        case 3: {
                            out.writeSignedInteger((BInteger)c.get());
                            continue block20;
                        }
                        case 4: {
                            out.writeReal((BNumber)((BFloat)c.get()));
                            continue block20;
                        }
                        case 5: {
                            out.writeDouble((BNumber)((BDouble)c.get()));
                            continue block20;
                        }
                        case 6: {
                            out.writeOctetString((BBacnetOctetString)c.get());
                            continue block20;
                        }
                        case 7: {
                            out.writeCharacterString((BString)c.get());
                            continue block20;
                        }
                        case 8: {
                            out.writeBitString((BBacnetBitString)c.get());
                            continue block20;
                        }
                        case 9: {
                            out.writeEnumerated((BEnum)c.get());
                            continue block20;
                        }
                        case 10: {
                            out.writeDate((BBacnetDate)c.get());
                            continue block20;
                        }
                        case 11: {
                            out.writeTime((BBacnetTime)c.get());
                            continue block20;
                        }
                        case 12: {
                            out.writeObjectIdentifier((BBacnetObjectIdentifier)c.get());
                            continue block20;
                        }
                    }
                    ((BIBacnetDataType)c.get()).writeAsn(out);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, this.getName() + ":" + this + ": writeAsn: Exception!", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        void var5_10;
        ArrayList<BSimple> v = new ArrayList<BSimple>();
        AsnInput asnInput = in;
        synchronized (asnInput) {
            while (in.peekTag() != -1) {
                BSimple arrayElement;
                switch (this.asnType()) {
                    case 0: {
                        arrayElement = in.readNull();
                        break;
                    }
                    case 1: {
                        arrayElement = BBoolean.make((boolean)in.readBoolean());
                        break;
                    }
                    case 2: {
                        arrayElement = in.readUnsigned();
                        break;
                    }
                    case 3: {
                        arrayElement = BInteger.make((int)in.readSignedInteger());
                        break;
                    }
                    case 4: {
                        arrayElement = BFloat.make((float)in.readReal());
                        break;
                    }
                    case 5: {
                        arrayElement = BDouble.make((double)in.readDouble());
                        break;
                    }
                    case 6: {
                        arrayElement = BBacnetOctetString.make(in.readOctetString());
                        break;
                    }
                    case 7: {
                        arrayElement = BString.make((String)in.readCharacterString());
                        break;
                    }
                    case 8: {
                        arrayElement = in.readBitString();
                        break;
                    }
                    case 9: {
                        BEnum bEnum = (BEnum)this.getArrayType().getInstance();
                        arrayElement = bEnum.getRange().get(in.readEnumerated());
                        break;
                    }
                    case 10: {
                        arrayElement = in.readDate();
                        break;
                    }
                    case 11: {
                        arrayElement = in.readTime();
                        break;
                    }
                    case 12: {
                        arrayElement = in.readObjectIdentifier();
                        break;
                    }
                    default: {
                        arrayElement = (BValue)this.getArrayType().getInstance();
                        ((BIBacnetDataType)arrayElement).readAsn(in);
                    }
                }
                if (arrayElement == null) continue;
                v.add(arrayElement);
            }
        }
        int ndx = 0;
        for (BValue bValue : v) {
            String name;
            Property p;
            if ((p = this.getProperty(name = this.name(ndx++))) != null) {
                this.set(p, bValue, noWrite);
                continue;
            }
            this.add(name, bValue, noWrite);
        }
        Property property = this.getProperty(this.name(ndx++));
        while (var5_10 != null) {
            this.remove((Property)var5_10, noWrite);
            Property property2 = this.getProperty(this.name(ndx++));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAsn(AsnInput in, int index) throws AsnException {
        AsnInput asnInput = in;
        synchronized (asnInput) {
            BSimple arrayElement;
            switch (this.asnType()) {
                case 0: {
                    arrayElement = in.readNull();
                    break;
                }
                case 1: {
                    arrayElement = BBoolean.make((boolean)in.readBoolean());
                    break;
                }
                case 2: {
                    arrayElement = in.readUnsigned();
                    break;
                }
                case 3: {
                    arrayElement = BInteger.make((int)in.readSignedInteger());
                    break;
                }
                case 4: {
                    arrayElement = BFloat.make((float)in.readReal());
                    break;
                }
                case 5: {
                    arrayElement = BDouble.make((double)in.readDouble());
                    break;
                }
                case 6: {
                    arrayElement = BBacnetOctetString.make(in.readOctetString());
                    break;
                }
                case 7: {
                    arrayElement = BString.make((String)in.readCharacterString());
                    break;
                }
                case 8: {
                    arrayElement = in.readBitString();
                    break;
                }
                case 9: {
                    BEnum d = (BEnum)this.getArrayType().getInstance();
                    arrayElement = d.getRange().get(in.readEnumerated());
                    break;
                }
                case 10: {
                    arrayElement = in.readDate();
                    break;
                }
                case 11: {
                    arrayElement = in.readTime();
                    break;
                }
                case 12: {
                    arrayElement = in.readObjectIdentifier();
                    break;
                }
                default: {
                    arrayElement = (BValue)this.getArrayType().getInstance();
                    ((BIBacnetDataType)arrayElement).readAsn(in);
                }
            }
            Property p = this.getProperty("element" + index);
            if (p != null && arrayElement != null) {
                this.set(p, (BValue)arrayElement, noWrite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeAsn(AsnOutput out, int index) {
        AsnOutput asnOutput = out;
        synchronized (asnOutput) {
            try {
                BValue arrayElement = this.getElement(index);
                if (arrayElement != null && arrayElement.getType() == this.getArrayType()) {
                    switch (this.asnType()) {
                        case 0: {
                            out.writeNull();
                            break;
                        }
                        case 1: {
                            out.writeBoolean((BBoolean)arrayElement);
                            break;
                        }
                        case 2: {
                            out.writeUnsigned((BBacnetUnsigned)arrayElement);
                            break;
                        }
                        case 3: {
                            out.writeSignedInteger((BInteger)arrayElement);
                            break;
                        }
                        case 4: {
                            out.writeReal((BNumber)((BFloat)arrayElement));
                            break;
                        }
                        case 5: {
                            out.writeDouble((BNumber)((BDouble)arrayElement));
                            break;
                        }
                        case 6: {
                            out.writeOctetString((BBacnetOctetString)arrayElement);
                            break;
                        }
                        case 7: {
                            out.writeCharacterString((BString)arrayElement);
                            break;
                        }
                        case 8: {
                            out.writeBitString((BBacnetBitString)arrayElement);
                            break;
                        }
                        case 9: {
                            out.writeEnumerated((BEnum)arrayElement);
                            break;
                        }
                        case 10: {
                            out.writeDate((BBacnetDate)arrayElement);
                            break;
                        }
                        case 11: {
                            out.writeTime((BBacnetTime)arrayElement);
                            break;
                        }
                        case 12: {
                            out.writeObjectIdentifier((BBacnetObjectIdentifier)arrayElement);
                            break;
                        }
                        default: {
                            ((BIBacnetDataType)arrayElement).writeAsn(out);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, this.getName() + ":" + this + ": writeAsn: Exception!", e);
            }
        }
    }
}

