/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util.worker;

import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BBacnetWorkerPool
extends BComponent
implements IWorkerPool {
    private static final int DEFAULT_WORKERS = 2;
    public static final Property maxThreads = BBacnetWorkerPool.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Type TYPE = Sys.loadType(BBacnetWorkerPool.class);
    private ThreadPoolWorker worker = null;
    private Queue queue = null;
    private static final BIcon icon = BIcon.std((String)"gears.png");

    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    public void setMaxThreads(int v) {
        this.setInt(maxThreads, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return BBacnetWorkerPool.isLegalParent(parent);
    }

    public static boolean isLegalParent(BComponent parent) {
        return parent instanceof IWorkerPoolAware && !BBacnetWorkerPool.alreadyHasWorkerPool(parent);
    }

    private static boolean alreadyHasWorkerPool(BComponent parent) {
        BComponent[] children = parent.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IWorkerPool)) continue;
            return true;
        }
        return false;
    }

    public void started() throws Exception {
        super.started();
        IWorkerPoolAware parent = (IWorkerPoolAware)this.getParent();
        this.queue = parent.getQueue();
        this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
        this.worker.setMaxThreads(this.getMaxThreads());
        this.worker.start(parent.getWorkerThreadName());
        parent.stopWorker();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.worker.stop();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(maxThreads)) {
            this.updateMaxThreads();
        }
    }

    private void updateMaxThreads() {
        this.worker.setMaxThreads(this.getMaxThreads());
    }

    @Override
    public IFuture post(Runnable r) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

