/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.point;

import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.point.BBacnetPointFolder;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.LongHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetPointDeviceExt
extends BPointDeviceExt
implements BIBacnetObjectContainer {
    public static final Action submitPointDiscoveryJob = BBacnetPointDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBacnetPointDeviceExt.class);
    private LongHashMap byPointHash = new LongHashMap();
    private Hashtable<BBacnetObjectIdentifier, Array<BControlPoint>> byObjectId = new Hashtable();

    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BBacnetDevice.TYPE;
    }

    public Type getProxyExtType() {
        return BBacnetProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return BBacnetPointFolder.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetDevice;
    }

    public BOrd doSubmitPointDiscoveryJob(Context cx) {
        if (this.device().isFatalFault()) {
            return null;
        }
        return new BBacnetDiscoverPointsJob(this).submit(cx);
    }

    @Override
    public BObject lookupBacnetObject(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex, String domain) {
        return this.findPoint(objectId, propertyId, propertyArrayIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerPoint(BBacnetProxyExt pExt) {
        LongHashMap longHashMap = this.byPointHash;
        synchronized (longHashMap) {
            this.byPointHash.put(BBacnetPointDeviceExt.hash(pExt), (Object)pExt.getParentPoint());
            Array a = this.byObjectId.get((Object)pExt.getObjectId());
            if (a == null) {
                a = new Array(BControlPoint.class);
            }
            a.add((Object)pExt.getParentPoint());
            this.byObjectId.put(pExt.getObjectId(), (Array<BControlPoint>)a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterPoint(BBacnetProxyExt pExt) {
        BControlPoint pt = pExt.getParentPoint();
        LongHashMap longHashMap = this.byPointHash;
        synchronized (longHashMap) {
            LongHashMap.Iterator it = this.byPointHash.iterator();
            while (it.hasNext()) {
                BControlPoint p = (BControlPoint)it.next();
                if (!p.equals((Object)pt)) continue;
                this.byPointHash.remove(it.key());
            }
            Array<BControlPoint> a = this.byObjectId.get((Object)pExt.getObjectId());
            if (a != null) {
                a.remove((Object)pExt.getParentPoint());
                if (a.size() == 0) {
                    this.byObjectId.values().remove(a);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reregisterPoint(BBacnetProxyExt pExt) {
        LongHashMap longHashMap = this.byPointHash;
        synchronized (longHashMap) {
            this.unregisterPoint(pExt);
            this.registerPoint(pExt);
        }
    }

    private static long hash(BBacnetProxyExt pExt) {
        return BBacnetPointDeviceExt.hash(pExt.getObjectId().hashCode(), pExt.getPropertyId().getOrdinal(), pExt.getPropertyArrayIndex());
    }

    private static long hash(int objectId, int propertyId, int propertyArrayIndex) {
        long hash = (long)objectId << 32 | (long)((propertyId & 0xFFFF) << 16) | (long)(propertyArrayIndex & 0xFFFF);
        return hash;
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    public final BControlPoint findPoint(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        BControlPoint pt = (BControlPoint)this.byPointHash.get(BBacnetPointDeviceExt.hash(objectId.hashCode(), propertyId, propertyArrayIndex));
        return pt;
    }

    public final BControlPoint[] findPoints(BBacnetObjectIdentifier objectId) {
        Array<BControlPoint> a = this.byObjectId.get((Object)objectId);
        if (a != null) {
            return (BControlPoint[])a.trim();
        }
        return new BControlPoint[0];
    }

    public final BControlPoint[] findPoints(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        int size;
        Array<BControlPoint> a = this.byObjectId.get((Object)objectId);
        if (a != null && (size = a.size()) > 0) {
            if (size == 1 && BBacnetPointDeviceExt.pointMatches((BControlPoint)a.get(0), propertyId, propertyArrayIndex)) {
                return (BControlPoint[])a.trim();
            }
            Array filtered = new Array(BControlPoint.class);
            for (int i = 0; i < size; ++i) {
                BControlPoint point = (BControlPoint)a.get(i);
                if (!BBacnetPointDeviceExt.pointMatches(point, propertyId, propertyArrayIndex)) continue;
                filtered.add((Object)point);
            }
            return (BControlPoint[])filtered.trim();
        }
        return new BControlPoint[0];
    }

    private static boolean pointMatches(BControlPoint point, int propertyId, int propertyArrayIndex) {
        if (point.getProxyExt() instanceof BBacnetProxyExt) {
            BBacnetProxyExt proxy = (BBacnetProxyExt)point.getProxyExt();
            return proxy.getPropertyId().getOrdinal() == propertyId && proxy.getPropertyArrayIndex() == propertyArrayIndex;
        }
        return false;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetPointDeviceExt", 2);
        out.trTitle((Object)("byPointHash:" + this.byPointHash.size()), 2);
        LongHashMap.Iterator it = this.byPointHash.iterator();
        while (it.hasNext()) {
            BControlPoint pt = (BControlPoint)it.next();
            out.prop((Object)("  " + Long.toHexString(it.key())), (Object)(SlotPath.unescape((String)pt.getName()) + ":" + pt.getHandleOrd()));
        }
        out.trTitle((Object)("byObjectId:" + this.byObjectId.size()), 2);
        Enumeration<BBacnetObjectIdentifier> e = this.byObjectId.keys();
        while (e.hasMoreElements()) {
            BBacnetObjectIdentifier k = e.nextElement();
            out.prop((Object)("  " + (Object)((Object)k)), this.byObjectId.get((Object)k));
        }
        out.endProps();
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("driver:PointManager");
        agents.toBottom("bacnetEDE:EdeBacnetPointManager");
        return agents;
    }
}

