/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;

public class BacnetPropertyList {
    private static int[] requiredProps = new int[]{77, 79, 75};

    public static int[] makePropertyList(int[] ... propertyLists) {
        int totalSize = 0;
        for (int[] propList : propertyLists) {
            totalSize += propList.length;
        }
        int i = 0;
        int[] propertyList = new int[totalSize];
        int[][] nArray = propertyLists;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int[] propList;
            for (int prop : propList = nArray[j]) {
                propertyList[i++] = prop;
            }
        }
        return propertyList;
    }

    public static byte[] readAll(int[] props) {
        AsnOutputStream out = new AsnOutputStream();
        for (int propId : props) {
            if (!BacnetPropertyList.shouldInclude(propId)) continue;
            out.writeEnumerated(propId);
        }
        return out.toByteArray();
    }

    public static int size(int[] props) {
        int i = 0;
        for (int propId : props) {
            if (!BacnetPropertyList.shouldInclude(propId)) continue;
            ++i;
        }
        return i;
    }

    public static int read(int ndx, int[] props) {
        int[] cleanProps = new int[props.length - requiredProps.length];
        int i = 0;
        for (int propId : props) {
            if (!BacnetPropertyList.shouldInclude(propId)) continue;
            cleanProps[i++] = propId;
        }
        if (ndx < 1 || ndx > cleanProps.length + 1) {
            return -1;
        }
        return cleanProps[ndx - 1];
    }

    public static NReadPropertyResult getInvalidIdx(int propId, int ndx) {
        return new NReadPropertyResult(propId, ndx, new NErrorType(2, 42));
    }

    public static boolean shouldInclude(int propId) {
        for (int i = 0; i < requiredProps.length; ++i) {
            if (propId != requiredProps[i]) continue;
            return false;
        }
        return true;
    }
}

