/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetNumericTrendLogExt;
import com.tridium.bacnet.history.BBacnetNumericTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendLogRemoteExt;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetClientCov;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetLoggingType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BCovHistoryExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.history.ext.BIntervalHistoryExt;
import javax.baja.history.ext.BNumericCovHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BBacnetTrendLogDescriptor
extends BBacnetEventSource
implements BacnetPropertyListProvider {
    public static final Property logOrd = BBacnetTrendLogDescriptor.newProperty((int)65, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetTrendLogDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(20), null);
    public static final Property historyOrd = BBacnetTrendLogDescriptor.newProperty((int)69, (BValue)BOrd.DEFAULT, null);
    public static final Property objectName = BBacnetTrendLogDescriptor.newProperty((int)0, (String)"", null);
    public static final Property description = BBacnetTrendLogDescriptor.newProperty((int)0, (String)"", null);
    public static final Property logDeviceObjectPropertyReference = BBacnetTrendLogDescriptor.newProperty((int)5, (BValue)new BBacnetDeviceObjectPropertyReference(), null);
    public static final Property covResubscriptionInterval = BBacnetTrendLogDescriptor.newProperty((int)0, (int)5, null);
    public static final Property reliability = BBacnetTrendLogDescriptor.newProperty((int)5, (BValue)BBacnetReliability.configurationError, null);
    public static final Property clientCovIncrement = BBacnetTrendLogDescriptor.newProperty((int)0, (BValue)new BBacnetClientCov(), null);
    public static final Type TYPE = Sys.loadType(BBacnetTrendLogDescriptor.class);
    private static final int[] ARRAY_PROPS = new int[]{130, 351, 352, 371};
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private int[] optionalProps;
    private BacnetTrendLogSubscriber logSubscriber;
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private static AsnInputStream asnIn = new AsnInputStream();
    private static AsnOutputStream asnOut = new AsnOutputStream();
    private static final BBacnetDeviceObjectPropertyReference NULL_DOPR = new BBacnetDeviceObjectPropertyReference();
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 133, 144, 126, 131, 141, 145, 36, 197, 111};
    private BIBacnetTrendLogExt tlog;
    private BComponent targetPoint;
    private static final Logger logger = Logger.getLogger("bacnet.export.object.trendlog");

    public BOrd getLogOrd() {
        return (BOrd)this.get(logOrd);
    }

    public void setLogOrd(BOrd v) {
        this.set(logOrd, (BValue)v, null);
    }

    @Override
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    public void setHistoryOrd(BOrd v) {
        this.set(historyOrd, (BValue)v, null);
    }

    @Override
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BBacnetDeviceObjectPropertyReference getLogDeviceObjectPropertyReference() {
        return (BBacnetDeviceObjectPropertyReference)this.get(logDeviceObjectPropertyReference);
    }

    public void setLogDeviceObjectPropertyReference(BBacnetDeviceObjectPropertyReference v) {
        this.set(logDeviceObjectPropertyReference, (BValue)v, null);
    }

    public int getCovResubscriptionInterval() {
        return this.getInt(covResubscriptionInterval);
    }

    public void setCovResubscriptionInterval(int v) {
        this.setInt(covResubscriptionInterval, v, null);
    }

    public BBacnetReliability getReliability() {
        return (BBacnetReliability)this.get(reliability);
    }

    public void setReliability(BBacnetReliability v) {
        this.set(reliability, (BValue)v, null);
    }

    public BBacnetClientCov getClientCovIncrement() {
        return (BBacnetClientCov)this.get(clientCovIncrement);
    }

    public void setClientCovIncrement(BBacnetClientCov v) {
        this.set(clientCovIncrement, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public final void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.logSubscriber = new BacnetTrendLogSubscriber(this, this.getLog());
        this.checkConfiguration();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.logSubscriber.unsubscribeAll();
        this.optionalProps = null;
        this.logSubscriber = null;
        this.tlog = null;
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    @Override
    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(logOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s.equals((Object)objectId)) {
            return BBacnetObjectType.getObjectIdFacets(20);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return (BObject)this.getLog();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getLogOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(logOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.logSubscriber.unsubscribeAll();
        boolean configOk = true;
        if (this.getLog() == null && !this.isDynamicallyCreated()) {
            this.setFaultCause("Cannot find exported history");
            configOk = false;
        } else {
            this.logSubscriber.config = this.tlog.getHistoryConfig();
            this.logSubscriber.subscribe((BComponent)this.tlog.getHistoryConfig());
            if (!this.isDynamicallyCreated()) {
                this.logSubscriber.subscribe((BComponent)((BComplex)this.tlog).getParent());
                BBacnetDeviceObjectPropertyReference logDOPRef = this.getLogDOPRef();
                if (logDOPRef != NULL_DOPR) {
                    this.setLogDeviceObjectPropertyReference(logDOPRef);
                } else {
                    logger.severe("Cannot write log device object property in static trend log extension on unexported control object.");
                }
            }
            if (objectName.isEquivalentToDefaultValue(this.get(objectName))) {
                this.setObjectName(this.tlog.getHistoryConfig().getId().getHistoryName());
            }
            this.setHistoryOrd(BOrd.make((String)("history:" + this.tlog.getHistoryConfig().getId().toString())));
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
        }
        if (configOk) {
            String err = BBacnetNetwork.localDevice().export(this);
            if (err != null) {
                this.duplicate = true;
                this.setFaultCause(err);
                configOk = false;
            } else {
                this.duplicate = false;
            }
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        return ext instanceof BBacnetTrendLogAlarmSourceExt;
    }

    @Override
    @Deprecated
    protected void updateAlarmInhibit() {
    }

    @Override
    public final boolean isEventInitiationEnabled() {
        return this.getNotificationClass() != null;
    }

    @Override
    public final BEnum getEventState() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BBacnetEventState.make(almExt.getAlarmState());
    }

    @Override
    public final BBacnetBitString getAckedTransitions() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAckedTransitions());
    }

    @Override
    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        BBacnetTimeStamp[] ets = new BBacnetTimeStamp[3];
        BAbsTime t = almExt.getToOffnormalTimes().getAlarmTime();
        ets[0] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        t = almExt.getToFaultTimes().getAlarmTime();
        ets[1] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        t = almExt.getToNormalTimes().getAlarmTime();
        ets[2] = BAbsTime.DEFAULT.equals((Object)t) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(t);
        return ets;
    }

    @Override
    public final BBacnetNotifyType getNotifyType() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return almExt.getNotifyType();
    }

    @Override
    public final BBacnetBitString getEventEnable() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable());
    }

    @Override
    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
        if (nc == null) {
            return null;
        }
        return nc.getEventPriorities();
    }

    @Override
    public BBacnetNotificationClassDescriptor getNotificationClass() {
        return BacnetTrendLogUtil.getNotificationClass(this.tlog);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.bufferReady;
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        this.getLog();
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        this.getLog();
        PropertyValue[] readResults = new PropertyValue[]{};
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(readResults);
    }

    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getLog();
        if (this.tlog == null) {
            return new ReadRangeAck(1, 1000);
        }
        if (rangeReference.getPropertyArrayIndex() >= 0 && !this.isArray(rangeReference.getPropertyId())) {
            return new ReadRangeAck(2, 50);
        }
        int pId = rangeReference.getPropertyId();
        if (pId == 131) {
            Integer pointAsnType = null;
            BAbstractProxyExt pxExt = this.getPoint().getProxyExt();
            if (pxExt instanceof BBacnetProxyExt) {
                BBacnetProxyExt bacPxExt = (BBacnetProxyExt)pxExt;
                pointAsnType = new Integer(AsnUtil.getAsnType(bacPxExt.getDataType()));
            } else {
                BBacnetDeviceObjectPropertyReference dopr = this.getLogDOPRef();
                if (dopr != null && dopr != NULL_DOPR) {
                    BBacnetObjectIdentifier oid = null;
                    oid = dopr.getObjectId();
                    if (oid != null) {
                        int objectType = oid.getObjectType();
                        int propId = dopr.getPropertyId();
                        PropertyInfo info = ObjectTypeList.getInstance().getPropertyInfo(objectType, propId);
                        pointAsnType = new Integer(info.getAsnType());
                    }
                }
            }
            int maxDataSize = -1;
            if (rangeReference instanceof BacnetConfirmedRequest) {
                maxDataSize = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength();
                maxDataSize -= 17;
            }
            switch (rangeReference.getRangeType()) {
                case 3: {
                    long referenceNum = rangeReference.getReferenceIndex();
                    int count = rangeReference.getCount();
                    try {
                        RangeData rlr = BacnetTrendLogUtil.readRangeByPosition(this.tlog, referenceNum, count, maxDataSize, pointAsnType);
                        return new ReadRangeAck(this.getObjectId(), pId, -1, rlr.getResultFlags(), rlr.getItemCount(), -1L, rlr.getItemData());
                    }
                    catch (Exception e) {
                        return new ReadRangeAck(2, 0);
                    }
                }
                case 7: {
                    maxDataSize -= 5;
                    BBacnetDateTime refTime = rangeReference.getReferenceTime();
                    int count = rangeReference.getCount();
                    try {
                        RangeData rlr = BacnetTrendLogUtil.readRangeByTime(this.tlog, refTime, count, maxDataSize, pointAsnType);
                        return new ReadRangeAck(this.getObjectId(), pId, -1, rlr.getResultFlags(), rlr.getItemCount(), rlr.getItemCount() > 0L ? rlr.getFirstSequenceNumber() : -1L, rlr.getItemData());
                    }
                    catch (Exception e) {
                        return new ReadRangeAck(2, 0);
                    }
                }
                case 6: {
                    maxDataSize -= 5;
                    long startSeqNum = rangeReference.getReferenceIndex();
                    int count = rangeReference.getCount();
                    try {
                        RangeData rlr = BacnetTrendLogUtil.readRangeBySequence(this.tlog, startSeqNum, count, maxDataSize, pointAsnType);
                        return new ReadRangeAck(this.getObjectId(), pId, -1, rlr.getResultFlags(), rlr.getItemCount(), rlr.getItemCount() > 0L ? rlr.getFirstSequenceNumber() : -1L, rlr.getItemData());
                    }
                    catch (Exception e) {
                        return new ReadRangeAck(2, 0);
                    }
                }
                case -1: {
                    try {
                        RangeData rlr = BacnetTrendLogUtil.readRangeAll(this.tlog, maxDataSize, pointAsnType);
                        return new ReadRangeAck(this.getObjectId(), pId, -1, rlr.getResultFlags(), rlr.getItemCount(), rlr.getItemCount() > 0L ? rlr.getFirstSequenceNumber() : -1L, rlr.getItemData());
                    }
                    catch (Exception e) {
                        return new ReadRangeAck(2, 0);
                    }
                }
            }
            logger.info("Unsupported ReadRange Range Type: " + rangeReference.getRangeType());
            return new ReadRangeAck(2, 0);
        }
        for (int i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (pId != REQUIRED_PROPS[i]) continue;
            return new ReadRangeAck(5, 22);
        }
        int[] props = this.getOptionalProps();
        for (int i = 0; i < props.length; ++i) {
            if (pId != props[i]) continue;
            return new ReadRangeAck(5, 22);
        }
        return new ReadRangeAck(2, 32);
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        this.getLog();
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getLog();
        if (this.tlog == null && !this.isDynamicallyCreated()) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
        int propertyId = propertyValue.getPropertyId();
        for (int i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        int[] props = this.getOptionalProps();
        for (int i = 0; i < props.length; ++i) {
            if (propertyId != props[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getLog();
        if (this.tlog == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
        int propertyId = propertyValue.getPropertyId();
        for (int i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        int[] props = this.getOptionalProps();
        for (int i = 0; i < props.length; ++i) {
            if (propertyId != props[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int propertyId) {
        for (int arrayPropId : ARRAY_PROPS) {
            if (propertyId != arrayPropId) continue;
            return true;
        }
        return false;
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        this.findLog();
        if (this.tlog == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0) {
            if (!this.isArray(pId)) {
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
            }
        } else if (ndx < -1) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
            case 133: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.tlog.getEnabled()));
            }
            case 144: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.tlog.getHistoryConfig().getFullPolicy().equals((Object)BFullPolicy.stop)));
            }
            case 126: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(BacnetTrendLogUtil.getMaxRecords(this.tlog)));
            }
            case 131: {
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 27));
            }
            case 141: {
                long recCount = 0L;
                try (HistoryDatabaseConnection conn = this.getHistoryDbConnection(BLocalBacnetDevice.getBacnetContext());){
                    BIHistory hist = this.getHistory(conn);
                    if (this.getHistory(conn) != null) {
                        recCount = conn.getRecordCount(hist);
                    }
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(recCount));
            }
            case 145: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(this.tlog.getTotalRecordCount()));
            }
            case 36: {
                return this.readEventState();
            }
            case 197: {
                return this.readLoggingType();
            }
            case 111: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.statusToAsnStatusFlags(BStatus.ok));
            }
        }
        return this.readOptionalProperty(pId, ndx);
    }

    private PropertyValue readEventState() {
        BControlPoint point;
        BAbstractProxyExt pxExt;
        if (!this.getEventDetectionEnable()) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        BBacnetTrendLogAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt == null) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        if (this.tlog instanceof BCovHistoryExt && (pxExt = (point = this.getPoint()).getProxyExt()) instanceof BBacnetProxyExt) {
            BBacnetProxyExt bac = (BBacnetProxyExt)pxExt;
            if (bac.useCov() && !bac.isCOV()) {
                return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(1));
            }
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(alarmExt.getAlarmState())));
    }

    private PropertyValue readLoggingType() {
        if (BacnetDescriptorUtil.isGenericTrendLogExtension(this.tlog)) {
            return ((BIntervalHistoryExt)this.getLog()).getInterval().getMillis() == 0L ? BBacnetTrendLogDescriptor.makeLoggingTypeResult(BBacnetLoggingType.cov) : BBacnetTrendLogDescriptor.makeLoggingTypeResult(BBacnetLoggingType.polled);
        }
        if (this.tlog instanceof BCovHistoryExt) {
            return BBacnetTrendLogDescriptor.makeLoggingTypeResult(BBacnetLoggingType.cov);
        }
        if (this.tlog instanceof BIntervalHistoryExt) {
            return BBacnetTrendLogDescriptor.makeLoggingTypeResult(BBacnetLoggingType.polled);
        }
        logger.warning(this + ": trend log ext type is not supported: " + this.tlog.getClass());
        return new NReadPropertyResult(197, new NErrorType(2, 0));
    }

    private static PropertyValue makeLoggingTypeResult(BBacnetLoggingType type) {
        return new NReadPropertyResult(197, AsnUtil.toAsnEnumerated((BEnum)type));
    }

    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            switch (pId) {
                case 17: {
                    BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
                    if (nc == null) {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(nc.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable())));
                }
                case 353: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getEventDetectionEnable()));
                }
                case 0: {
                    return this.readAckedTransitions(almExt.getAckedTransitions());
                }
                case 72: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)almExt.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(almExt.getToOffnormalTimes().getAlarmTime(), almExt.getToFaultTimes().getAlarmTime(), almExt.getToNormalTimes().getAlarmTime(), ndx);
                }
                case 351: {
                    return this.readEventMessageTexts(ndx);
                }
                case 352: {
                    return this.readEventMessageTextsConfig(almExt.getToOffnormalText().getFormat(), almExt.getToFaultText().getFormat(), almExt.getToNormalText().getFormat(), ndx);
                }
                case 137: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getNotificationThreshold()));
                }
                case 140: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getRecordsSinceNotification()));
                }
                case 173: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getLastNotifyRecord()));
                }
            }
        }
        BControlPoint point = this.getPoint();
        switch (pId) {
            case 205: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.tlog.getTrigger()));
            }
            case 142: {
                BBacnetDateTime startTime;
                if (!(this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) || (startTime = ((BBacnetActivePeriod)this.tlog.getActivePeriod()).getStartTime()) == null) break;
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsn((BValue)startTime));
            }
            case 143: {
                BBacnetDateTime stopTime;
                if (!(this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) || (stopTime = ((BBacnetActivePeriod)this.tlog.getActivePeriod()).getStopTime()) == null) break;
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsn((BValue)stopTime));
            }
            case 132: {
                BBacnetDeviceObjectPropertyReference dopRef = this.getLogDeviceObjectPropertyReference();
                if (dopRef == NULL_DOPR) {
                    return new NReadPropertyResult(pId, ndx, new NErrorType(2, 72));
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsn((BValue)dopRef));
            }
            case 134: {
                long interval = 0L;
                if (this.tlog instanceof BIntervalHistoryExt) {
                    interval = ((BIntervalHistoryExt)this.getLog()).getInterval().getMillis() / 10L;
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(interval));
            }
            case 127: {
                if (this.tlog instanceof BCovHistoryExt) {
                    BBacnetProxyExt ext;
                    SlotCursor c = point.getProperties();
                    if (c.next(BBacnetProxyExt.class) && (ext = (BBacnetProxyExt)c.get()).isCOV()) {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnNull());
                    }
                    if (this.tlog instanceof BNumericCovHistoryExt) {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnReal(((BNumericCovHistoryExt)this.tlog).getChangeTolerance()));
                    }
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnNull());
                }
                if (this.getClientCovIncrement().getIncrement().getStatus() != BStatus.nullStatus) {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnReal(this.getClientCovIncrement().getIncrement().getNumeric()));
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnNull());
            }
            case 128: {
                if (this.getLog() != null && this.tlog instanceof BCovHistoryExt) {
                    BBacnetProxyExt ext;
                    BBacnetDevice device;
                    SlotCursor c = point.getProperties();
                    if (!c.next(BBacnetProxyExt.class) || (device = (ext = (BBacnetProxyExt)c.get()).device()) == null || !ext.isCOV()) break;
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(ext.getCovSubscriptionLifetime() * 30));
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(this.getCovResubscriptionInterval()));
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    private NReadPropertyResult readAckedTransitions(BAlarmTransitionBits ackedTrans) {
        if (this.getEventDetectionEnable()) {
            BAlarmTransitionBits eventTrans = this.readEventTransition(ackedTrans);
            return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(eventTrans)));
        }
        return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(ACKED_TRANS_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            this.getLog();
            if (ndx >= 0) {
                if (!this.isArray(pId)) {
                    return new NErrorType(2, 50);
                }
            } else if (ndx < -1) {
                return new NErrorType(2, 42);
            }
            try {
                switch (pId) {
                    case 77: {
                        return BacUtil.setObjectName(this, objectName, val);
                    }
                    case 144: {
                        if (AsnUtil.fromAsnBoolean(val)) {
                            this.tlog.getHistoryConfig().setFullPolicy(BFullPolicy.stop);
                        } else {
                            this.tlog.getHistoryConfig().setFullPolicy(BFullPolicy.roll);
                        }
                        return null;
                    }
                    case 36: 
                    case 75: 
                    case 79: 
                    case 111: 
                    case 126: 
                    case 131: 
                    case 145: 
                    case 197: 
                    case 371: {
                        return new NErrorType(2, 40);
                    }
                    case 132: {
                        asnIn.setBuffer(val);
                        BBacnetDeviceObjectPropertyReference dopr = new BBacnetDeviceObjectPropertyReference();
                        dopr.readAsn(asnIn);
                        BBacnetDeviceObjectPropertyReference currDopr = this.getLogDeviceObjectPropertyReference();
                        if (BacnetDescriptorUtil.isEqual(dopr, currDopr)) {
                            return null;
                        }
                        BComponent point = this.getTargetPoint(new NBacnetPropertyValue(pId, dopr.getPropertyArrayIndex(), val));
                        if (point == null) {
                            return new NErrorType(2, 45);
                        }
                        BIBacnetTrendLogExt trendLogExt = this.getLog();
                        boolean enabled = ((BHistoryExt)trendLogExt).getEnabled();
                        ((BHistoryExt)trendLogExt).setEnabled(false);
                        if (this.getLogOrd().isNull() && point instanceof BControlPoint && BacnetDescriptorUtil.areTrendLogAndPointCompatible((BControlPoint)point, trendLogExt, dopr) && BacnetDescriptorUtil.isLocalDeviceID(dopr.getDeviceId().getInstanceNumber())) {
                            String trendLogName = "TrendLog_" + this.getObjectId().getInstanceNumber();
                            point.add(trendLogName, (BValue)((BIntervalHistoryExt)trendLogExt));
                            this.setLogOrd(((BIntervalHistoryExt)trendLogExt).getHandleOrd());
                            BacnetDescriptorUtil.removeHistory(this, false);
                        } else {
                            PropertyValue[] pvs = BacnetDescriptorUtil.getValuesWrittenToTrendExtension(this);
                            BacnetDescriptorUtil.removeHistory(this, true);
                            this.tlog = null;
                            try {
                                this.tlog = BacnetDescriptorUtil.copy(this, dopr, pvs);
                            }
                            catch (BacnetException e) {
                                return new NErrorType(2, 45);
                            }
                        }
                        this.setLogDeviceObjectPropertyReference(dopr);
                        if (!(this.tlog instanceof BNumericCovHistoryExt || this.tlog instanceof BBacnetNumericTrendLogRemoteExt || this.tlog instanceof BBacnetNumericTrendLogExt)) {
                            this.setClientCovIncrement(new BBacnetClientCov());
                        }
                        BBacnetNetwork.localDevice().exportByOrd(this);
                        ((BHistoryExt)this.getLog()).setEnabled(enabled);
                        return null;
                    }
                    case 28: {
                        this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 133: {
                        if (Flags.isReadonly((BComplex)((BComplex)this.tlog), (Slot)BBacnetNumericTrendLogExt.enabled)) {
                            return new NErrorType(1, 1000);
                        }
                        long recCount = 0L;
                        try (HistoryDatabaseConnection conn = this.getHistoryDbConnection(BLocalBacnetDevice.getBacnetContext());){
                            BIHistory hist = this.getHistory(conn);
                            if (this.getHistory(conn) != null) {
                                recCount = conn.getRecordCount(hist);
                            }
                        }
                        long bufSize = BacnetTrendLogUtil.getMaxRecords(this.tlog);
                        if (this.tlog.getHistoryConfig().getFullPolicy().equals((Object)BFullPolicy.stop) && recCount >= bufSize) {
                            return new NErrorType(1, 75);
                        }
                        ((BHistoryExt)this.getLog()).setBoolean(BHistoryExt.enabled, AsnUtil.fromOnlyAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                        if (this.getLogOrd() == null || this.getLogOrd().isNull()) {
                            this.setReliability(BBacnetReliability.configurationError);
                        }
                        return null;
                    }
                    case 141: {
                        long recordCount = AsnUtil.fromAsnUnsignedInteger(val);
                        if (recordCount != 0L) {
                            return new NErrorType(2, 37);
                        }
                        try (HistoryDatabaseConnection conn = this.getHistoryDbConnection(BLocalBacnetDevice.getBacnetContext());){
                            if (conn.getHistory(this.tlog.getHistoryConfig().getId()) == null) {
                                ErrorType errorType = null;
                                return errorType;
                            }
                            conn.clearAllRecords(this.tlog.getHistoryConfig().getId());
                            BacnetTrendLogUtil.writeEvent(this.tlog, BAbsTime.now(), BStatus.DEFAULT, BacnetTrendLogUtil.incrementSequenceNumber(this.tlog.getTotalRecordCount()), this.tlog.getEnabled() ? BTrendEvent.LOG_STATUS_ENABLED_BUFFER_PURGED : BTrendEvent.LOG_STATUS_DISABLED_BUFFER_PURGED);
                        }
                        catch (PermissionException e) {
                            logger.info("PermissionException clearing history " + this + ":" + (Object)((Object)e));
                            return new NErrorType(2, 40);
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Error clearing history " + this, e);
                            return new NErrorType(0, 25);
                        }
                        return null;
                    }
                }
                return this.writeOptionalProperty(pId, ndx, val, pri);
            }
            catch (AsnException e) {
                logger.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                logger.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
    }

    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        try {
            BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
            if (almExt != null) {
                switch (pId) {
                    case 35: {
                        almExt.set(BBacnetTrendLogAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 72: {
                        almExt.set(BBacnetTrendLogAlarmSourceExt.notifyType, (BValue)BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 17: {
                        long ncinst = AsnUtil.fromAsnUnsignedInteger(val);
                        if (ncinst > 0x3FFFFEL) {
                            return new NErrorType(2, 37);
                        }
                        BBacnetObjectIdentifier ncid = BBacnetObjectIdentifier.make(15, (int)ncinst);
                        BBacnetNotificationClassDescriptor nc = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(ncid);
                        if (nc == null) {
                            return new NErrorType(2, 37);
                        }
                        BAlarmClass ac = nc.getAlarmClass();
                        almExt.setString(BBacnetTrendLogAlarmSourceExt.alarmClass, ac.getName(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 137: {
                        almExt.setNotificationThreshold(AsnUtil.fromAsnUnsignedInteger(val));
                        return null;
                    }
                    case 0: 
                    case 130: 
                    case 140: 
                    case 173: 
                    case 351: {
                        return new NErrorType(2, 40);
                    }
                    case 352: {
                        return BBacnetTrendLogDescriptor.writeMessageTextsConfig(ndx, val, almExt);
                    }
                    case 353: {
                        this.setBoolean(eventDetectionEnable, AsnUtil.fromAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            switch (pId) {
                case 205: {
                    return new NErrorType(2, 40);
                }
                case 142: {
                    if (!(this.getLog().getActivePeriod() instanceof BBacnetActivePeriod)) break;
                    BBacnetActivePeriod activePeriodSta = (BBacnetActivePeriod)this.getLog().getActivePeriod();
                    BBacnetDateTime startTime = (BBacnetDateTime)activePeriodSta.getStartTime().newCopy();
                    AsnUtil.fromAsn(val, (BValue)startTime);
                    BBacnetTrendLogDescriptor.checkForSpecialValues(startTime);
                    activePeriodSta.set(BBacnetActivePeriod.startTime, (BValue)startTime, BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 143: {
                    if (!(this.getLog().getActivePeriod() instanceof BBacnetActivePeriod)) break;
                    BBacnetActivePeriod activePeriodSto = (BBacnetActivePeriod)this.tlog.getActivePeriod();
                    BBacnetDateTime stopTime = (BBacnetDateTime)activePeriodSto.getStopTime().newCopy();
                    AsnUtil.fromAsn(val, (BValue)stopTime);
                    BBacnetTrendLogDescriptor.checkForSpecialValues(stopTime);
                    activePeriodSto.set(BBacnetActivePeriod.stopTime, (BValue)stopTime, BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 134: {
                    long interval = AsnUtil.fromAsnUnsignedInteger(val) * 10L;
                    BObject o = (BObject)this.getLog();
                    if (!this.isDynamicallyCreated() && !BacnetDescriptorUtil.isGenericTrendLogExtension(this.tlog)) {
                        return new NErrorType(2, 40);
                    }
                    ((BIntervalHistoryExt)o).setInterval(BRelTime.make((long)interval));
                    return null;
                }
                case 127: {
                    if (this.getPoint() == null) {
                        return new NErrorType(2, 8);
                    }
                    asnIn.setBuffer(val);
                    BBacnetClientCov bacnetClientCov = new BBacnetClientCov();
                    bacnetClientCov.readAsn(asnIn);
                    BStatusNumeric covIncrement = bacnetClientCov.getIncrement();
                    double covRealIncrement = 0.0;
                    if (!covIncrement.getStatus().equals((Object)BStatus.nullStatus)) {
                        covRealIncrement = covIncrement.getNumeric();
                    }
                    if (this.tlog instanceof BNumericCovHistoryExt) {
                        ((BNumericCovHistoryExt)this.tlog).setChangeTolerance(covRealIncrement);
                    } else if (this.tlog instanceof BBacnetNumericTrendLogRemoteExt) {
                        ((BBacnetNumericTrendLogRemoteExt)this.tlog).setChangeTolerance(covRealIncrement);
                    } else if (this.tlog instanceof BBacnetNumericTrendLogExt) {
                        ((BBacnetNumericTrendLogExt)this.tlog).setChangeTolerance(covRealIncrement);
                    } else if (!covIncrement.getStatus().equals((Object)BStatus.nullStatus)) {
                        return new NErrorType(2, 8);
                    }
                    this.setClientCovIncrement(bacnetClientCov);
                    return null;
                }
                case 128: {
                    BBacnetProxyExt ext;
                    BControlPoint point;
                    SlotCursor c;
                    int lifeTime = AsnUtil.fromAsnUnsignedInt(val);
                    if (BacnetDescriptorUtil.isGenericTrendLogExtension(this.getLog())) {
                        return this.writeCovResubscriptionIntervalToGenericTrengLog(this.tlog, lifeTime);
                    }
                    if (!(this.tlog instanceof BCovHistoryExt) || !(c = (point = this.getPoint()).getProperties()).next(BBacnetProxyExt.class) || (ext = (BBacnetProxyExt)c.get()) == null || !ext.isCOV()) break;
                    BBacnetTuningPolicy bacnetTuningPolicy = (BBacnetTuningPolicy)ext.getTuningPolicy();
                    bacnetTuningPolicy.setCovSubscriptionLifetime(lifeTime / 30);
                    return null;
                }
            }
        }
        catch (OutOfRangeException e) {
            logger.info("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            logger.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            logger.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return new NErrorType(2, 32);
    }

    private static ErrorType writeMessageTextsConfig(int ndx, byte[] val, BBacnetTrendLogAlarmSourceExt alarmExt) throws AsnException {
        if (ndx < -1 || ndx > 3) {
            return new NErrorType(2, 42);
        }
        switch (ndx) {
            case 0: {
                return new NErrorType(2, 40);
            }
            case -1: {
                BBacnetArray textsConfig = new BBacnetArray(BString.TYPE, 3);
                AsnUtil.fromAsn(-4, val, (BValue)textsConfig);
                String toOffnormalText = textsConfig.getElement(1).toString(null);
                String toFaultText = textsConfig.getElement(2).toString(null);
                String toNormalText = textsConfig.getElement(3).toString(null);
                if (!toOffnormalText.isEmpty() || !toFaultText.isEmpty()) {
                    return new NErrorType(2, 40);
                }
                alarmExt.set(BBacnetTrendLogAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)toNormalText), BLocalBacnetDevice.getBacnetContext());
                break;
            }
            case 1: 
            case 2: {
                if (AsnUtil.fromAsnCharacterString(val).isEmpty()) break;
                return new NErrorType(2, 40);
            }
            case 3: {
                alarmExt.set(BBacnetTrendLogAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)AsnUtil.fromAsnCharacterString(val)), BLocalBacnetDevice.getBacnetContext());
            }
        }
        return null;
    }

    private int[] getOptionalProps() {
        ArrayList<BBacnetPropertyIdentifier> v = new ArrayList<BBacnetPropertyIdentifier>();
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.logInterval);
        v.add(BBacnetPropertyIdentifier.trigger);
        if (BacnetDescriptorUtil.isGenericTrendLogExtension(this.tlog)) {
            v.add(BBacnetPropertyIdentifier.covResubscriptionInterval);
            v.add(BBacnetPropertyIdentifier.clientCovIncrement);
            v.add(BBacnetPropertyIdentifier.logDeviceObjectProperty);
            v.add(BBacnetPropertyIdentifier.notificationThreshold);
            v.add(BBacnetPropertyIdentifier.recordsSinceNotification);
            v.add(BBacnetPropertyIdentifier.lastNotifyRecord);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.startTime);
            v.add(BBacnetPropertyIdentifier.stopTime);
        } else {
            BControlPoint point = this.getPoint();
            if (point != null) {
                BBacnetTrendLogAlarmSourceExt almExt;
                BIBacnetExportObject logObject;
                BBacnetObjectIdentifier logObjId;
                BOrd pointOrd = point.getHandleOrd();
                BAbstractProxyExt pxExt = point.getProxyExt();
                if (this.tlog instanceof BCovHistoryExt) {
                    if (pxExt instanceof BBacnetProxyExt && ((BBacnetProxyExt)pxExt).isCOV()) {
                        v.add(BBacnetPropertyIdentifier.covResubscriptionInterval);
                    }
                    v.add(BBacnetPropertyIdentifier.clientCovIncrement);
                }
                if ((logObjId = BBacnetNetwork.localDevice().lookupBacnetObjectId(pointOrd)) != null && (logObject = BBacnetNetwork.localDevice().lookupBacnetObject(logObjId)) != null) {
                    v.add(BBacnetPropertyIdentifier.logDeviceObjectProperty);
                }
                if (this.tlog != null && this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) {
                    v.add(BBacnetPropertyIdentifier.startTime);
                    v.add(BBacnetPropertyIdentifier.stopTime);
                }
                if ((almExt = this.getAlarmExt()) != null) {
                    v.add(BBacnetPropertyIdentifier.notificationThreshold);
                    v.add(BBacnetPropertyIdentifier.recordsSinceNotification);
                    v.add(BBacnetPropertyIdentifier.lastNotifyRecord);
                    v.add(BBacnetPropertyIdentifier.notificationClass);
                    v.add(BBacnetPropertyIdentifier.eventEnable);
                    v.add(BBacnetPropertyIdentifier.ackedTransitions);
                    v.add(BBacnetPropertyIdentifier.notifyType);
                    v.add(BBacnetPropertyIdentifier.eventTimeStamps);
                    v.add(BBacnetPropertyIdentifier.eventMessageTexts);
                    v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
                    v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
                }
            }
        }
        this.optionalProps = new int[v.size()];
        for (int i = 0; i < this.optionalProps.length; ++i) {
            this.optionalProps[i] = ((BEnum)v.get(i)).getOrdinal();
        }
        return this.optionalProps;
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    final BIBacnetTrendLogExt getLog(boolean forceful) {
        if (forceful) {
            this.tlog = null;
        }
        return this.getLog();
    }

    final BIBacnetTrendLogExt getLog() {
        if (this.tlog == null) {
            return this.findLog();
        }
        if (this.tlog == null && this.isDynamicallyCreated()) {
            this.tlog = new BBacnetNumericTrendLogExt();
        }
        return this.tlog;
    }

    public BBacnetTrendLogAlarmSourceExt getAlarmExt() {
        return BacnetTrendLogUtil.getAlarmExt(this.tlog);
    }

    @Override
    public BControlPoint getPoint() {
        return this.tlog != null ? (BControlPoint)((BHistoryExt)this.tlog).getParent() : null;
    }

    private static void checkForSpecialValues(BBacnetDateTime dateTime) throws OutOfRangeException {
        BBacnetDate date = dateTime.getDate();
        BBacnetTime time = dateTime.getTime();
        if (BBacnetTrendLogDescriptor.allUnspecified(date) && BBacnetTrendLogDescriptor.allUnspecified(time)) {
            return;
        }
        if (date.getYear() == -1 || BBacnetTrendLogDescriptor.monthHasSpecialValue(date.getMonth()) || BBacnetTrendLogDescriptor.dayHasSpecialValue(date.getDayOfMonth()) || date.getDayOfWeek() == -1) {
            throw new OutOfRangeException("Date contains Special Values.");
        }
        if (time.isHourUnspecified() || time.isMinuteUnspecified() || time.isSecondUnspecified() || time.isHundredthUnspecified()) {
            throw new OutOfRangeException("Time contains Special Values.");
        }
    }

    private static boolean allUnspecified(BBacnetTime time) {
        return time.isHourUnspecified() && time.isMinuteUnspecified() && time.isSecondUnspecified() && time.isHundredthUnspecified();
    }

    private static boolean allUnspecified(BBacnetDate date) {
        return date.isYearUnspecified() && date.isMonthUnspecified() && date.isDayOfMonthUnspecified() && date.isDayOfWeekUnspecified();
    }

    private static boolean monthHasSpecialValue(int month) {
        return month == -1 || month == 13 || month == 14;
    }

    private static boolean dayHasSpecialValue(int day) {
        return day == -1 || day == 32 || day == 33 || day == 34 || day == 35;
    }

    private BIBacnetTrendLogExt findLog() {
        try {
            if (!logOrd.isEquivalentToDefaultValue((BValue)this.getLogOrd()) || this.isDynamicallyCreated() && this.getLogOrd() != null && !this.getLogOrd().isNull()) {
                BObject o = this.getLogOrd().get((BObject)this);
                this.tlog = o instanceof BIBacnetTrendLogExt ? (BIBacnetTrendLogExt)o : null;
            }
        }
        catch (Exception e) {
            logger.warning("Unable to resolve log ord for " + this + ": " + this.getLogOrd());
            this.tlog = null;
        }
        if (this.tlog == null && this.isRunning()) {
            this.setFaultCause("Cannot find exported history");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        if (this.isDynamicallyCreated() && this.tlog == null) {
            this.tlog = new BBacnetNumericTrendLogExt();
            BBacnetTrendLogAlarmSourceExt ext = new BBacnetTrendLogAlarmSourceExt();
            ext.setAlarmEnable(BAlarmTransitionBits.EMPTY);
            ((BComponent)this.tlog).add("BBacnetTrendLogAlarmSourceExt", (BValue)ext);
        }
        return this.tlog;
    }

    private BIHistory getHistory(HistoryDatabaseConnection conn) {
        BHistoryConfig config;
        BHistoryId id;
        BIBacnetTrendLogExt tlog = this.getLog();
        BIHistory history = tlog.getHistory();
        if (history == null && conn.exists(id = (config = tlog.getHistoryConfig()).getId())) {
            history = conn.getHistory(id);
        }
        return history;
    }

    private HistoryDatabaseConnection getHistoryDbConnection(Context cx) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        return db.getDbConnection(null);
    }

    private BBacnetDeviceObjectPropertyReference getLogDOPRef() {
        BControlPoint controlPoint;
        BBacnetDeviceObjectPropertyReference dopRef = NULL_DOPR;
        if (this.tlog == null) {
            this.findLog();
        }
        if ((controlPoint = this.getPoint()) == null) {
            return dopRef;
        }
        BOrd pointOrd = controlPoint.getHandleOrd();
        BBacnetObjectIdentifier logObjId = BBacnetNetwork.localDevice().lookupBacnetObjectId(pointOrd);
        if (logObjId != null) {
            dopRef = new BBacnetDeviceObjectPropertyReference(logObjId);
        } else {
            BAbstractProxyExt pxExt = controlPoint.getProxyExt();
            if (pxExt instanceof BBacnetProxyExt) {
                BBacnetProxyExt bacPxExt = (BBacnetProxyExt)pxExt;
                dopRef = new BBacnetDeviceObjectPropertyReference(bacPxExt.getObjectId(), bacPxExt.getPropertyId().getOrdinal(), bacPxExt.getPropertyArrayIndex(), bacPxExt.device().getObjectId());
            }
        }
        return dopRef;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetTrendLogDescriptor", 2);
        out.prop((Object)"tlog", (Object)this.tlog);
        out.prop((Object)"logSubscriber", (Object)this.logSubscriber);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, this.getOptionalProps());
    }

    @Override
    public boolean isDynamicallyCreated() {
        return this.getDynamicallyCreated();
    }

    private BComponent getTargetPoint(PropertyValue pv) {
        try {
            if (pv == null) {
                return this.targetPoint;
            }
            this.targetPoint = BacnetDescriptorUtil.parseLogDeviceObjectProperty(pv, this.getLogDeviceObjectPropertyReference());
        }
        catch (Exception e) {
            logger.severe("Could not find the target point.");
        }
        return this.targetPoint;
    }

    private ErrorType writeCovResubscriptionIntervalToGenericTrengLog(BIBacnetTrendLogExt tlog, int lifeTime) {
        if (lifeTime > 28800) {
            return new NErrorType(5, 37);
        }
        if (tlog != null) {
            if (tlog instanceof BBacnetTrendLogRemoteExt) {
                ((BBacnetTrendLogRemoteExt)tlog).setCovResubscriptionInterval(lifeTime);
            }
            this.setCovResubscriptionInterval(lifeTime);
        }
        return null;
    }

    private int readCovResubscriptionIntervalToGenericTrengLog(BIBacnetTrendLogExt tlog, int lifeTime) {
        if (tlog != null && tlog instanceof BBacnetTrendLogRemoteExt) {
            this.setCovResubscriptionInterval(((BBacnetTrendLogRemoteExt)tlog).getCovResubscriptionInterval());
        }
        return this.getCovResubscriptionInterval();
    }

    class BacnetTrendLogSubscriber
    extends Subscriber {
        private BBacnetTrendLogDescriptor obj;
        BHistoryConfig config;

        public BacnetTrendLogSubscriber(BBacnetTrendLogDescriptor obj, BIBacnetTrendLogExt log) {
            this.obj = obj;
            if (log != null) {
                this.config = log.getHistoryConfig();
            }
        }

        public void event(BComponentEvent event) {
            try {
                switch (event.getId()) {
                    case 0: {
                        if (!BHistoryConfig.historyName.equals(event.getSlot().asProperty())) break;
                        this.obj.checkConfiguration();
                        break;
                    }
                    case 2: {
                        BObject object = this.obj.getObject();
                        if (!(object instanceof BComplex) || BBacnetTrendLogDescriptor.this.isDynamicallyCreated() || ((BComplex)object).getPropertyInParent() != null) break;
                        ((BComponent)this.obj.getParent()).remove(this.obj.getPropertyInParent());
                    }
                }
            }
            catch (Exception e) {
                logger.info("obj=" + (Object)((Object)this.obj.getObjectId()));
            }
        }
    }
}

