/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.status.BStatus;
import javax.baja.sys.BEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetPositiveIntegerValueDescriptor
extends BBacnetAnalogValueDescriptor {
    public static final Property objectId = BBacnetPositiveIntegerValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(48));
    public static final Type TYPE = Sys.loadType(BBacnetPositiveIntegerValueDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final void validate() {
        super.validate();
        BNumber min = (BNumber)this.getPoint().getFacets().getFacet("min");
        if (min != null && this.setFaultOnOutOfRangeValue(min)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.minValue", new Object[]{0L, 0xFFFFFFFFL}));
            return;
        }
        BNumber max = (BNumber)this.getPoint().getFacets().getFacet("max");
        if (max != null && this.setFaultOnOutOfRangeValue(max)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.maxValue", new Object[]{0L, 0xFFFFFFFFL}));
            return;
        }
    }

    private boolean setFaultOnOutOfRangeValue(BNumber min) {
        if (min.getLong() < 0L || min.getLong() > 0xFFFFFFFFL) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return true;
        }
        return false;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.eventState);
    }
}

