/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BEventSaver;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetNotificationClassDescriptor
extends BComponent
implements BIBacnetExportObject,
BacnetAlarmConst,
BacnetPropertyListProvider {
    public static final Property status = BBacnetNotificationClassDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetNotificationClassDescriptor.newProperty((int)3, (String)"", null);
    public static final Property alarmClassOrd = BBacnetNotificationClassDescriptor.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property objectId = BBacnetNotificationClassDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(15), null);
    public static final Property objectName = BBacnetNotificationClassDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetNotificationClassDescriptor.newProperty((int)0, (String)"", null);
    public static final Property eventSaver = BBacnetNotificationClassDescriptor.newProperty((int)0, (BValue)new BEventSaver(), null);
    public static final Type TYPE = Sys.loadType(BBacnetNotificationClassDescriptor.class);
    private boolean fatalFault = false;
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"alarm.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private BAlarmClass ac;
    private boolean recipientListChanged = true;
    private BBacnetDestination[] recipientList = new BBacnetDestination[0];
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private static AsnInputStream asnIn = new AsnInputStream();
    private static AsnOutputStream asnOut = new AsnOutputStream();
    private static int MAX_PRIORITY = 255;
    static Logger log = Logger.getLogger("bacnet.server");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 17, 86, 1, 102};
    private static final int[] OPTIONAL_PROPS = new int[]{28};

    @Override
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getAlarmClassOrd() {
        return (BOrd)this.get(alarmClassOrd);
    }

    public void setAlarmClassOrd(BOrd v) {
        this.set(alarmClassOrd, (BValue)v, null);
    }

    @Override
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BAlarmRecipient getEventSaver() {
        return (BAlarmRecipient)this.get(eventSaver);
    }

    public void setEventSaver(BAlarmRecipient v) {
        this.set(eventSaver, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        local.unsubscribe(this, this.ac);
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(alarmClassOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
            super.changed(p, cx);
        }
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(15);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return this.getAlarmClass();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getAlarmClassOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(alarmClassOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        local.unsubscribe(this, this.ac);
        this.findAlarmClass();
        boolean configOk = true;
        if (this.ac == null) {
            this.setFaultCause("Cannot find exported alarm class");
            configOk = false;
        } else {
            local.subscribe(this, this.ac);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
        }
        if (configOk) {
            BEventSaver eventSaver = (BEventSaver)this.getEventSaver();
            BLink[] links = this.getEventSaver().getLinks((Slot)BAlarmRecipient.routeAlarm);
            for (int i = 0; i < links.length; ++i) {
                eventSaver.remove((BComplex)links[i]);
            }
            BLink link = new BLink(this.ac.getHandleOrd(), "alarm", "routeAlarm", true);
            eventSaver.add("link", (BValue)link, 4);
            String err = local.export(this);
            if (err != null) {
                this.duplicate = true;
                this.setFaultCause(err);
                configOk = false;
            } else {
                this.duplicate = false;
            }
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        this.getAlarmClass();
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        this.getAlarmClass();
        PropertyValue[] readResults = new PropertyValue[]{};
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(readResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getAlarmClass();
        if (this.ac == null) {
            return new ReadRangeAck(1, 1000);
        }
        if (rangeReference.getPropertyArrayIndex() >= 0 && !this.isArray(rangeReference.getPropertyId())) {
            return new ReadRangeAck(2, 50);
        }
        switch (rangeReference.getPropertyId()) {
            case 102: {
                rangeType = rangeReference.getRangeType();
                maxDataLength = -1;
                if (rangeReference instanceof BacnetConfirmedRequest) {
                    maxDataLength = ((BacnetConfirmedRequest)rangeReference).getMaxDataLength() - 23 + 3 + 5;
                }
                rflags = new boolean[]{false, false, false};
                list = this.getRecipientList();
                len = list.length;
                if (rangeType != 3) ** GOTO lbl70
                refNdx = (int)rangeReference.getReferenceIndex();
                count = rangeReference.getCount();
                if (refNdx > len || refNdx < 1) {
                    return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                }
                a = new Array(BBacnetDestination.class);
                itemsFound = 0;
                if (count > 0) {
                    for (i = refNdx - 1; i < len && itemsFound < count; ++itemsFound, ++i) {
                        a.add((Object)list[i]);
                    }
                    if (refNdx == 1) {
                        rflags[0] = true;
                    }
                    if (refNdx + count - 1 >= len) {
                        rflags[1] = true;
                    }
                } else if (count < 0) {
                    count = -count;
                    for (i = refNdx - 1; i >= 0 && itemsFound < count; ++itemsFound, --i) {
                        a.add((Object)list[i]);
                    }
                    a = a.reverse();
                    if (refNdx - count <= 0) {
                        rflags[0] = true;
                    }
                    if (refNdx == len) {
                        rflags[1] = true;
                    }
                } else {
                    return new ReadRangeAck(5, 7);
                }
                it = a.iterator();
                itemCount = 0;
                var13_18 = BBacnetNotificationClassDescriptor.asnOut;
                synchronized (var13_18) {
                    BBacnetNotificationClassDescriptor.asnOut.reset();
                    if (maxDataLength <= 0) ** GOTO lbl61
                    while (it.hasNext()) {
                        if (maxDataLength - BBacnetNotificationClassDescriptor.asnOut.size() >= 35) ** GOTO lbl57
                        rflags[1] = false;
                        ** GOTO lbl65
lbl57:
                        // 1 sources

                        ((BBacnetDestination)it.next()).writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                        ++itemCount;
                    }
                    ** GOTO lbl65
lbl61:
                    // 1 sources

                    itemCount = itemsFound;
                    while (it.hasNext()) {
                        ((BBacnetDestination)it.next()).writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                    }
lbl65:
                    // 3 sources

                    if (itemCount < itemsFound) {
                        rflags[2] = true;
                    }
                    return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, BBacnetNotificationClassDescriptor.asnOut.toByteArray());
                }
lbl70:
                // 1 sources

                if (rangeType == -1) {
                    rflags[0] = false;
                    itemCount = 0;
                    var8_10 = BBacnetNotificationClassDescriptor.asnOut;
                    synchronized (var8_10) {
                        BBacnetNotificationClassDescriptor.asnOut.reset();
                        if (maxDataLength > 0) {
                            for (i = 0; i < len; ++i) {
                                list[i].writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                                ++itemCount;
                                if (maxDataLength - BBacnetNotificationClassDescriptor.asnOut.size() < 35) break;
                            }
                            if (itemCount > 0) {
                                rflags[0] = true;
                            }
                            if (itemCount > 0 && itemCount == len) {
                                rflags[1] = true;
                            }
                        } else {
                            itemCount = len;
                            for (i = 0; i < len; ++i) {
                                list[i].writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                            }
                            if (itemCount > 0) {
                                rflags[0] = true;
                            }
                            if (itemCount > 0 && itemCount == len) {
                                rflags[1] = true;
                            }
                        }
                        if (itemCount < len) {
                            rflags[2] = true;
                        }
                        return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, BBacnetNotificationClassDescriptor.asnOut.toByteArray());
                    }
                }
                return new ReadRangeAck(5, 7);
            }
        }
        return new ReadRangeAck(2, 22);
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        this.getAlarmClass();
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int i;
        BAlarmClass ac = this.getAlarmClass();
        if (ac == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 102) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(8, new NErrorType(2, 50), 0L);
            }
            return this.addRecipients(propertyValue);
        }
        int propertyId = propertyValue.getPropertyId();
        for (i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        for (i = 0; i < OPTIONAL_PROPS.length; ++i) {
            if (propertyId != OPTIONAL_PROPS[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int i;
        BAlarmClass ac = this.getAlarmClass();
        if (ac == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 102) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(9, new NErrorType(2, 50), 0L);
            }
            return this.removeRecipients(propertyValue);
        }
        int propertyId = propertyValue.getPropertyId();
        for (i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        for (i = 0; i < OPTIONAL_PROPS.length; ++i) {
            if (propertyId != OPTIONAL_PROPS[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int propertyId) {
        if (propertyId == 86) {
            return true;
        }
        return propertyId == 371;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyValue readProperty(int pId, int ndx) {
        BAlarmClass ac = this.getAlarmClass();
        if (ac == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
            case 17: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(this.getObjectId().getInstanceNumber()));
            }
            case 86: {
                BAlarmPriorities pri = ac.getPriority();
                switch (ndx) {
                    case 0: {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(3L));
                    }
                    case 1: {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pri.getToOffnormal()));
                    }
                    case 2: {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pri.getToFault()));
                    }
                    case 3: {
                        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pri.getToNormal()));
                    }
                    case -1: {
                        AsnOutputStream asnOutputStream = asnOut;
                        synchronized (asnOutputStream) {
                            asnOut.reset();
                            asnOut.writeUnsignedInteger(pri.getToOffnormal());
                            asnOut.writeUnsignedInteger(pri.getToFault());
                            asnOut.writeUnsignedInteger(pri.getToNormal());
                            return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                        }
                    }
                }
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
            }
            case 1: {
                BAlarmTransitionBits bits = ac.getAckRequired();
                AsnOutputStream asnOutputStream = asnOut;
                synchronized (asnOutputStream) {
                    asnOut.reset();
                    asnOut.writeBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bits));
                    return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                }
            }
            case 102: {
                BBacnetDestination[] list = this.getRecipientList();
                AsnOutputStream asnOutputStream = asnOut;
                synchronized (asnOutputStream) {
                    asnOut.reset();
                    for (int i = 0; i < list.length; ++i) {
                        list[i].writeAsn(asnOut);
                    }
                    return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                }
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmClass ac = this.getAlarmClass();
        if (ac == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 75: 
                case 79: 
                case 371: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, val);
                }
                case 17: {
                    return new NErrorType(2, 40);
                }
                case 86: {
                    BAlarmPriorities apri = ac.getPriority();
                    try {
                        switch (ndx) {
                            case 0: {
                                return new NErrorType(2, 42);
                            }
                            case 1: {
                                ac.set(BAlarmClass.priority, (BValue)BAlarmPriorities.make((int)AsnUtil.fromAsnUnsignedInt(val), (int)apri.getToFault(), (int)apri.getToNormal()), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case 2: {
                                ac.set(BAlarmClass.priority, (BValue)BAlarmPriorities.make((int)apri.getToOffnormal(), (int)AsnUtil.fromAsnUnsignedInt(val), (int)apri.getToNormal()), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case 3: {
                                ac.set(BAlarmClass.priority, (BValue)BAlarmPriorities.make((int)apri.getToOffnormal(), (int)apri.getToFault(), (int)AsnUtil.fromAsnUnsignedInt(val)), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case -1: {
                                AsnInputStream asnInputStream = asnIn;
                                synchronized (asnInputStream) {
                                    asnIn.setBuffer(val);
                                    try {
                                        int toOffNormal = asnIn.readUnsignedInt();
                                        int toFault = asnIn.readUnsignedInt();
                                        int toNormal = asnIn.readUnsignedInt();
                                        if (toOffNormal < 0 || toFault < 0 || toNormal < 0 || toOffNormal > MAX_PRIORITY || toFault > MAX_PRIORITY || toNormal > MAX_PRIORITY) {
                                            return new NErrorType(2, 37);
                                        }
                                        return AsnUtil.peekTagAndPerform(asnIn, -1, 42, () -> ac.setPriority(BAlarmPriorities.make((int)toOffNormal, (int)toFault, (int)toNormal)));
                                    }
                                    catch (Exception e) {
                                        return new NErrorType(2, 42);
                                    }
                                }
                            }
                        }
                        return new NErrorType(2, 42);
                    }
                    catch (IllegalStateException e) {
                        return new NErrorType(2, 37);
                    }
                    catch (IllegalArgumentException e) {
                        return new NErrorType(2, 37);
                    }
                }
                case 1: {
                    AsnInputStream asnInputStream = asnIn;
                    synchronized (asnInputStream) {
                        asnIn.setBuffer(val);
                        ac.set(BAlarmClass.ackRequired, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(asnIn.readBitString()), BLocalBacnetDevice.getBacnetContext());
                    }
                    return null;
                }
                case 102: {
                    return this.writeRecipientList(val);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return new NErrorType(2, 32);
        }
        catch (OutOfRangeException e) {
            log.info("Out Of Range Exception writing property " + pId + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    public int getNotificationClass() {
        return this.getObjectId().getInstanceNumber();
    }

    public int[] getEventPriorities() {
        BAlarmPriorities pri = this.getAlarmClass().getPriority();
        return new int[]{pri.getToOffnormal(), pri.getToFault(), pri.getToNormal()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBacnetDestination[] getRecipientList() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            if (this.recipientListChanged) {
                this.buildRecipientList();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.recipientList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recipientListChanged() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            this.recipientListChanged = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final BAlarmClass getAlarmClass() {
        if (this.ac == null) {
            return this.findAlarmClass();
        }
        return this.ac;
    }

    private BAlarmClass findAlarmClass() {
        try {
            if (!alarmClassOrd.isEquivalentToDefaultValue((BValue)this.getAlarmClassOrd())) {
                BObject o = this.getAlarmClassOrd().get((BObject)this);
                this.ac = o instanceof BAlarmClass ? (BAlarmClass)o : null;
            }
            return this.ac;
        }
        catch (Exception e) {
            log.warning("Unable to resolve alarm class ord for " + this + ": " + this.getAlarmClassOrd());
            this.ac = null;
            if (this.ac == null && this.isRunning()) {
                this.setFaultCause("Cannot find exported alarm class");
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            }
            return this.ac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRecipientList() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            Array a = new Array(BBacnetDestination.class);
            Knob[] srcLinks = this.getAlarmClass().getKnobs((Slot)BAlarmClass.alarm);
            for (int i = 0; i < srcLinks.length; ++i) {
                if (!(srcLinks[i].getTargetComponent() instanceof BBacnetDestination)) continue;
                a.add((Object)((BBacnetDestination)srcLinks[i].getTargetComponent()));
            }
            this.recipientList = (BBacnetDestination[])a.trim();
            this.recipientListChanged = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorType writeRecipientList(byte[] encodedList) {
        ArrayList<BBacnetDestination> v = new ArrayList<BBacnetDestination>();
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(encodedList);
                int tag = asnIn.peekTag();
                while (tag != -1) {
                    BBacnetDestination d = new BBacnetDestination();
                    d.readAsn(asnIn);
                    v.add(d);
                    tag = asnIn.peekTag();
                }
            }
        }
        catch (AsnException e) {
            if (BBacnetErrorCode.valueOutOfRange.getTag().equals(e.getMessage())) {
                return new NErrorType(2, 37);
            }
            return new NErrorType(2, 9);
        }
        try {
            int j;
            int i;
            BAlarmClass ac = this.getAlarmClass();
            Knob[] knobs = ac.getKnobs((Slot)BAlarmClass.alarm);
            int len = knobs.length;
            boolean[] toKeep = new boolean[len];
            for (i = 0; i < v.size(); ++i) {
                boolean knobFound = false;
                BBacnetDestination dest = (BBacnetDestination)v.get(i);
                for (j = 0; j < len; ++j) {
                    if (!(knobs[j].getTargetComponent() instanceof BBacnetDestination) || !dest.destinationEquals((BBacnetDestination)knobs[j].getTargetComponent())) continue;
                    knobFound = true;
                    toKeep[j] = true;
                    break;
                }
                if (knobFound) continue;
                BBacnetDestination linkDest = null;
                BComponent alarmService = this.getAlarmClass().getParent().asComponent();
                BBacnetDestination[] dests = (BBacnetDestination[])alarmService.getChildren(BBacnetDestination.class);
                for (int k = 0; k < dests.length; ++k) {
                    if (!dest.destinationEquals(dests[k])) continue;
                    linkDest = dests[k];
                    break;
                }
                if (linkDest == null) {
                    alarmService.add(null, (BValue)dest, BLocalBacnetDevice.getBacnetContext());
                    linkDest = dest;
                }
                BLink link = new BLink(this.getAlarmClass().getHandleOrd(), "alarm", "routeAlarm", true);
                linkDest.add(null, (BValue)link, BLocalBacnetDevice.getBacnetContext());
            }
            block11: for (i = 0; i < len; ++i) {
                BComponent target;
                if (toKeep[i] || !((target = knobs[i].getTargetComponent()) instanceof BBacnetDestination)) continue;
                BLink[] tgtLinks = target.getLinks((Slot)BBacnetDestination.routeAlarm);
                for (j = 0; j < tgtLinks.length; ++j) {
                    if (tgtLinks[j].getSourceComponent() != this.getAlarmClass()) continue;
                    target.remove((BComplex)tgtLinks[j]);
                    continue block11;
                }
            }
            return null;
        }
        catch (PermissionException e) {
            log.info("PermissionException writing elements to recipientList in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NChangeListError addRecipients(PropertyValue propertyValue) {
        BAlarmClass ac = this.getAlarmClass();
        ArrayList<BBacnetDestination> v = new ArrayList<BBacnetDestination>();
        int ffen = 1;
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                int tag = asnIn.peekTag();
                while (tag != -1) {
                    BBacnetDestination d = new BBacnetDestination();
                    d.readAsn(asnIn);
                    v.add(d);
                    ++ffen;
                    tag = asnIn.peekTag();
                }
            }
        }
        catch (AsnException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AsnException occurred in addRecipients", (Throwable)((Object)e));
            }
            return new NChangeListError(8, new NErrorType(2, 9), ffen);
        }
        try {
            Knob[] knobs = ac.getKnobs((Slot)BAlarmClass.alarm);
            int len = knobs.length;
            for (int i = 0; i < v.size(); ++i) {
                boolean knobFound = false;
                BBacnetDestination dest = (BBacnetDestination)v.get(i);
                for (int j = 0; j < len; ++j) {
                    if (!(knobs[j].getTargetComponent() instanceof BBacnetDestination) || !dest.destinationEquals((BBacnetDestination)knobs[j].getTargetComponent())) continue;
                    knobFound = true;
                    break;
                }
                if (knobFound) continue;
                BBacnetDestination linkDest = null;
                BComponent alarmService = this.getAlarmClass().getParent().asComponent();
                BBacnetDestination[] dests = (BBacnetDestination[])alarmService.getChildren(BBacnetDestination.class);
                for (int k = 0; k < dests.length; ++k) {
                    if (!dest.destinationEquals(dests[k])) continue;
                    linkDest = dests[k];
                    break;
                }
                if (linkDest == null) {
                    alarmService.add(null, (BValue)dest, BLocalBacnetDevice.getBacnetContext());
                    linkDest = dest;
                }
                BLink link = new BLink(this.getAlarmClass().getHandleOrd(), "alarm", "routeAlarm", true);
                linkDest.add(null, (BValue)link, BLocalBacnetDevice.getBacnetContext());
            }
            return null;
        }
        catch (PermissionException e) {
            log.info("PermissionException adding elements to recipientList in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NChangeListError removeRecipients(PropertyValue propertyValue) {
        int j;
        BAlarmClass ac = this.getAlarmClass();
        ArrayList<BBacnetDestination> v = new ArrayList<BBacnetDestination>();
        int ffen = 1;
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                int tag = asnIn.peekTag();
                while (tag != -1) {
                    BBacnetDestination d = new BBacnetDestination();
                    d.readAsn(asnIn);
                    v.add(d);
                    ++ffen;
                    tag = asnIn.peekTag();
                }
            }
        }
        catch (AsnException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AsnException occurred in removeRecipients", (Throwable)((Object)e));
            }
            return new NChangeListError(9, new NErrorType(2, 9), ffen);
        }
        Knob[] knobs = ac.getKnobs((Slot)BAlarmClass.alarm);
        int len = knobs.length;
        for (ffen = 1; ffen <= v.size(); ++ffen) {
            BBacnetDestination dest = (BBacnetDestination)v.get(ffen - 1);
            boolean found = false;
            for (j = 0; j < len; ++j) {
                if (!(knobs[j].getTargetComponent() instanceof BBacnetDestination) || !dest.destinationEquals((BBacnetDestination)knobs[j].getTargetComponent())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new NChangeListError(9, new NErrorType(5, 81), ffen);
        }
        try {
            block10: for (int i = 0; i < v.size(); ++i) {
                BBacnetDestination dest = (BBacnetDestination)v.get(i);
                for (j = 0; j < len; ++j) {
                    if (!(knobs[j].getTargetComponent() instanceof BBacnetDestination) || !dest.destinationEquals((BBacnetDestination)knobs[j].getTargetComponent())) continue;
                    BComponent target = knobs[j].getTargetComponent();
                    BLink[] tgtLinks = target.getLinks((Slot)BBacnetDestination.routeAlarm);
                    for (int k = 0; k < tgtLinks.length; ++k) {
                        if (tgtLinks[k].getSourceComponent() != this.getAlarmClass()) continue;
                        target.remove((BComplex)tgtLinks[k]);
                        continue block10;
                    }
                    continue block10;
                }
            }
            return null;
        }
        catch (PermissionException e) {
            log.info("PermissionException removing elements to recipientList in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        BBacnetExportTable exports = null;
        BLocalBacnetDevice local = null;
        BBacnetNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exports = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            local = (BLocalBacnetDevice)parent;
            break;
        }
        if (exports == null || local == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BBacnetNetwork)local.getParent();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        Feature feature = network.getLicenseFeature();
        boolean serverLicensed = feature.getb("export", false);
        if (!serverLicensed) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetNotificationClassDescriptor", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"ac", (Object)this.ac);
        out.prop((Object)"recipientListChanged", this.recipientListChanged);
        out.trTitle((Object)"Recipient List", 2);
        for (int i = 0; i < this.recipientList.length; ++i) {
            out.prop((Object)("  " + i), (Object)this.recipientList[i]);
        }
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, OPTIONAL_PROPS);
    }
}

