/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.EnumRangeWrapper;
import javax.baja.nre.util.Array;
import javax.baja.security.PermissionException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetMultiStateValuePrioritizedDescriptor
extends BBacnetMultiStateWritableDescriptor {
    public static final Property objectId = BBacnetMultiStateValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(19));
    public static final Type TYPE = Sys.loadType(BBacnetMultiStateValuePrioritizedDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(19);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfState;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BEnumChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            v.add(BBacnetPropertyIdentifier.alarmValues);
            if (BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                v.add(BBacnetPropertyIdentifier.faultValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                if (pId == 7) {
                    AsnOutputStream asnOutputStream = asnOut;
                    synchronized (asnOutputStream) {
                        asnOut.reset();
                        BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                        int[] vals = alg.getAlarmValues().getOrdinals();
                        for (int i = 0; i < vals.length; ++i) {
                            asnOut.writeUnsignedInteger(vals[i]);
                        }
                        return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                    }
                }
                if (pId == 39) {
                    if (!BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                    AsnOutputStream asnOutputStream = asnOut;
                    synchronized (asnOutputStream) {
                        asnOut.reset();
                        BEnumFaultAlgorithm alg = (BEnumFaultAlgorithm)almExt.getFaultAlgorithm();
                        int[] validVals = alg.getValidValues().getOrdinals();
                        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                        int[] rangeVals = r.getOrdinals();
                        for (int i = 0; i < rangeVals.length; ++i) {
                            boolean valid = false;
                            for (int j = 0; j < validVals.length; ++j) {
                                if (rangeVals[i] != validVals[j]) continue;
                                valid = true;
                                break;
                            }
                            if (valid) continue;
                            asnOut.writeUnsignedInteger(rangeVals[i]);
                        }
                        return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "AsnException occurred in readOptionalProperty", e);
                return new NReadPropertyResult(pId, ndx, new NErrorType(0, 25));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                if (pId == 7) {
                    BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                    BEnumRange alarmValueRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                    EnumRangeWrapper enumRangeWrapper = this.getWritableEnumRange(val, alarmValueRange, false);
                    if (enumRangeWrapper.getErrorType() == null) {
                        alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)enumRangeWrapper.getEnumRange(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return enumRangeWrapper.getErrorType();
                }
                if (pId == 35) {
                    almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                if (pId == 39) {
                    if (!BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                        return new NErrorType(2, 32);
                    }
                    BEnumFaultAlgorithm alg = (BEnumFaultAlgorithm)almExt.getFaultAlgorithm();
                    BEnumRange faultValueRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                    EnumRangeWrapper enumRangeWrapper = this.getWritableEnumRange(val, faultValueRange, true);
                    if (enumRangeWrapper.getErrorType() == null) {
                        alg.set(BEnumFaultAlgorithm.validValues, (BValue)enumRangeWrapper.getEnumRange(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return enumRangeWrapper.getErrorType();
                }
            }
            catch (AsnException e) {
                log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
            int propertyId = propertyValue.getPropertyId();
            if (propertyId == 7) {
                if (propertyValue.getPropertyArrayIndex() >= 0) {
                    return new NChangeListError(8, new NErrorType(2, 50), 0L);
                }
                return this.addAlarmValues(propertyValue, alg);
            }
            if (propertyId == 39) {
                return new NChangeListError(8, new NErrorType(2, 40), 0L);
            }
        }
        return super.addListElements(propertyValue);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
            int propertyId = propertyValue.getPropertyId();
            if (propertyId == 7) {
                if (propertyValue.getPropertyArrayIndex() >= 0) {
                    return new NChangeListError(9, new NErrorType(2, 50), 0L);
                }
                return this.removeAlarmValues(propertyValue, alg);
            }
            if (propertyId == 39) {
                return new NChangeListError(9, new NErrorType(2, 40), 0L);
            }
        }
        return super.removeListElements(propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError addAlarmValues(PropertyValue propertyValue, BEnumChangeOfStateAlgorithm alg) {
        int i;
        ArrayList<BBacnetUnsigned> v = new ArrayList<BBacnetUnsigned>();
        int ffen = 1;
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                int tag = asnIn.peekTag();
                while (tag != -1) {
                    v.add(asnIn.readUnsigned());
                    ++ffen;
                    tag = asnIn.peekTag();
                }
            }
        }
        catch (AsnException e) {
            return new NChangeListError(8, new NErrorType(2, 9), ffen);
        }
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        BEnumRange almVals = alg.getAlarmValues();
        Array a = new Array(BBacnetUnsigned.class);
        int[] ordinals = almVals.getOrdinals();
        for (i = 0; i < ordinals.length; ++i) {
            a.add((Object)BBacnetUnsigned.make(ordinals[i]));
        }
        try {
            for (i = 0; i < v.size(); ++i) {
                BBacnetUnsigned u = (BBacnetUnsigned)((Object)v.get(i));
                int newOrdinal = u.getInt();
                boolean found = false;
                for (int j = 0; j < ordinals.length; ++j) {
                    if (ordinals[j] != newOrdinal) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                a.add((Object)u);
            }
            BBacnetUnsigned[] newUVals = (BBacnetUnsigned[])a.trim();
            int[] newOrdinals = new int[newUVals.length];
            String[] newTags = new String[newUVals.length];
            for (int i2 = 0; i2 < newOrdinals.length; ++i2) {
                newOrdinals[i2] = newUVals[i2].getInt();
                newTags[i2] = r.getTag(newOrdinals[i2]);
            }
            alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)BEnumRange.make((int[])newOrdinals, (String[])newTags), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (PermissionException e) {
            log.info("PermissionException adding elements to alarmValues in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError removeAlarmValues(PropertyValue propertyValue, BEnumChangeOfStateAlgorithm alg) {
        ArrayList<BBacnetUnsigned> v = new ArrayList<BBacnetUnsigned>();
        int ffen = 1;
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                int tag = asnIn.peekTag();
                while (tag != -1) {
                    v.add(asnIn.readUnsigned());
                    ++ffen;
                    tag = asnIn.peekTag();
                }
            }
        }
        catch (AsnException e) {
            logger.log(Level.SEVERE, "AsnException occurred in removeAlarmValues", (Throwable)((Object)e));
            return new NChangeListError(9, new NErrorType(2, 9), ffen);
        }
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        BEnumRange almVals = alg.getAlarmValues();
        Array a = new Array(BBacnetUnsigned.class);
        int[] ordinals = almVals.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            a.add((Object)BBacnetUnsigned.make(ordinals[i]));
        }
        try {
            for (ffen = 1; ffen <= v.size(); ++ffen) {
                BBacnetUnsigned u = (BBacnetUnsigned)((Object)v.get(ffen - 1));
                if (!a.contains((Object)u)) {
                    return new NChangeListError(9, new NErrorType(5, 81), ffen);
                }
                a.remove((Object)u);
            }
            BBacnetUnsigned[] newUVals = (BBacnetUnsigned[])a.trim();
            int[] newOrdinals = new int[newUVals.length];
            String[] newTags = new String[newUVals.length];
            for (int i = 0; i < newOrdinals.length; ++i) {
                newOrdinals[i] = newUVals[i].getInt();
                newTags[i] = r.getTag(newOrdinals[i]);
            }
            alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)BEnumRange.make((int[])newOrdinals, (String[])newTags), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (PermissionException e) {
            log.info("PermissionException removing elements from alarmValues in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
    }
}

