/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetLargeAnalogValueDescriptor
extends BBacnetAnalogValueDescriptor {
    public static final Property objectId = BBacnetLargeAnalogValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(46));
    public static final Type TYPE = Sys.loadType(BBacnetLargeAnalogValueDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnDouble(value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnDouble(value);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.remove(BBacnetPropertyIdentifier.outOfService);
        v.remove(BBacnetPropertyIdentifier.priorityArray);
        v.remove(BBacnetPropertyIdentifier.relinquishDefault);
        v.remove(BBacnetPropertyIdentifier.eventState);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.eventState);
    }
}

